<?php

namespace alipay\v2\aop;

require_once 'AopClient.php';
require_once 'AopCertClient.php';
require_once 'AopCertification.php';
require_once 'AlipayConfig.php';


class Alipay{
    
    protected $config = [];
    
    public function __construct($config=[]) {
        $this->config = [
            "appid"=>$config['zfb_appid'],// 支付宝应用ID
            "alipayPublicKey"=>$config['zfb_publickey_cert'],// 支付宝公钥证书
            "appCertPublicKey"=>$config['zfb_app_cert'],// 应用证书
            "alipayRootCert"=>$config['zfb_root_cert'],//支付宝根证书
            "privateKey"=>$config['zfb_privateKey'],// 应用私钥
            "return_url"=>$config['return_url'],// 支付返还地址
            "notify_url"=>$config['notify_url'],// 支付回调通知地址
        ];
    }
    
    protected function json($code,$msg,$data=[]){
        return ['code'=>$code,'message'=>$msg,'data'=>$data];
    }
    
    public function wapPay($data){
        require_once 'request/AlipayTradeWapPayRequest.php';
        
        $alipayClient = $this->AopCertClient();
        // 构造请求参数以调用接口
        $request = new \AlipayTradeWapPayRequest();
        $request->setBizContent(json_encode($data,JSON_UNESCAPED_UNICODE));
        $request->setNotifyUrl($this->config['notify_url']);
        $request->setReturnUrl($this->config['return_url']);
        
        // echo "<pre>";
        // print_r($alipayClient);die;
        
        // $responseResult = $alipayClient->execute($request);
        // print_r($responseResult);die;
        
        // 如果是第三方代调用模式，请设置app_auth_token（应用授权令牌）
        // $pageRedirectionData = $alipayClient->pageExecute($request, "POST");
        // 如果需要返回GET请求，请使用
        $pageRedirectionData = $alipayClient->pageExecute($request, "GET");
        file_put_contents("alipay_wapPay.txt",$pageRedirectionData);
        // print_r($pageRedirectionData);die;
        if(empty($pageRedirectionData)){
            return $this->json(0,"操作失败");
        }
        
        return $this->json(1,"操作成功",['url'=>$pageRedirectionData]);
    }
    
    public function unifiedConnect($class_name,$data){
        
        require_once 'request/'.$class_name.'.php';
        $class = "\\".$class_name;
        
        // require_once 'request/AlipayTradeWapPayRequest.php';
        // print_r($class);die;
        // 初始化SDK
        $alipayClient = $this->AopCertClient();
        // 构造请求参数以调用接口
        $request = new $class();
        // $request = new \AlipayTradeWapPayRequest();
        $request->setBizContent(json_encode($data,JSON_UNESCAPED_UNICODE));
        
        $responseResult = $alipayClient->execute($request);
        // print_r(json_encode($responseResult));die;
        $responseApiName = str_replace(".","_",$request->getApiMethodName())."_response";
        $response = $responseResult->$responseApiName;
        // echo "<pre>";
        
        $result = json_decode(json_encode($response),true);
        // echo "<pre>";
        // print_r($result);die;
        file_put_contents("alipay111.txt",json_encode($result));
        if($result['code'] == 10000){
            return $this->json(1, "操作成功",$result);
        }
        else{
            if(!empty($result['sub_msg'])){
                return $this->json(0, $result['sub_msg']);
            }
            return $this->json(0, $result['msg']);
        }
    }
    
    
    public function AopCertClient(){
        // 接口加签方式 公钥证书
        $set = $this->config;
        
        // file_put_contents("alipay111.txt",json_encode($set));
        
        $aop = new \AopCertClient;
        $appCertPath = $set['appCertPublicKey'];
        $alipayCertPath = $set['alipayPublicKey'];
        $rootCertPath = $set['alipayRootCert'];
        
        $aop->gatewayUrl = "https://openapi.alipay.com/gateway.do";
        $aop->appId = $set['appid'];
        $aop->rsaPrivateKey = $set['privateKey'];
        // $aop->appId = '';
        // $aop->rsaPrivateKey = '';
        $aop->format = "json";
        $aop->charset= "GBK";
        if($set['sign_type']){
            $aop->signType= $set['sign_type'];
        }
        else{
            $aop->signType= "RSA2";
        }
        
        if($set['return_url']){
            $aop->returnUrl= $set['return_url'];
        }
        if($set['notify_url']){
            $aop->notifyUrl= $set['notify_url'];
        }
        
        //调用getPublicKey从支付宝公钥证书中提取公钥
        // $aop->alipayrsaPublicKey = $aop->getPublicKey($alipayCertPath);
        $aop->alipayrsaPublicKey = file_get_contents($alipayCertPath);
        // $aop->alipayrsaPublicKey = '';
        //是否校验自动下载的支付宝公钥证书，如果开启校验要保证支付宝根证书在有效期内
        $aop->isCheckAlipayPublicCert = true;
        //调用getCertSN获取证书序列号
        // $aop->appCertSN = $aop->getCertSN($appCertPath);
        //调用getRootCertSN获取支付宝根证书序列号
        // $aop->alipayRootCertSN = $aop->getRootCertSN($rootCertPath);
        // file_put_contents("alipay111.txt",json_encode($set));
        return $aop;
    }
}