<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Db;
use think\Model;


class User extends Model
{
    protected $name = 'bbfx_user';

    public static function uuid(){
        $uid = 0;
        while(true){
            $uid = random_int(100000000, 999999999);
            $user = Db::name("bbfx_user")->where(['id'=>$uid])->count();
            if(empty($user)){
                break;
            }
        }
        
        return $uid;
    }
    
    public static function isSupUser($user_id,$uid){
        $user = Db::name("bbfx_user")->where(['id'=>$user_id])->field("id,sup_uid")->find();
        if(empty($user)){
            return true;
        }
        if($user['sup_uid'] == $uid){
            return false;
        }
        
        return self::isSupUser($user['sup_uid'],$uid);
    }
    
    public static function initSupPath($user_id=0,$sup_path="0"){
        
        if($user_id == 0){
            $list = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'sup_uid'=>0])->field(['id','sup_uid','sup_path'])->select();
        }
        else{
            $list = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'sup_uid'=>$user_id])->field(['id','sup_uid','sup_path'])->select();
        }
        if(!empty($list)){
            foreach ($list as $key => $val){
                Db::name("bbfx_user")->where(['id'=>$val['id']])->update(['sup_path'=>$sup_path."-".$val['id']]);
                self::initSupPath($val['id'],$sup_path."-".$val['id']);
            }
        }
    }
    
    public static function getLevel1UserIds($user_id){
        $list = Db::name("bbfx_user")->where(['sup_uid'=>$user_id,'uniacid'=>UNIACID])->field("id")->select();
        
        $ids = [-1];
        
        if(!empty($list)){
            $ids = array_column($list,"id");
        }
        
        return $ids;
    }
    
    public static function getSupUser($user_id){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        
        $where = ['id'=>intval($user_id)];
        if($base['fenxiao']['ordinary_user_share'] == 1){
            $sup_user = Db::name("bbfx_user")->where($where)->find();
            return $sup_user;
        }
        else if($base['fenxiao']['ordinary_user_share'] == 2){
            $sup_user = Db::name("bbfx_user")->where($where)->find();
            if(empty($sup_user)){
                return false;
            }
            if($sup_user['is_distributor'] == 1 && $sup_user['distributor_status'] == 1){
                return $sup_user;
            }
            return self::getSupUser($sup_user['sup_uid']);
        }
        else{
            $where['is_distributor'] = 1;
            $where['distributor_status'] = 1;
            $sup_user = Db::name("bbfx_user")->where($where)->find();
            return $sup_user;
        }
    }
    
    public static function getUserDiscount($user,$levels = []){
        if(empty($levels)){
            $levels = \app\common\model\bbfxshop\Fenxiao::getLevels(1);
        }
        
        if(!is_array($user)){
            $user = self::getInfo($user);
        }
        
        $discount = 10;
        if($user['is_distributor'] == 1 && $user['distributor_status'] == 1){
            $discount = floatval($levels[$user['level']]['discount']);
            if($discount > 10 || $discount <= 0){
                $discount = 10;
            }
        }
        
        return $discount;
    }
    
    public static function getTypeText($type){
        $list = [
            "1"=>"商品支付",
            "2"=>"积分商品兑换",
            "3"=>"后台充值",
            "4"=>"订单退款",
            "5"=>"余额/积分提现",
            "6"=>"拒绝提现",
            "7"=>"充值余额",
            "8"=>"充值积分",
            "9"=>"佣金提现打款",
            "10"=>"余额/积分返还",
            "11"=>"佣金结算",
            "12"=>"资金转账",
            "21"=>"会员卡赠送",
            "22"=>"收益冻结",
            "23"=>"收益解冻",
            "24"=>"复购赠送",
            "25"=>"订单关闭退回(复购金)",
            "26"=>"累计返还",
            "27"=>"云仓进货返还",
            "28"=>"排队免单",
            "29"=>"轮盘抽奖",
            "30"=>"红包发放",
            "31"=>"资产分红",
            "32"=>"预存款存入",
            "33"=>"预存款释放",
            "34"=>"签到奖励",
            "35"=>"储值利息",
            "36"=>"拼团未拼中奖励",
            "37"=>"佣金结算奖励",
            "38"=>"消费金额贡献",
            "39"=>"直推业绩贡献",
            "40"=>"团队业绩贡献",
            "41"=>"礼品金额提现",
        ];
        
        return $list[$type];
    }
    
    public static function setUserMoney($user_id,$money,$type=0,$item_type=0,$remarks = "",$info = [],$createtime=0){
        // 操作类型:1=商品支付,2=积分商品兑换,3=后台充值,4=订单退款,5=余额/积分提现,6=拒绝提现,7=充值余额,8=充值积分,9=佣金提现打款,10=余额/积分返还,11=佣金结算,12=资金转账,21=会员卡赠送,22=收益冻结,23=收益解冻,24=复购赠送,25=订单关闭退回(复购金),26=累计返还,27=云仓进货返还,28=排队免单,29=轮盘抽奖,30=红包发放,31=资产分红,32=预存款存入,33=预存款释放,34=签到奖励,35=储值利息,36=拼团未拼中奖励,37=佣金结算奖励,38=消费金额贡献,39=直推业绩贡献,40=团队业绩贡献
        // 金额类型:1=余额,2=积分,3=创业基金（2+1模式）,4=复购金,5=红包金额,6=预存款,7=冻结收益,8=贡献值
        $user = self::getInfo($user_id);
        if(empty($user)){
            return false;
        }
        
        $money = floatval($money);
        
        if(intval($createtime) <= 0){
            $createtime = time();
        }
        
        $success = true;
        try {
            Db::startTrans();
            if($type == 1){
                if($money > 0){
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setInc("balance",$money);
                }
                else{
                    $pmoney = abs($money);
                    if($user['balance'] < $pmoney){
                        throw new \Exception("余额不足");
                    }
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setDec("balance",$pmoney);
                }
                if(empty($res)){
                    throw new \Exception("余额不足");
                }
                $nuser = self::getInfo($user_id);
                $befores = $user['balance'];
                $afters = $nuser['balance'];
            }
            else if($type == 2){
                if($money > 0){
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setInc("score",$money);
                }
                else{
                    $pmoney = abs($money);
                    if($user['score'] < $pmoney){
                        throw new \Exception("积分不足");
                    }
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setDec("score",$pmoney);
                }
                if(empty($res)){
                    throw new \Exception("积分不足");
                }
                $nuser = self::getInfo($user_id);
                $befores = $user['score'];
                $afters = $nuser['score'];
            }
            else if($type == 3){
                if($money > 0){
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setInc("freeze_money",$money);
                }
                else{
                    $pmoney = abs($money);
                    if($user['freeze_money'] < $pmoney){
                        throw new \Exception("冻结收益不足");
                    }
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setDec("freeze_money",$pmoney);
                }
                if(empty($res)){
                    throw new \Exception("冻结收益不足");
                }
                $nuser = self::getInfo($user_id);
                $befores = $user['freeze_money'];
                $afters = $nuser['freeze_money'];
            }
            else if($type == 4){
                if($money > 0){
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setInc("repurchase_currency",$money);
                }
                else{
                    $pmoney = abs($money);
                    if($user['repurchase_currency'] < $pmoney){
                        throw new \Exception("复购金不足");
                    }
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setDec("repurchase_currency",$pmoney);
                }
                if(empty($res)){
                    throw new \Exception("复购金不足");
                }
                $nuser = self::getInfo($user_id);
                $befores = $user['repurchase_currency'];
                $afters = $nuser['repurchase_currency'];
            }
            else if($type == 5){
                if($money > 0){
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setInc("redpacket_money",$money);
                }
                else{
                    $pmoney = abs($money);
                    if($user['redpacket_money'] < $pmoney){
                        throw new \Exception("红包金额不足");
                    }
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setDec("redpacket_money",$pmoney);
                }
                if(empty($res)){
                    throw new \Exception("红包金额不足");
                }
                $nuser = self::getInfo($user_id);
                $befores = $user['redpacket_money'];
                $afters = $nuser['redpacket_money'];
            }
            else if($type == 6){
                if($money > 0){
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setInc("deposit_money",$money);
                }
                else{
                    $pmoney = abs($money);
                    if($user['deposit_money'] < $pmoney){
                        throw new \Exception("预存款金额不足");
                    }
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setDec("deposit_money",$pmoney);
                }
                if(empty($res)){
                    throw new \Exception("预存款金额不足");
                }
                $nuser = self::getInfo($user_id);
                $befores = $user['deposit_money'];
                $afters = $nuser['deposit_money'];
            }
            else if($type == 7){
                if($money > 0){
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setInc("freeze_commission",$money);
                }
                else{
                    $pmoney = abs($money);
                    if($user['freeze_commission'] < $pmoney){
                        throw new \Exception("冻结收益不足");
                    }
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setDec("freeze_commission",$pmoney);
                }
                if(empty($res)){
                    throw new \Exception("冻结收益不足");
                }
                $nuser = self::getInfo($user_id);
                $befores = $user['freeze_commission'];
                $afters = $nuser['freeze_commission'];
            }
            else if($type == 8){
                if($money > 0){
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setInc("contribution_value",$money);
                }
                else{
                    $pmoney = abs($money);
                    if($user['contribution_value'] < $pmoney){
                        throw new \Exception("贡献值不足");
                    }
                    $res = Db::name("bbfx_user")->where(['id'=>$user_id])->setDec("contribution_value",$pmoney);
                }
                if(empty($res)){
                    throw new \Exception("贡献值不足");
                }
                $nuser = self::getInfo($user_id);
                $befores = $user['contribution_value'];
                $afters = $nuser['contribution_value'];
            }
            else{
                throw new \Exception("类型错误");
            }
            
            
            
            $data = array(
                "uniacid"=>UNIACID,
                "user_id"=>$user_id,
                "money"=>$money,
                "befores"=>$befores,
                "afters"=>$afters,
                "remarks"=>$remarks,
                "info"=>iserializer($info),
                "type"=>$type,
                "item_type"=>$item_type,
                "createtime"=>$createtime
            );
            
            if(!empty($info['id'])){
                $data['item_id'] = $info['id'];
            }
            if(!empty($info['extend'])){
                $data['extend'] = $info['extend'];
            }
            
            $id = Db::name("bbfx_money_log")->insertGetId($data);
            
            Db::commit();
        } 
        catch (\Exception $e) {
            $success = false;
            Db::rollback();
            // print_r($msg = $e->getMessage());die;
        }
        
         
        if(empty($success)){
            return false;
        }
        
        if($type == 2){
            $data['id'] = $id;
            $extend = $data;
            $content = $remarks;
            if($money > 0){
                $content .= "增加".$money."元。";
            }
            else{
                $content .= "减少".abs($money)."元。";
            }
            $params = ['type'=>3,'itype'=>3,'user_id'=>$user_id,'title'=>'余额变动通知','content'=>$content,'extend'=>$extend];
            $result = \app\common\model\bbfxshop\Notice::send($params);
        }
        
        return $id;
    }
    
    public static function getInfo($openid){
        if(intval($openid)){
            $user = Db::name("bbfx_user")->where(['id'=>intval($openid)])->find();
        }
        else{
            $user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'openid'=>$openid])->find();
        }
        
        if(!empty($user) && empty($user['avatar'])){
            $user['avatar'] = "/assets/images/avatar.jpg";
        }
        
        return $user;
    }
    
    public static function getUser($openid,$all=true){
        global $_W;
        if(empty($openid)){
            return false;
        }
        
        $user = self::getInfo($openid);
        
        if(!empty($user)){
            
            
            Db::name("bbfx_user")->where(['id'=>$user['id']])->update(['last_login_time'=>time()]);
            
            $base = $_W['base'];
            
            $user['avatar'] = cdnurl($user['avatar']);
            $user['skqrcode_attach'] = cdnurl($user['skqrcode']);
            $user['skqrcode'] = cdnurl($user['skqrcode']);
            $user['commission_total'] = round($user['commission_total'],2);
            $user['commission_ok'] = round($user['commission_ok'],2);
            if($user['is_distributor'] == 1 && $user['distributor_status'] == 1){
                $leveldata = \app\common\model\bbfxshop\Fenxiao::getLevel($user['level']);
                $user['levelname'] = $leveldata['title'];
                $user['level_icon'] = cdnurl($leveldata['thumb']);
            }
            else{
                $user['levelname'] = $base['fenxiao']['texts']['mlevel'];
                
                if(empty($user['levelname'])){
                    $user['levelname'] = "普通用户";
                }
            }
            
            $user['withdrawal_info'] = iunserializer($user['withdrawal_info']);
            
            $card = \app\common\model\bbfxshop\Card::getUserCard($user['id']);
            
            if(!empty($card)){
                if($card['endtime'] != -1){
                    $vip_endtime = date("Y-m-d",$card['endtime']); 
                    $user['vip_endtime'] = $vip_endtime;
                    $user['vip_endday'] = round(($card['endtime'] - time()) / 86400);
                }
                else{
                    $user['vip_endtime'] = "永久有效";
                    $user['vip_endday'] = "永久有效";
                }
                $user['card'] = $card;
            }
            
            if($user['agent_status'] == 1 && $user['agent_level'] > 0){
                $log_count = Db::name("bbfx_agent_log")->where(["uniacid"=>UNIACID,'user_id'=>$user['id']])->count();
                if($log_count == 0){
                    $agent_params = ['agent_province'=>$user['agent_province'],'agent_city'=>$user['agent_city'],'agent_area'=>$user['agent_area'],'agent_street'=>$user['agent_street']];
                    \app\common\model\bbfxshop\Agent::setRegion($user,$agent_params);
                }
            }
            
            if($all){

                $user['coupon_num'] = intval(Db::name("bbfx_user_coupon")->where(['uniacid'=>UNIACID,'user_id'=>$user['id']])->count());
                
                $user['createtime'] = date("Y-m-d H:i:s",$user['createtime']);
                $user['last_login_time'] = date("Y-m-d H:i:s",$user['last_login_time']);
                
                $yajin_money = Db::name("bbfx_yajin_record")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'status'=>1])->sum("money");
                $user['yajin_money'] = $yajin_money;
                
                $nextLevels = \app\common\model\bbfxshop\Fenxiao::getUplevels($user);
                if(!empty($nextLevels)){
                    $nextLevel = $nextLevels[0];
                    $conditions = iunserializer($nextLevel['conditions']);
                    if($conditions['apply'] == 1 && in_array(14,$base['fenxiao']['up_type'])){
                        $nextLevel['apply'] = 1;
                    }
                    else{
                        $nextLevel['apply'] = 0;
                    }
                    
                    if($nextLevel['id'] == 0 && $base['fenxiao']['become_agent'] == 4){
                        $nextLevel['apply'] = 1;
                    }
                    
                    if($nextLevel['apply'] == 1 && in_array(14,$base['fenxiao']['up_type']) && $base['fenxiao']['user_shenhe_apply'] == 1){
                        $sup_user = self::getInfo($user['sup_uid']);
                        if(!empty($sup_user)){
                            $levels = \app\common\model\bbfxshop\Fenxiao::getLevels(1);
                            if($levels[$sup_user['level']]['user_shenhe_apply'] == 1){
                                $level_ids = [];
                                $sort = $levels[$sup_user['level']]['sort'];
                                foreach ($levels as $key => $val){
                                    if($sort > $val['sort']){
                                        $level_ids[] = intval($val['id']);
                                    }
                                }
                                
                                if(in_array(intval($nextLevel['id']),$level_ids)){
                                    $nextLevel['apply'] = 1;
                                }
                                else{
                                    $nextLevel['apply'] = 0;
                                }
                            }
                            else{
                                $nextLevel['apply'] = 0;
                            }
                        }
                    }
                    
                    
                    
                    $user['nextLevel'] = $nextLevel;
                }
                $user['max_balance'] =$user['balance'];
                $user['max_score'] =$user['score'];
                if($base['cumulative_fanhuan']['status'] == 1){
                    $surplus = Db::name("bbfx_cumulative_fanhuan_user")->where(['uniacid'=>UNIACID,'user_id'=>$user['id']])->value("surplus");
                    $surplus = floatval($surplus);
                    
                    if($base['cumulative_fanhuan']['settlement_currency'] == 1){
                        $user['max_balance'] = round($user['balance'] + $surplus,2);
                    }
                    else{
                        $user['max_score'] = round($user['score'] + $surplus,2);
                    }
                }
                
                if($base['fenxiao']['is_ladder_abonus'] == 1){
                    $is_rule = false;
                    if($base['fenxiao']['ladder_abonus_mode'] == 2){
                        $ladder_abonus_multiple = $base['fenxiao']['ladder_abonus_multiple'];
                        foreach ($ladder_abonus_multiple as $key => $val){
                            if(empty($val['users']) || (!empty($val['users']) && in_array($user['id'],$val['users']))){
                                $is_rule = true;
                                break;
                            }
                        }
                    }
                    else{
                        $ladder_abonus = $base['fenxiao']['ladder_abonus'];
                        $is_rule = true;
                    }
                    
                    
                    if($is_rule){
                        $alldown = \app\common\model\bbfxshop\Fenxiao::getAllDown($user['id']);
                        $team_uids = [];
                        if(!empty($alldown['ids'])){
                            $team_uids = $alldown['ids'];
                        }
                        $team_achievement = Db::name("bbfx_order")->where(['uniacid'=>$user['uniacid'],'user_id'=>['in',$team_uids],'status'=>['in',[1,2,3]]])->sum("price");
                        $ladder_abonus_levelname = "";
                        if($base['fenxiao']['ladder_abonus_mode'] == 2){
                            foreach ($ladder_abonus_multiple as $key => $val){
                                foreach ($val['rules'] as $k => $v){
                                    if($team_achievement >= intval($v['achievement'])){
                                        $ladder_abonus_levelname = $v['name'];
                                    }
                                }
                                if(!empty($ladder_abonus_levelname)){
                                    break;
                                }
                            }
                        }
                        else{
                            foreach ($ladder_abonus as $key => $val){
                                if($team_achievement >= intval($val['achievement'])){
                                    $ladder_abonus_levelname = $val['name'];
                                }
                            }
                        }
                        $user['ladder_abonus_levelname'] = $ladder_abonus_levelname;
                    }
                    
                }
                
                $stock = Db::name("bbfx_cloud_warehouse_goods")->where(['uniacid'=>$user['uniacid'],'user_id'=>$user['id']])->order("id desc")->value("stock");
                $user['cloud_warehouse_stock'] = intval($stock);
                $user['is_pay_password'] = 0;
                if(!empty($user['pay_password'])){
                   $user['is_pay_password'] = 1; 
                }
          	    $user['isAdmin'] = 0;
          	    if($base['admin']){
          	        $admin = explode(",",$base['admin']);
          	        foreach ($admin as $key => $val){
          	            if($val == $user['id']){
          	                $user['isAdmin'] = 1;
          	            }
          	        }
          	    }
            }
        }
        
        return $user;
    }
    
    public function bind($user,$sup_uid){
        global $_W;
        $fenxiao = $_W['base']['fenxiao'];
        $rebind_day = intval($fenxiao['rebind_day']);
        $sup_uid = intval($sup_uid);
        if($fenxiao['is_rebind'] != 1 || $rebind_day < 0 || $sup_uid <= 0 || $user['is_distributor'] == 1 || $user['distributor_status'] == 1 || $sup_uid == $user['sup_uid']){
            return false;
        }
        
        $time = time() - $user['bindtime'];
        if($time / 86400 < $rebind_day){
            return false;
        }
        
        $sup_user = Db::name("bbfx_user")->where(['is_distributor'=>1,'distributor_status'=>1,'id'=>$sup_uid])->find();
        if(empty($sup_user)){
            return false;
        }
        
        $order = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user['id']])->find();
        if(!empty($order)){
            return false;
        }
        
        $res = Db::name("bbfx_user")->where(['id'=>$user['id']])->update(['sup_uid'=>$sup_uid]);
        if($res){
            Db::name("bbfx_user")->where(['id'=>$user['id']])->update(['bindtime'=>time()]);
            self::initSupPath();
        }
        return $res;
    }
    
    public static function checkTxdateLimit(){
        global $_W;
        $base = $_W['base'];
        
        if($base['withdrawal']['tx_date_limit'] == 1){
            if($base['withdrawal']['tx_date_type'] == 1){
                if(!empty($base['withdrawal']['tx_day']) && !in_array(date("d"),$base['withdrawal']['tx_day'])){
                    __error("每月".implode(",",$base['withdrawal']['tx_day'])."日等日期可提现");
                }
            }
            else{ 
                $w = date("w");
                if($w == 0) $w = 7;
                if(!in_array($w,$base['withdrawal']['tx_week'])){
                    __error("每周".implode(",",$base['withdrawal']['tx_week'])."等日期可提现");
                }
            }
        }
    } 
    
    public static function checkStatus($user){
        if(!is_array($user)){
            $user = self::getInfo($user);
        }
        
        if(!empty($user) && $user['status'] != 1){
            __error("您的账号已被冻结，请联系管理员");
        }
    }
}
