<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use fast\Random;
use app\common\model\QRcode;

class Sverify extends Model
{
    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        
        return $base['sverify'];
    }
    
    public static function query($product_id,$code){
        
        if(empty($code)){
            return __json(0,"防伪码错误");
        }
        
        $product = Db::name("bbfx_sverify_product")->where(['code'=>$product_id,'uniacid'=>UNIACID])->find();
        if(empty($product)){
            return __json(0,"产品不存在");
        }
        
        $product_code = Db::name("bbfx_sverify_product_code")->where(['code'=>$code,'uniacid'=>UNIACID])->find();
        
        $success = 0;
        $is_first = 0;
        
        $query_success_tips = $product['query_success_tips'];
        $query_fail_tips = $product['query_fail_tips'];
        
        if(!empty($product_code) && $product['id'] == $product_code['product_id']){
            $ip = request()->ip();
            $data = array(
                "uniacid"=>UNIACID,
                "product_id"=>$product['id'],
                "code"=>$product_code['code'],
                "ip"=>$ip,
                "createtime"=>time()
            );
            
            $last = Db::name("bbfx_sverify_product_query_log")->where(['uniacid'=>UNIACID,"product_id"=>$product['id'],"code"=>$product_code['code']])->order("createtime desc")->find();
            
            Db::name("bbfx_sverify_product_query_log")->insert($data);
            
            Db::name("bbfx_sverify_product_code")->where(['id'=>$product_code['id']])->setInc("query_num",1);
            
            $success = 1;
            
            $product['image'] = cdnurl($product['image']);
            
            $product['query_num'] = $product_code['query_num'] + 1;
            
            $lasttime = "";
            if(!empty($last)){
                $lasttime = date("Y年m月d日H时i分",$last['createtime']);
            }
            else{
                $is_first = 1;
            }
            
            $replace_list = [
                ['xkey'=>'${num}','value'=>$product['query_num']],
                ['xkey'=>'${lasttime}','value'=>$lasttime],
            ];
        }
        else{
            $replace_list = [
                ['xkey'=>'${num}','value'=>""],
                ['xkey'=>'${lasttime}','value'=>""],
            ];
        }
        
        
        foreach ($replace_list as $key => $val){
            $query_success_tips = str_replace($val['xkey'],$val['value'],$query_success_tips);
            $query_fail_tips = str_replace($val['xkey'],$val['value'],$query_fail_tips);
        }
        
        $product['query_success_tips'] = $query_success_tips;
        $product['query_fail_tips'] = $query_fail_tips;
        $product['lasttime'] = $lasttime;
        
        if(!empty($product['images'])){
            $product['images'] = cdnurls(iunserializer($product['images']));
        }
        else{
            $product['images'] = [];
        }
        
        $result = ['success'=>$success,'is_first'=>$is_first,'product'=>$product];
        
        return __json(1,"查询成功",$result);
    }
    
    
    public function batchCreate($product_id,$total){
        $product = Db::name("bbfx_sverify_product")->where(['id'=>$product_id])->find();
        if(empty($product)){
            return __json(0,"产品信息错误");
        }
        
        if($total <= 0){
            return __json(0,"生成数量错误");
        }
        $max = 5000;
        if($total > $max){
            return __json(0,"每次最多生成{$max}个");
        }
        $number_digit = max(6,$product['number_digit']);
        $number_prefix = $product['number_prefix'];
        
        $product_code = Db::name("bbfx_sverify_product_code")->where(['product_id'=>$product['id']])->field("id,product_id,code")->select();
        if(!empty($product_code)){
            $product_code = array_column($product_code,"code");
        }
        else{
            $product_code = [];
        }
        
        $time = time();
        $num = 0;
        $product_code_data = [];
        while($num < $total){
            
            $code = $number_prefix.Random::numeric($number_digit);
            
            
            if(!in_array($code,$product_code)){
                
                $image_name = md5($product['id'].$code);
                $url = cdnurl("/mobile/#/pages/sverify/result?code={$code}&pid=".$product['code']);
                $result = QRcode::create($url,$image_name);
                if($result['code'] == 1){
                    $image = $result['data']['url'];
                    
                    $wxapp_qrcode_url = cdnurl("/sverify/?code={$code}&pid=".$product['code']);
                    $image_name = "wxapp_".md5($product['id'].$code);
                    $result = QRcode::create($wxapp_qrcode_url,$image_name);
                    $wxapp_qrcode = "";
                    if($result['code'] == 1){
                        $wxapp_qrcode = $result['data']['url'];
                    }
                    
                    $product_code_data[] = array(
                        "uniacid"=>UNIACID,
                        "product_id"=>$product['id'],
                        "code"=>$code,
                        "query_num"=>0,
                        "qrcode"=>$image,
                        "wxapp_qrcode"=>$wxapp_qrcode,
                        "createtime"=>$time
                    );
                    $num++;
                }
            }
            
        }
        
        Db::name("bbfx_sverify_product_code")->insertAll($product_code_data);
        
        return __json(1,"操作成功");
    }
}