<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/
namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Message;

class Notice extends Model
{
    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        
        return $base;
    }
    
    public function send($params){
        // 0=系统通知,1=推送消息,2=团队消息,3=余额变动通知,4=佣金变动通知
        $type = intval($params['type']);
        // 0=系统通知,1=推送消息,2=团队消息,3=余额变动通知,4=佣金变动通知
        $itype = intval($params['itype']);
        
        if(is_array($params['user_id'])){
            $user_ids = $params['user_id'];
        }
        else{
            $user_ids[] = intval($params['user_id']);
        }
        
        $data = [
            "uniacid"=>UNIACID,
            "type"=>$type,
            "itype"=>$itype,
            "user_id"=>$user_id,
            "title"=>$params['title'],
            "content"=>$params['content'],
            "link"=>$params['link'],
            "createtime"=>time()
        ];
        
        if(!empty($params['extend'])){
            $data['extend'] = iserializer($params['extend']);
        }
        
        if(empty($data['content'])) $data['content'] = "";
        if(empty($data['link'])) $data['link'] = "";
        if($type == 1 && empty($user_ids)){
            return __json(0,"接收消息用户不存在");
        }
        foreach ($user_ids as $key => $user_id){
            $data['user_id'] = $user_id;
            if($type == 1 || $type == 2){
                $user = User::getInfo($data['user_id']);
                if(empty($user)){
                    return __json(0,"接收消息用户不存在");
                }
            }
            else{
                if(empty($data['content'])){
                    return __json(0,"消息内容不能为空");
                }
            }
            
            try {
                $id = Db::name("bbfx_notice")->insertGetId($data);
                $data['id'] = $id;
                Message::sendMessageCenterNotice($data);
            } 
            catch (\Exception $e) {
                return __json(0,$e->getMessage());
            }
        }
        
        return __json(1,"操作成功");
    }
}