<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;

class Merchant extends Model
{
    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        
        $base['merchant']['orderset'] = $base['orderset'];
        
        return $base['merchant'];
    }
    
    public static function task(){
        
        $config = self::getSet();
        if($config['daozhang_type'] != 1){
            // return false;
        }
        
        $after_sales_day = max(0,$config['orderset']['after_sales_day']);
        $after_sales_time = time() - ($after_sales_day * 86400);
        
        try {
            
            if($config['daozhang_type'] == 1){
                $list = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'mid'=>['>',0],'is_pay'=>1,'status'=>3,'jiesuan_status'=>['in',[0,1]],'completetime'=>['<=',$after_sales_time]])->select();
            }
            else{
                $list = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'mid'=>['>',0],'is_pay'=>1,'status'=>3,'jiesuan_status'=>['in',[0,1]]])->select();
            }
            // print_r($list);die;
            if(!empty($list)){
                foreach ($list as $key => $val){
                    self::settlementOrder($val);
                }
            }
        } 
        catch (\Exception $e) {
            
        }
        
        return true;
    }
    
    public static function settlementOrder($id){
        
        if(is_array($id)){
            $order = $id;
        }
        else{
            $order = Db::name("bbfx_order")->where(['id'=>intval($id),'is_pay'=>1,'mid'=>['>',0]])->find();
        }
        
        if(empty($order)){
            return __json(0,"订单不存在");
        }
        if($order['status'] != 3){
            return __json(0,"订单未完成");
        }
        
        $config = self::getSet();
        
        if($order['jiesuan_status'] == 2){
            return __json(0,"订单金额已到账");
        }
        
        if($order['jiesuan_status'] == 1 || ($order['jiesuan_status'] == 0 && $config['daozhang_type'] == 0)){
            
            
            try {
                Db::startTrans();
                
                $res = Db::name("bbfx_order")->where(['id'=>$order['id'],'jiesuan_status'=>['in',[0,1]]])->update(['jiesuan_status'=>2]);
                if(empty($res)){
                    throw new \Exception("订单结算失败");
                }
                
                $money = round($order['price'],2);
                
                if($money > 0){
                    $res = self::setUserMoney($order['mid'],$money,1,1,"订单结算",$order);
                    if($res['code'] != 1){
                        throw new \Exception($res['message']);
                    }
                }
                
                $result = __json(1,"操作成功1");
                
                Db::commit();
            } 
            catch (\Exception $e) {
                Db::rollback();
                $result = __json(0,$e->getMessage());
            }
            return $result;
        }
        else{
            
            $res = Db::name("bbfx_order")->where(['id'=>$order['id'],'jiesuan_status'=>0])->update(['jiesuan_status'=>1]);
            if(empty($res)){
                return __json(0,"订单结算失败");
            }
            
            return __json(1,"操作成功2");
        }
    }
    
    public static function getInfo($id){
        $info = Db::name("bbfx_merchant")->where(["id"=>$id])->find();
        if(empty($info)){
            return false;
        }
        
        $info['region'] = [$info['province'],$info['city'],$info['area']];
        $info['logo'] = cdnurl($info['logo']);
        
        $info['images'] = cdnurls(iunserializer($info['images']));
        $info['detail_images'] = cdnurls(iunserializer($info['detail_images']));
        
        
        return $info;
    }
    
    public static function syncMainStore($id){
        $info = Db::name("bbfx_merchant")->where(["id"=>$id])->find();
        if(empty($info)){
            return false;
        }
        
        $data = [
            'uniacid'=>$info['uniacid'],
            'type'=>1,
            'mid'=>$info['id'],
            'main'=>1,
            'user_id'=>$info['user_id'],
            'name'=>$info['name'],
            'logo'=>$info['logo'],
            'realname'=>$info['realname'],
            'mobile'=>$info['mobile'],
            'province'=>$info['province'],
            'city'=>$info['city'],
            'area'=>$info['area'],
            'address'=>$info['address'],
            'yy_time'=>$info['yy_time'],
            'introduction'=>$info['introduction'],
            'content'=>$info['content'],
            'images'=>$info['images'],
            'status'=>1
        ];
        
        $store = Db::name("bbfx_store")->where(["type"=>1,'main'=>1,'mid'=>$id])->find();
        if(empty($store)){
            $data['createtime'] = time();
            Db::name("bbfx_store")->insert($data);
        }
        else{
            Db::name("bbfx_store")->where(['id'=>$store['id']])->update($data);
        }
    }
    
    public static function setUserMoney($mid,$money,$type=0,$item_type=0,$remarks = "",$info = [],$createtime=0){
        // $item_type 操作类型:1=订单结算,2=余额提现,3=提现驳回
        // $type 金额类型:1=余额
        $user = Db::name("bbfx_merchant")->where(['id'=>$mid])->find();
        if(empty($user)){
            return __json(0,"商户信息错误");
        }
        
        $money = floatval($money);
        
        if(intval($createtime) <= 0){
            $createtime = time();
        }
        
        
        try {
            Db::startTrans();
            if($type == 1){
                if($money > 0){
                    $res = Db::name("bbfx_merchant")->where(['id'=>$mid])->setInc("balance",$money);
                    if(!in_array($item_type,[2,3])){
                        Db::name("bbfx_merchant")->where(['id'=>$mid])->setInc("balance_total",$money);
                    }
                }
                else{
                    $pmoney = abs($money);
                    if($user['balance'] < $pmoney){
                        throw new \Exception("余额不足");
                    }
                    $res = Db::name("bbfx_merchant")->where(['id'=>$mid])->setDec("balance",$pmoney);
                }
                if(empty($res)){
                    throw new \Exception("余额不足");
                }
                $nuser = Db::name("bbfx_merchant")->where(['id'=>$mid])->find();
                $befores = $user['balance'];
                $afters = $nuser['balance'];
            }
            else{
                throw new \Exception("类型错误");
            }
            
            
            
            $data = array(
                "uniacid"=>UNIACID,
                "mid"=>$mid,
                "money"=>$money,
                "befores"=>$befores,
                "afters"=>$afters,
                "remarks"=>$remarks,
                "info"=>iserializer($info),
                "type"=>$type,
                "item_type"=>$item_type,
                "createtime"=>$createtime
            );
            
            if(!empty($info['id'])){
                $data['item_id'] = $info['id'];
            }
            
            $id = Db::name("bbfx_merchant_money_log")->insertGetId($data);
            $result = __json(1,"操作成功",$id);
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
            $result = __json(0,$e->getMessage());
        }
        
        return $result;
    }
}