<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use think\Cache;

class Goods extends Model
{
    protected $name = 'bbfx_goods';
    
    public static function copy($id){
        $goods = Db::name("bbfx_goods")->where(['id'=>$id])->find();
        if(empty($goods)){
            return __json(0,"商品不存在");
        }
        
        unset($goods['id']);
        Db::name("bbfx_goods")->where(['id'=>$id])->insert($goods);
        
        return __json(1,"操作成功");
    } 
    
    public static function resetStock($uniacid,$goods_id=0){
        $where = ['uniacid'=>$uniacid];
        if(!empty($goods_id)){
            $where['id'] = $goods_id;
        }
        $goods_list = Db::name("bbfx_goods")->where($where)->where(function($query){
            $query->whereOr(function($query){
        		$query->where(['type'=>1]);
        	});
        	$query->whereOr(function($query){
        		$query->where(['type'=>2,'is_spec'=>1]);
        	});
        })->field("id,type,is_spec")->select();
        
        if(empty($goods_list)){
            return false;
        }
        
        foreach ($goods_list as $key => $goods){
            if($goods['type'] == 1 || ($goods['type'] == 2 && $goods['is_spec'] == 1)){
                if($goods['type'] == 1){
                    $goods_stock = Db::name("bbfx_serial_number")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id'],'status'=>0])->count();
                }
                else{
                    $goods_stock = Db::name("bbfx_goods_spec_sku")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->sum("stock");
                }
                $goods_stock = intval($goods_stock);
                Db::name("bbfx_goods")->where(['id'=>$goods['id']])->update(['stock'=>$goods_stock]);
            }
        }
    }
    
    public static function getCategoryList(){
        $category = Db::name("bbfx_category")->where(["uniacid"=>UNIACID,'status'=>1,'pid'=>0,'mid'=>0])->order('sort desc')->select();
        foreach ($category as $key => &$val) {
    	    $val['thumb'] = cdnurl($val['thumb']);
    	    $child = Db::name("bbfx_category")->where(["uniacid"=>UNIACID,'pid'=>$val['id'],'mid'=>0])->order('sort desc')->select();
    	    if(empty($child)) $child = [];
    	    
    	    foreach ($child as $k => &$v){
    	        $v['thumb'] = cdnurl($v['thumb']);
    	        $three_child = Db::name("bbfx_category")->where(["uniacid"=>UNIACID,'pid'=>$v['id'],'mid'=>0])->order('sort desc')->select();
    	        if(empty($three_child)) $three_child = [];
    	        foreach ($three_child as $k1 => &$v1){
    	            $v1['thumb'] = cdnurl($v1['thumb']);
    	        }
    	        $v['child'] = $three_child;
    	    }
    	    unset($v);
    	    
    	    $val['child'] = $child;
    	}
    	unset($val);
    	
    	return $category;
    }
    
    public static function setStock($goods_id,$sku_id,$stock,$user_id,$type,$itype,$remarks,$info=[],$startTrans=true){
        // $type 用户类型，0=管理员，1=用户
        // $itype 操作类型，0=管理员操作,1=用户下单,2=用户退款
        $stock = intval($stock);
        if($stock == 0){
            return __json(0,"变动库存不能为0");
        }
        
        $goods = Db::name("bbfx_goods")->where(['id'=>$goods_id])->field("id,is_spec,title,thumb,price,stock,type,o_price,minbuy,maxbuy,total_maxbuy,unit,sales_volume,virtual_sale")->find();
        
        if(empty($goods)){
            return __json(0,"商品信息错误");
        }
        
        if($goods['is_spec'] == 1){
            $sku = Db::name("bbfx_goods_spec_sku")->where(['goods_id'=>$goods['id'],'id'=>$sku_id])->find();
            if(empty($sku)){
                return __json(0,"规格信息错误");
            }
        }
        
        try {
            
            if($startTrans){
                Db::startTrans();
            }
            
            
            if($stock > 0){
                $res = Db::name("bbfx_goods")->where(['id'=>$goods['id']])->setInc("stock",$stock);
                if(empty($res)){
                    throw new \Exception("操作失败");
                }
            }
            else{
                $pstock = abs($stock);
                if($goods['stock'] < $pstock){
                    throw new \Exception("库存不足");
                }
                $res = Db::name("bbfx_goods")->where(['id'=>$goods['id']])->setDec("stock",$pstock);
                if(empty($res)){
                    throw new \Exception("库存不足");
                }
            }
            
            $title = $goods['title'];
            
            if($goods['is_spec'] == 1){
                
                if($stock > 0){
                    $res = Db::name("bbfx_goods_spec_sku")->where(['id'=>$sku['id']])->setInc("stock",$stock);
                    if(empty($res)){
                        throw new \Exception("操作失败");
                    }
                }
                else{
                    $pstock = abs($stock);
                    if($sku['stock'] < $pstock){
                        throw new \Exception("库存不足");
                    }
                    $res = Db::name("bbfx_goods_spec_sku")->where(['id'=>$sku['id']])->setDec("stock",$pstock);
                    if(empty($res)){
                        throw new \Exception("库存不足");
                    }
                }
                
                $title .= "-".$sku['sku_name'];
                $goods['sku'] = $sku;
                
                $new = Db::name("bbfx_goods_spec_sku")->where(['goods_id'=>$goods['id'],'id'=>$sku['id']])->find();
                $before = $sku['stock'];
                $after = $new['stock'];
            }
            else{
                $new = Db::name("bbfx_goods")->where(['id'=>$goods['id']])->find();
                $before = $goods['stock'];
                $after = $new['stock'];
            }
            
            $data = array(
                "uniacid"=>UNIACID,
                "user_id"=>$user_id,
                "goods_id"=>$goods_id,
                "sku_id"=>$sku_id,
                "stock"=>$stock,
                "before"=>$before,
                "after"=>$after,
                "remarks"=>$remarks,
                "title"=>$title,
                "info"=>iserializer($info),
                "goods"=>iserializer($goods),
                "type"=>$type,
                "itype"=>$itype,
                "createtime"=>time()
            );
            
            if(!empty($info['id'])){
                $data['item_id'] = $info['id'];
            }
            
            $id = Db::name("bbfx_goods_stock_log")->insertGetId($data);
            $data['id'] = $id;
            
            $result = __json(1,"操作成功",$data);
            
            if($startTrans){
                Db::commit();
            }
            
        } 
        catch (\Exception $e) {
            if($startTrans){
                Db::rollback();
            }
            $result = __json(0,$e->getMessage());
        }
         
        return $result;
    }
}