<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use app\common\library\Auth;

class Diypage extends Model
{
    protected $name = 'bbfx_diypage';
    
    public function getPage($id){
        
        if(is_array($id)){
            $item = $id;
        }
        else{
            if($id == 'index'){
                $where = ["uniacid"=>UNIACID,"type"=>1,"default_status"=>1];
            }
            else if($id == 'member'){
                $where = ["uniacid"=>UNIACID,"type"=>2,"default_status"=>1];
            }
            else{
                $where = ["uniacid"=>UNIACID,"id"=>$id];
            }
            $item = Db::name("bbfx_diypage")->where($where)->find();
        }
        
        if(empty($item)){
            return false;
        }
        
        $diypage = iunserializer($item['data']);
        $diypage = $this->tomediaPage($diypage);
        $auth = Auth::instance();
        $user_id = (int)$auth->id;
        // $user_id = 0;
        // if($uid > 0){
        //     $user_id = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'uid'=>$uid])->value("id");
        // }
        $level_id = -1;
        if($user_id > 0){
            if($auth->is_distributor == 1 && $auth->distributor_status == 1){
                $level_id = $auth->level;
            }
        }
        
        foreach ($diypage['list'] as $key => &$val) {
            if($val['name'] == 'coupon'){
                $coupon_list = $val['data']['list'];
                foreach ($coupon_list as $k => &$v) {
                    $coupon = Db::name("bbfx_coupon")->where("id",$v['id'])->find();
                    if(!empty($coupon)){
                        $coupon['money'] = floatval($coupon['money']);
                        $coupon['mj_money'] = floatval($coupon['mj_money']);
                        $user_coupon = Db::name("bbfx_user_coupon")->where(['coupon_id'=>$coupon['id'],'receive_type'=>1])->find();
                        if(!empty($user_coupon)){
                            $coupon['is_receive'] = 1;
                        }
                        
                        $v = $coupon;
                    }
                }
                unset($v);
                
                $val['data']['list'] = $coupon_list;
            }
            else if($val['name'] == 'goodsGroup'){
                $goods = [];
                if($val['data']['type'] == 2){
                    $goods = [];
                    if(!empty($val['data']['cate'])){
                        $cate_ids = array_column($val['data']['cate'], 'id');
                        
                        $category_list = [];
                        foreach ($cate_ids as $k => $v){
                            $child = Db::name("bbfx_category")->where(['pid'=>$v])->find();
                            if(!empty($child)){
                                $cate_ids[] = $child['id'];
                                $three_child = Db::name("bbfx_category")->where(['pid'=>$child['id']])->find();
                                if(!empty($three_child)){
                                    $cate_ids[] = $three_child['id'];
                                }
                            }
                        }
                        
                        $goods_category = Db::name("bbfx_goods_category")->where("category_id",'in',$cate_ids)->select();
                        $goods_ids = array_column($goods_category,"goods_id");
                        
                        $goods = Db::name("bbfx_goods")->where(["uniacid"=>UNIACID,"status"=>1,"id"=>['in',$goods_ids]])->field(["id","title","subtitle","thumb","price",'stock',"single_column_thumb"])->order(['sort desc','id desc'])->select();
                    }
                    $val['data']['goods'] = $goods;
                }
                else if($val['data']['type'] == 3){
                    
                    $g_params = ["uniacid"=>UNIACID,"status"=>1];
                    if($val['data']['marketingAttr'] == 1){
                        $g_params['is_new'] = 1;
                    }
                    else if($val['data']['marketingAttr'] == 2){
                        $g_params['is_hot'] = 1;
                    }
                    else if($val['data']['marketingAttr'] == 3){
                        $g_params['is_recommend'] = 1;
                    }
                    
                    $goods = Db::name("bbfx_goods")->where($g_params)->field(["id","title","subtitle","thumb","price",'stock',"single_column_thumb"])->order(['sort desc','id desc'])->select();
                }
                else{
                    $goods = $val['data']['goods'];
                    if(!empty($goods)){
                        $goods_ids = array_column($goods, 'id');
                        
                        foreach ($goods as $k => $v){
                            $goods[$k]['sort'] = $k;
                        }
                        
                        $goods_list = array_skey($goods,"id");
                        
                        $goods = Db::name("bbfx_goods")->where(["uniacid"=>UNIACID,"status"=>1,"id"=>['in',$goods_ids]])->field(["id","title","subtitle","thumb",'stock',"price","single_column_thumb"])->select();
                        
                        foreach ($goods as $k => $v){
                            $goods[$k]['sort'] = $goods_list[$v['id']]['sort'];
                        }
                        
                        $sorts = array_column($goods,'sort');
                        array_multisort($sorts,SORT_ASC,$goods);
                        
                    }
                    
                }
                
                foreach ($goods as $k => $v){
                    $goods[$k]['thumb'] = tomediaPage($v['thumb']);
                    if($val['style']['type'] == 4 && !empty($v['single_column_thumb'])){
                        $goods[$k]['thumb'] = tomediaPage($v['single_column_thumb']);
                    }
                }
                $val['data']['goods'] = $goods;
            }
            else if($val['name'] == 'seckill'){
                
                $seckill_activity = Db::name("bbfx_seckill_activity")->where(['id'=>$val['data']['seckill_activity_id'],'status'=>1,'starttime'=>['<',time()]])->where(['endtime'=>['>',time()]])->find();
                
                if(!empty($seckill_activity)){
                    $seckill_activity['downtime'] = intval($seckill_activity['endtime'] - time());
                    // print_r($seckill_activity['downtime']);die;
                    $goods_ids = explode(",",$seckill_activity['seckill_goods_ids']);
                    
                    $where = ["a.uniacid"=>UNIACID,"a.status"=>1,"a.id"=>['in',$goods_ids],'b.status'=>1];
                    $goods = Db::name("bbfx_seckill_goods")->alias("a")->join("bbfx_goods b","a.goods_id = b.id")->where($where)->field("a.*,b.title,b.subtitle,b.thumb,b.stock,b.price as o_price")->order(['b.sort desc','b.id desc'])->select();
                    
                    foreach ($goods as $k => &$v){
                        $v['thumb'] = tomediaPage($v['thumb']);
                    }
                    unset($v);
                    
                    $val['data']['seckill_activity'] = $seckill_activity;
                }
                else{
                    $goods = [];
                }
                
                $val['data']['goods'] = $goods;
            }
            else if($val['name'] == 'seckill2'){
                
                $seckill_activity = Db::name("bbfx_seckill_activity")->where(['id'=>$val['data']['seckill_activity_id'],'status'=>1,'starttime'=>['<',time()]])->where(['endtime'=>['>',time()]])->find();
                
                if(!empty($seckill_activity)){
                    $seckill_activity['downtime'] = intval($seckill_activity['endtime'] - time());
                    // print_r($seckill_activity['downtime']);die;
                    $goods_ids = explode(",",$seckill_activity['seckill_goods_ids']);
                    
                    $where = ["a.uniacid"=>UNIACID,"a.status"=>1,"a.id"=>['in',$goods_ids],'b.status'=>1];
                    $goods = Db::name("bbfx_seckill_goods")->alias("a")->join("bbfx_goods b","a.goods_id = b.id")->where($where)->field("a.*,b.title,b.subtitle,b.thumb,b.stock,b.price as o_price")->order(['b.sort desc','b.id desc'])->select();
                    
                    foreach ($goods as $k => &$v){
                        $v['thumb'] = cdnurl($v['thumb']);
                    }
                    unset($v);
                    
                    $val['data']['seckill_activity'] = $seckill_activity;
                }
                else{
                    $goods = [];
                }
                $val['data']['goods'] = $goods;
                $val['data']['thumb'] = cdnurl($val['data']['thumb']);
            }
            else if($val['name'] == 'userHead'){
                
                $user = \app\common\model\bbfxshop\User::getUser($user_id);
                if(empty($user)){
                    $user = [];
                }
                $val['data'] = $user;
            }
            else if($val['name'] == 'btn' || $val['name'] == 'btn2'){
                
                if($val['name'] == 'btn2'){
                    $btns = $val['data']['list'];
                }
                else{
                    $btns = $val['data'];
                }
                
                $btn_list = [];
                
                foreach ($btns as $k => $v){
                    
                    if(is_null($v['levels'])){
                        $v['levels'] = [];
                    }
                    
                    if(!empty($v['levels']) && !in_array($level_id,$v['levels'])){
                        continue;
                    }
                    
                    if($user_id > 0){
                        if($v['link']['url'] == '/pages/order/order?current=1'){
                            $count = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user_id,'status'=>0])->count();
                            $v['num'] = intval($count);
                        }
                        else if($v['link']['url'] == '/pages/order/order?current=2'){
                            $count = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user_id,'status'=>1,'refund_status'=>['in',[-1,2]]])->count();
                            $v['num'] = intval($count);
                        }
                        else if($v['link']['url'] == '/pages/order/order?current=3'){
                            $count = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user_id,'status'=>2,'refund_status'=>['in',[-1,2]]])->count();
                            $v['num'] = intval($count);
                        }
                        else if($v['link']['url'] == '/pages/order/order?current=4'){
                            $count = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user_id,'status'=>3,'refund_status'=>['in',[-1,2]]])->count();
                            $v['num'] = intval($count);
                        }
                        else if($v['link']['url'] == '/pages/order/order?current=5'){
                            $count = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user_id,'status'=>['in',[1,2,3]],'refund_status'=>['in',[0,1]]])->count();
                            $v['num'] = intval($count);
                        }
                    }
                    
                    $btn_list[] = $v;
                }
                
                if($val['name'] == 'btn2'){
                    $val['data']['list'] = $btn_list;
                }
                else{
                    $val['data'] = $btn_list;
                }
            }
            else if($val['name'] == 'searchMenu'){
                $list = $val['data']['list'];
                
                foreach ($list as $k => &$v){
                    
                    $access_permissions_levels = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID,'type'=>1,'id'=>intval($v['diypage_id'])])->value("access_permissions_levels");
                    
                    $is_access_permissions = true;
                    if(!empty($access_permissions_levels)){
                        $levels = iunserializer($access_permissions_levels);
                        
                        if(!empty($levels)){
                            foreach ($levels as $k1 => &$v1){
                                $v1 = intval($v1);
                            }
                            unset($v1);
                        }
                        
                        if(!empty($levels) && !in_array($level_id,$levels)){
                            $is_access_permissions = false;
                        }
                    }
                    
                    if($is_access_permissions){
                        $menu_page = $this->getPage($v['diypage_id']);
                        $v['is_access_permissions'] = 1;
                        $v['diypage'] = $menu_page;
                    }
                    else{
                        $v['is_access_permissions'] = 0;
                    }
                    
                }
                unset($v);
                
                $val['data']['list'] = $list;
                
            }
            else if($val['name'] == 'productFilter'){
                $category_list = Db::name("bbfx_category")->where(['uniacid'=>UNIACID,'status'=>1,'pid'=>0])->field("id,title,thumb")->select();
                foreach ($category_list as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                }
                unset($v);
                $val['data']['category_list'] = $category_list;
                
                $where = ["uniacid"=>UNIACID,'status'=>1,'mid'=>0];
                $goods = Db::name("bbfx_goods")->where($where)->field("id,title,subtitle,thumb,price,stock,type,o_price,minbuy,maxbuy,total_maxbuy,unit,sales_volume,virtual_sale,is_nodiscount,is_leveldiscount_rule,level_discount")->order('is_recommend asc,sort desc')->limit(0,12)->select();
                foreach ($goods as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                }
                unset($v);
                $val['data']['goods'] = $goods;
            
            }
            else if($val['name'] == 'newProduct'){
                $where = ["uniacid"=>UNIACID,'status'=>1,'mid'=>0,'is_new'=>1];
                $goods = Db::name("bbfx_goods")->where($where)->field("id,title,subtitle,thumb,price,stock,type,o_price,minbuy,maxbuy,total_maxbuy,unit,sales_volume,virtual_sale,is_nodiscount,is_leveldiscount_rule,level_discount")->order('is_recommend asc,sort desc')->limit(0,12)->select();
                foreach ($goods as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                }
                unset($v);
                $val['data']['goods'] = $goods;
            }
        }
        unset($val);
        
        
        
        if($id == "index"){
            $diypage['tabBar'] = $this->getTabBar($diypage['tabBar']);
        }
        else{
            if($diypage['tabBar']['show'] == 1){
                if($diypage['tabBar']['syncHome'] == 1){
                    $diypage['tabBar'] = $this->getTabBar();
                }
                else{
                    $diypage['tabBar'] = $this->getTabBar($diypage['tabBar']);
                }
            }
            else{
                $diypage['tabBar'] = [];
            }
        }
        
        return $diypage;
    }
    
    public function getTabBar($tabbar=[]){
        if(empty($tabbar)){
            $item = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID,"type"=>1,"default_status"=>1])->find();
            if(empty($item)){
                return [];
            }
            $diypage = iunserializer($item['data']);
            $tabbar = $diypage['tabBar'];
            
        }
        foreach ($tabbar['list'] as $key => &$val){
            $val['iconPath'] = cdnurl($val['iconPath']);
            $val['selectedIconPath'] = cdnurl($val['selectedIconPath']);
        }
        unset($val);
        
        return $tabbar;
    }
    
    public function replacePage($data){
        global $_W;
        foreach ($data['tabBar']['list'] as $key => &$val){
            $val['iconPath'] = replaceSiteroot($val['iconPath']);
            $val['selectedIconPath'] = replaceSiteroot($val['selectedIconPath']);
        }
        unset($val);
        
        if(empty($data['navbar'])){
            $data['navbar']['title'] = $data['title'];
            $data['navbar']['show'] = 1;
            $data['navbar']['back'] = 1;
            $data['navbar']['bg'] = "";
            $data['navbar']['color'] = $_W['base']['font_color'];
            $data['navbar']['bgColor'] = $_W['base']['theme_color'];
            $data['navbar']['backIcon'] = "/assets/images/left.png";
            $data['navbar']['iconWidth'] = 10;
            $data['navbar']['fontSize'] = 16;
        }
        $data['navbar']['bg'] = replaceSiteroot($data['navbar']['bg']);
        $data['navbar']['backIcon'] = replaceSiteroot($data['navbar']['backIcon']);
        
        foreach ($data['list'] as $key => &$val){
            if(in_array($val['name'],['slides','btn','pictures','listNav','picturesWin'])){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = replaceSiteroot($v['thumb']);
                    if($val['name'] == 'listNav'){
                        $v['moreIcon'] = replaceSiteroot($v['moreIcon']);
                    }
                }
                unset($v);
            }
            else if($val['name'] == 'btn2'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['thumb'] = replaceSiteroot($v['thumb']);
                }
                unset($v);
                $val['data']['titles']['rightThumb'] = replaceSiteroot($val['data']['titles']['rightThumb']);
            }
            else if($val['name'] == 'titles'){
                $val['data']['leftThumb'] = replaceSiteroot($val['data']['leftThumb']);
                $val['data']['rightThumb'] = replaceSiteroot($val['data']['rightThumb']);
            }
            else if($val['name'] == 'goodsGroup'){
                foreach ($val['data']['goods'] as $k => &$v){
                    $v['thumb'] = replaceSiteroot($v['thumb']);
                }
                foreach ($val['data']['cate'] as $k => &$v){
                    $v['thumb'] = replaceSiteroot($v['thumb']);
                }
                unset($v);
            }
            else if($val['name'] == 'userHead'){
                if(empty($val['style']['bgImg2'])){
                    $val['style']['bgImg2'] = "/assets/images/user-head.png";
                }
                if(empty($val['style']['bgImg3'])){
                    $val['style']['bgImg3'] = "/assets/images/user-head3.png";
                }
                if(empty($val['style']['balance_icon'])){
                    $val['style']['balance_icon'] = "/assets/images/balance-ico.png";
                }
                if(empty($val['style']['score_icon'])){
                    $val['style']['score_icon'] = "/assets/images/score-ico.png";
                }
                $val['style']['bgImg1'] = replaceSiteroot($val['style']['bgImg1']);
                $val['style']['bgImg2'] = replaceSiteroot($val['style']['bgImg2']);
                $val['style']['bgImg3'] = replaceSiteroot($val['style']['bgImg3']);
                $val['style']['bgImg4'] = replaceSiteroot($val['style']['bgImg4']);
                $val['style']['bgImg5'] = replaceSiteroot($val['style']['bgImg5']);
                $val['style']['bgImg6'] = replaceSiteroot($val['style']['bgImg6']);
                $val['style']['balance_icon'] = replaceSiteroot($val['style']['balance_icon']);
                $val['style']['score_icon'] = replaceSiteroot($val['style']['score_icon']);
            }
            else if($val['name'] == 'hotZone'){
                $val['data']['thumb'] = replaceSiteroot($val['data']['thumb']);
            }
            else if($val['name'] == 'searchMenu'){
                $val['data']['headBg'] = replaceSiteroot($val['data']['headBg']);
                foreach ($val['data']['list'] as $k => &$v){
                    $v['headBg'] = replaceSiteroot($v['headBg']);
                }
                unset($v);
            }
            else if($val['name'] == 'searchSwiper'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['thumb'] = replaceSiteroot($v['thumb']);
                    $v['poster'] = replaceSiteroot($v['poster']);
                }
                unset($v);
                $val['data']['headBg'] = replaceSiteroot($val['data']['headBg']);
            }
            else if($val['name'] == 'seckill2'){
                $val['data']['thumb'] = replaceSiteroot($val['data']['thumb']);
            }
        }
        unset($val);
        
        return $data;
    }
    
    public function tomediaPage($data){
        global $_W;
        foreach ($data['tabBar']['list'] as $key => &$val){
            $val['iconPath'] = tomediaPage($val['iconPath']);
            $val['selectedIconPath'] = tomediaPage($val['selectedIconPath']);
        }
        unset($val);
        
        if(empty($data['navbar'])){
            $data['navbar']['title'] = $data['title'];
            $data['navbar']['back'] = 1;
            $data['navbar']['show'] = 1;
            $data['navbar']['bg'] = "";
            $data['navbar']['color'] = $_W['base']['font_color'];
            $data['navbar']['bgColor'] = $_W['base']['theme_color'];
            $data['navbar']['backIcon'] = "/assets/images/left.png";
            $data['navbar']['iconWidth'] = 10;
            $data['navbar']['fontSize'] = 16;
        }
        $data['navbar']['bg'] = cdnurl($data['navbar']['bg']);
        $data['navbar']['backIcon'] = cdnurl($data['navbar']['backIcon']);
    
        foreach ($data['list'] as $key => &$val){
            if(in_array($val['name'],['slides','btn','pictures','listNav','picturesWin'])){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                    if($val['name'] == 'listNav'){
                        $v['moreIcon'] = cdnurl($v['moreIcon']);
                    }
                    else if($v['name'] == 'btn'){
                        if(is_null($v['levels'])){
                            $v['levels'] = [];
                        }
                    }
                }
                unset($v);
                if(empty($val['style']['imgWidth'])){
                    $val['style']['imgWidth'] = 60;
                }
                if(empty($val['style']['imgHeight'])){
                    $val['style']['imgHeight'] = 60;
                }
            }
            else if($val['name'] == 'btn2'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                }
                unset($v); 
                $val['data']['titles']['rightThumb'] = cdnurl($val['data']['titles']['rightThumb']);
                if(empty($val['style']['imgWidth'])){
                    $val['style']['imgWidth'] = 60;
                }
                if(empty($val['style']['imgHeight'])){
                    $val['style']['imgHeight'] = 60;
                }
            }
            else if($val['name'] == 'titles'){
                $val['data']['leftThumb'] = cdnurl($val['data']['leftThumb']);
                $val['data']['rightThumb'] = cdnurl($val['data']['rightThumb']);
            }
            else if($val['name'] == 'goodsGroup'){
                foreach ($val['data']['goods'] as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                }
                foreach ($val['data']['cate'] as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                }
                unset($v);
            }
            else if($val['name'] == 'userHead'){
                if(empty($val['style']['bgImg2'])){
                    $val['style']['bgImg2'] = "/assets/images/user-head.png";
                }
                if(empty($val['style']['bgImg3'])){
                    $val['style']['bgImg3'] = "/assets/images/user-head3.png";
                }
                if(empty($val['style']['balance_icon'])){
                    $val['style']['balance_icon'] = "/assets/images/balance-ico.png";
                }
                if(empty($val['style']['score_icon'])){
                    $val['style']['score_icon'] = "/assets/images/score-ico.png";
                }
                $val['style']['bgImg1'] = cdnurl($val['style']['bgImg1']);
                $val['style']['bgImg2'] = cdnurl($val['style']['bgImg2']);
                $val['style']['bgImg3'] = cdnurl($val['style']['bgImg3']);
                $val['style']['bgImg4'] = cdnurl($val['style']['bgImg4']);
                $val['style']['bgImg5'] = cdnurl($val['style']['bgImg5']);
                $val['style']['bgImg6'] = cdnurl($val['style']['bgImg6']);
                $val['style']['balance_icon'] = cdnurl($val['style']['balance_icon']);
                $val['style']['score_icon'] = cdnurl($val['style']['score_icon']);
            }
            else if($val['name'] == 'hotZone'){
                $val['data']['thumb'] = cdnurl($val['data']['thumb']);
            }
            else if($val['name'] == 'searchMenu'){
                $val['data']['headBg'] = cdnurl($val['data']['headBg']);
                foreach ($val['data']['list'] as $k => &$v){
                    $v['headBg'] = cdnurl($v['headBg']);
                }
                unset($v);
            }
            else if($val['name'] == 'searchSwiper'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                    $v['poster'] = cdnurl($v['poster']);
                }
                unset($v);
                $val['data']['headBg'] = cdnurl($val['data']['headBg']);
            }
            else if($val['name'] == 'seckill2'){
                $val['data']['thumb'] = cdnurl($val['data']['thumb']);
            }
        }
        unset($val);
        
        return $data;
    }
    
    public static function getLink($type){
        global $_W; 
        
        $base = $_W['base'];
        
        $list = [];
        if($type == 1){
            $list = array(
                array(
                    "title"=>"平台首页",
                    "list"=>array(
                        array("title"=>"首页","link"=>"/pages/index/index"),
                        array("title"=>"我的","link"=>"/pages/user/index"),
                        array("title"=>"分类","link"=>"/pages/category/category"),
                        // array("title"=>"兑换记录","link"=>"/pages/user/excrecord"),
                        // array("title"=>"签到","link"=>"/pages/sign/sign"),
                        // array("title"=>"积分任务","link"=>"/pages/task/task"),
                        array("title"=>"购物车","link"=>"/pages/cart/cart"),
                        array("title"=>"小程序客服","link"=>"wxapp-contact"),
                        array("title"=>"客服链接","link"=>"/pages/webview/webview?url=".urlencode($base['kefu_link'])),
                        array("title"=>"普通门店","link"=>"/pages/store/list"),
                        array("title"=>"预约门店","link"=>"/pages/store/reservation_list"),
                        array("title"=>"消息中心","link"=>"/plugin/notice/index")
                    )
                ),
                array(
                    "title"=>"会员中心",
                    "list"=>array(
                        array("title"=>"全部订单","link"=>"/pages/order/order"),
                        array("title"=>"待支付","link"=>"/pages/order/order?current=1"),
                        array("title"=>"待发货","link"=>"/pages/order/order?current=2"),
                        array("title"=>"待收货","link"=>"/pages/order/order?current=3"),
                        array("title"=>"已完成","link"=>"/pages/order/order?current=4"),
                        array("title"=>"退款","link"=>"/pages/order/order?current=5"),
                        // array("title"=>"核销订单","link"=>"/pages/order/order?type=5"),
                        array("title"=>"余额明细","link"=>"/pages/user/moneyLog"),
                        array("title"=>"余额提现","link"=>"/pages/user/withdrawal/submit?type=1"),
                        array("title"=>"充值余额","link"=>"/plugin/recharge/index?type=1"),
                        array("title"=>"积分明细","link"=>"/pages/user/scoreLog"),
                        array("title"=>"积分提现","link"=>"/pages/user/withdrawal/submit?type=3"),
                        array("title"=>"充值积分","link"=>"/plugin/recharge/index?type=2"),
                        array("title"=>"设置","link"=>"/pages/user/set"),
                        array("title"=>"收款账户","link"=>"/pages/user/skaccount"),
                        array("title"=>"我的优惠券","link"=>"/pages/user/coupon"),
                        array("title"=>"门店入口","link"=>"/pagesS/store/index"),
                        array("title"=>"经销商入口","link"=>"/pagesS/store/index?identity=1"),
                    )
                )
            );
            
            $plugins = \app\common\model\bbfxshop\Common::getPlugins();
            
            foreach ($plugins as $key => $val){
                if($val['status'] == 1){
                    foreach ($val['list'] as $k => $v){
                        if($v['ident'] == 'fenxiao' && $v['status'] == 1){
                            
                            $levels = \app\common\model\bbfxshop\Fenxiao::getLevels();
                            $fenxiao_links = array(
                                array("title"=>"分销中心","link"=>"/pages/fenxiao/index"), 
                                array("title"=>"分销海报","link"=>"/pages/fenxiao/poster"), 
                                array("title"=>"佣金提现","link"=>"/pages/fenxiao/withdrawal/index"), 
                                array("title"=>"我的团队","link"=>"/pages/fenxiao/down"), 
                                array("title"=>"佣金订单","link"=>"/pages/fenxiao/order"), 
                            );
                            
                            foreach ($levels as $k1 => $v1){
                                $fenxiao_links[] = ["title"=>"申请".$v1['title'],"link"=>"/pages/fenxiao/apply?level=".$v1['id']];
                            }
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>$fenxiao_links
                            );
                            
                        }
                        else if($v['ident'] == 'merchant' && $v['status'] == 1){
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"商户中心","link"=>"/merchant/index/index"),
                                    array("title"=>"商户列表","link"=>"/merchant/front/list"),
                                    array("title"=>"商户申请","link"=>"/merchant/my/post"),
                                )
                            );

                            $merchant_category = [];
                            $merchant_list = Db::name("bbfx_merchant")->where(['uniacid'=>UNIACID,'is_shenhe'=>1,'status'=>1])->field("id,name")->select();
                            foreach($merchant_list as $k => $v){
                                $merchant_category[] = ['title'=>$v['name'],'link'=>'/merchant/front/category?mid='.$v['id']];
                            }
                            $list[] = array( 
                                "title"=>"商户分类页面",
                                "list"=>$merchant_category
                            );
                             
                        }
                        else if($v['ident'] == 'crazy' && $v['status'] == 1){
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"分红组","link"=>"/plugin/crazy/index"),
                                )
                            );
                             
                        }
                        else if($v['ident'] == 'super_maihuo' && $v['status'] == 1){
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"分红组","link"=>"/plugin/super_maihuo/roomList"),
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'return' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"返还记录","link"=>"/plugin/return/list"), 
                                    array("title"=>"返还积分","link"=>"/plugin/return/list?type=2"), 
                                    array("title"=>"返还余额","link"=>"/plugin/return/list?type=1")
                                )
                            );
                        }
                        else if($v['ident'] == 'agent' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"查询区域","link"=>"/pages/agent/queryArea"), 
                                )
                            );
                        }
                        else if($v['ident'] == 'scoreshop' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"积分商城","link"=>"/plugin/scoreshop/index"),
                                    array("title"=>"兑换记录","link"=>"/plugin/scoreshop/order/index"),
                                    array("title"=>"积分商品","link"=>"/plugin/scoreshop/goods/index"),
                                )
                            );
                        }
                        else if($v['ident'] == 'transfer_account' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"余额转账","link"=>"/pages/transfer_account/index?type=1"),
                                    array("title"=>"积分转账","link"=>"/pages/transfer_account/index?type=2"),
                                )
                            );
                        }
                        else if($v['ident'] == 'card' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"会员卡","link"=>"/pages/card/index"),
                                )
                            );
                        }
                        else if($v['ident'] == 'short_video' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"短视频","link"=>"/plugin/short_video/index"),
                                )
                            );
                        }
                        else if($v['ident'] == 'news' && $v['status'] == 1){
                            
                            $news_links = array(
                                array("title"=>"文章列表","link"=>"/plugin/news/article"),
                                array("title"=>"视频列表","link"=>"/plugin/news/video")
                            );
                            
                            $cates = Db::name("bbfx_news_category")->where(['uniacid'=>UNIACID,'type'=>1,'status'=>1])->select();
                            
                            if(!empty($cates)){
                                foreach ($cates as $k1 => $v1){
                                    $news_links[] = array("title"=>"文章-".$v1['title'],"link"=>"/plugin/news/article?category_id=".$v1['id']);
                                }
                                unset($val);
                            }
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>$news_links
                            );
                        }
                        else if($v['ident'] == 'contract' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"我的合同","link"=>"/pages/contract/index"),
                                )
                            );
                        }
                        else if($v['ident'] == 'cumulative_fanhuan' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"返还记录","link"=>"/plugin/cumulative_fanhuan/record"),
                                )
                            );
                        }
                        else if($v['ident'] == 'cloud_warehouse' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"云仓商品","link"=>"/plugin/cloud_warehouse/index"),
                                    array("title"=>"商品提货","link"=>"/plugin/cloud_warehouse/delivery"),
                                )
                            );
                        }
                        else if($v['ident'] == 'dynamic_redpacket' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"动态红包","link"=>"/plugin/dynamic_redpacket/index"),
                                )
                            );
                        }
                        else if($v['ident'] == 'problem' && $v['status'] == 1){
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"常见问题","link"=>"/plugin/faq/faq"),
                                )
                            );
                        }
                        else if($v['ident'] == 'deposit_release' && $v['status'] == 1){
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"预存释放","link"=>"/plugin/deposit_release/index"),
                                    array("title"=>"预存款存入","link"=>"/plugin/deposit_release/deposit"),
                                    array("title"=>"预存款提现","link"=>"/plugin/user/withdrawal/submit?type=6"),
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'signin' && $v['status'] == 1){
                             
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"签到有礼","link"=>"/plugin/signin/index"),
                                    array("title"=>"签到记录","link"=>"/plugin/signin/list"),
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'pintuan' && $v['status'] == 1){
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"拼团活动","link"=>"/plugin/pintuan/index"),
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'feedback' && $v['status'] == 1){
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"意见反馈","link"=>"/pages/feedback/index"),
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'sconnection' && $v['status'] == 1){
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"晋升审核","link"=>"/plugin/sconnection/shenhe"),
                                    array("title"=>"晋升申请","link"=>"/plugin/sconnection/apply"),
                                    array("title"=>"晋升记录","link"=>"/plugin/sconnection/upgradeLog"),
                                    array("title"=>"修改微信","link"=>"/pages/user/set?stype=1"),
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'paihangbang' && $v['status'] == 1){
                            
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"排行榜","link"=>"/plugin/rank/index"),
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'yajin' && $v['status'] == 1){
                             
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"押金","link"=>"/plugin/yajin/index"),
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'smaterial' && $v['status'] == 1){
                             
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"分享素材","link"=>"/plugin/smaterial/category"),
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'qwen' && $v['status'] == 1){
                             
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"Ai问答","link"=>"/plugin/ai/index")
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'shuziren' && $v['status'] == 1){
                             
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"Ai数字人","link"=>"/plugin/digitalHumans/index")
                                )
                            );
                            
                        }
                        else if($v['ident'] == 'contribution' && $v['status'] == 1){
                             
                            $list[] = array(
                                "title"=>$v['name'],
                                "list"=>array(
                                    array("title"=>"贡献值","link"=>"/plugin/contribution/index")
                                )
                            );
                            
                        }
                        
                    }
                }
            }
        }
        else if($type == 2){
            $cate  = Db::name("bbfx_category")->where(["uniacid"=>UNIACID,"status"=>1])->field(["id","title","thumb"])->order(["sort desc","id desc"])->select();
            foreach ($cate as $key => $val){
                $list[] = array(
                    "link"=>"/pages/goods/index?category_id=".$val['id'],
                    "title"=>$val['title'],
                    "thumb"=>cdnurl($val['thumb'])
                ); 
            }
        }
        else if($type == 3){
            $goods  = Db::name("bbfx_goods")->where(["uniacid"=>UNIACID,"status"=>1])->field(["id","title","thumb","price"])->order(["sort desc","id desc"])->select();
            foreach ($goods as $key => $val){
                $list[] = array(
                    "link"=>"/pages/goods/detail?id=".$val['id'],
                    "title"=>$val['title'],
                    "price"=>$val['price'],
                    "thumb"=>cdnurl($val['thumb'])
                ); 
            }
        }
        else if($type == 5){
            $diypage  = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID])->field(["id","title"])->order(["createtime desc"])->select();
            foreach ($diypage as $key => $val){
                $list[] = array(
                    "link"=>"/pages/diypage/index?id=".$val['id'],
                    "title"=>$val['title'],
                ); 
            }
        }
        else if($type == 7){
            $article  = Db::name("bbfx_news_article")->where(["uniacid"=>UNIACID,'status'=>1])->field(["id","title"])->order(["createtime desc"])->select();
            foreach ($article as $key => $val){
                $list[] = array(
                    "link"=>"/plugin/news/articleDetail?id=".$val['id'],
                    "title"=>$val['title'],
                ); 
            }
        }
        else if($type == 8){
            $video  = Db::name("bbfx_news_video")->where(["uniacid"=>UNIACID,'status'=>1])->field(["id","title"])->order(["createtime desc"])->select();
            foreach ($video as $key => $val){
                $list[] = array(
                    "link"=>"/plugin/news/videoDetail?id=".$val['id'],
                    "title"=>$val['title'],
                ); 
            }
        }
        
        
        return $list;
    }
    
    public static function getDiyTemplate($id){
        $diy = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID,"id"=>$id])->find();
        if(empty($diy)){
            return __json(0,"DIY页面不存在");
        }
        
        $data = iunserializer($diy['data']);
        
        $data['navbar']['bg'] = self::saveImage($data['navbar']['bg']);
        $data['navbar']['backIcon'] = self::saveImage($data['navbar']['backIcon']);
        
        foreach ($data['tabBar']['list'] as $key => &$val){
            $val['iconPath'] = self::saveImage($val['iconPath']);
            $val['selectedIconPath'] = self::saveImage($val['selectedIconPath']);
        }
        unset($val);
        
        $list = $data['list'];
        
        foreach ($list as $key => &$val){
            if($val['name'] == 'slides'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                    $v['poster'] = self::saveImage($v['poster']);
                }
                unset($v);
            }
            else if($val['name'] == 'searchSwiper'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                    $v['poster'] = self::saveImage($v['poster']);
                }
                unset($v);
                $val['data']['headBg'] = self::saveImage($val['data']['headBg']);
            }
            else if($val['name'] == 'btn'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                    $v['levels'] = [];
                }
                unset($v);
            }
            else if($val['name'] == 'btn2'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                    $v['levels'] = [];
                }
                unset($v);
                $val['data']['titles']['rightThumb'] = self::saveImage($val['data']['titles']['rightThumb']);
            }
            else if($val['name'] == 'pictures'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                }
                unset($v);
            }
            else if($val['name'] == 'hotZone'){
                $val['data']['thumb'] = self::saveImage($val['data']['thumb']);
            }
            else if($val['name'] == 'titles'){
                $val['data']['leftThumb'] = self::saveImage($val['data']['leftThumb']);
                $val['data']['rightThumb'] = self::saveImage($val['data']['rightThumb']);
            }
            else if($val['name'] == 'editor'){
                
            }
            else if($val['name'] == 'listNav'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                    $v['moreIcon'] = self::saveImage($v['moreIcon']);
                }
                unset($v);
            }
            else if($val['name'] == 'picturesWin'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                }
                unset($v);
            }
            else if($val['name'] == 'goodsGroup'){
                $goods = [];
                if($val['data']['type'] == 2){
                    $goods = [];
                    if(!empty($val['data']['cate'])){
                        $cate_ids = array_column($val['data']['cate'], 'id');
                        
                        $category_list = [];
                        foreach ($cate_ids as $k => $v){
                            $child = Db::name("bbfx_category")->where(['pid'=>$v])->find();
                            if(!empty($child)){
                                $cate_ids[] = $child['id'];
                                $three_child = Db::name("bbfx_category")->where(['pid'=>$child['id']])->find();
                                if(!empty($three_child)){
                                    $cate_ids[] = $three_child['id'];
                                }
                            }
                        }
                        
                        $goods_category = Db::name("bbfx_goods_category")->where("category_id",'in',$cate_ids)->select();
                        $goods_ids = array_column($goods_category,"goods_id");
                        
                        $goods = Db::name("bbfx_goods")->where(["uniacid"=>UNIACID,"status"=>1,"id"=>['in',$goods_ids]])->field(["id","title","subtitle","thumb","price",'stock',"single_column_thumb"])->order(['sort desc','id desc'])->limit(0,4)->select();
                    }
                    $val['data']['goods'] = $goods;
                }
                else if($val['data']['type'] == 3){
                    
                    $g_params = ["uniacid"=>UNIACID,"status"=>1];
                    if($val['data']['marketingAttr'] == 1){
                        $g_params['is_new'] = 1;
                    }
                    else if($val['data']['marketingAttr'] == 2){
                        $g_params['is_hot'] = 1;
                    }
                    else if($val['data']['marketingAttr'] == 3){
                        $g_params['is_recommend'] = 1;
                    }
                    
                    $goods = Db::name("bbfx_goods")->where($g_params)->field(["id","title","subtitle","thumb","price",'stock',"single_column_thumb"])->order(['sort desc','id desc'])->limit(0,4)->select();
                }
                else{
                    $goods = $val['data']['goods'];
                    if(!empty($goods)){
                        $goods_ids = array_column($goods, 'id');
                        
                        foreach ($goods as $k => $v){
                            $goods[$k]['sort'] = $k;
                        }
                        
                        $goods_list = array_skey($goods,"id");
                        
                        $goods = Db::name("bbfx_goods")->where(["uniacid"=>UNIACID,"status"=>1,"id"=>['in',$goods_ids]])->field(["id","title","subtitle","thumb",'stock',"price","single_column_thumb"])->select();
                        
                        foreach ($goods as $k => $v){
                            $goods[$k]['sort'] = $goods_list[$v['id']]['sort'];
                        }
                        
                        $sorts = array_column($goods,'sort');
                        array_multisort($sorts,SORT_ASC,$goods);
                        $goods = array_slice($goods, 0, 4);
                    }
                    
                }
                
                foreach ($goods as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                    if($val['style']['type'] == 4 && !empty($v['single_column_thumb'])){
                        $v['thumb'] = self::saveImage($v['single_column_thumb']);
                    }
                } 
                unset($v);
                $val['data']['goods'] = $goods;
            }
            else if($val['name'] == 'seckill'){
                
                $seckill_activity = Db::name("bbfx_seckill_activity")->where(['id'=>$val['data']['seckill_activity_id'],'status'=>1,'starttime'=>['<',time()]])->where(['endtime'=>['>',time()]])->find();
                
                if(!empty($seckill_activity)){
                    $seckill_activity['downtime'] = intval($seckill_activity['endtime'] - time());
                    $goods_ids = explode(",",$seckill_activity['seckill_goods_ids']);
                    
                    $where = ["a.uniacid"=>UNIACID,"a.status"=>1,"a.id"=>['in',$goods_ids],'b.status'=>1];
                    $goods = Db::name("bbfx_seckill_goods")->alias("a")->join("bbfx_goods b","a.goods_id = b.id")->where($where)->field("a.*,b.title,b.subtitle,b.thumb,b.stock,b.price as o_price")->order(['b.sort desc','b.id desc'])->limit(0,4)->select();
                    
                    foreach ($goods as $k => &$v){
                        $v['thumb'] = self::saveImage($v['thumb']);
                    }
                    unset($v); 
                    
                    $val['data']['seckill_activity'] = $seckill_activity;
                }
                else{
                    $goods = [];
                }
                
                $val['data']['goods'] = $goods;
            }
            else if($val['name'] == 'seckill2'){
                
                $seckill_activity = Db::name("bbfx_seckill_activity")->where(['id'=>$val['data']['seckill_activity_id'],'status'=>1,'starttime'=>['<',time()]])->where(['endtime'=>['>',time()]])->find();
                
                if(!empty($seckill_activity)){
                    $seckill_activity['downtime'] = intval($seckill_activity['endtime'] - time());
                    $goods_ids = explode(",",$seckill_activity['seckill_goods_ids']);
                    
                    $where = ["a.uniacid"=>UNIACID,"a.status"=>1,"a.id"=>['in',$goods_ids],'b.status'=>1];
                    $goods = Db::name("bbfx_seckill_goods")->alias("a")->join("bbfx_goods b","a.goods_id = b.id")->where($where)->field("a.*,b.title,b.subtitle,b.thumb,b.stock,b.price as o_price")->order(['b.sort desc','b.id desc'])->limit(0,4)->select();
                    
                    foreach ($goods as $k => &$v){
                        $v['thumb'] = self::saveImage($v['thumb']);
                    }
                    unset($v); 
                    
                    $val['data']['seckill_activity'] = $seckill_activity;
                }
                else{
                    $goods = [];
                }
                
                $val['data']['goods'] = $goods;
                $val['data']['thumb'] = self::saveImage($val['data']['thumb']);
            }
            else if($val['name'] == 'userHead'){
                $val['data']['level_icon'] = self::saveImage($val['data']['level_icon']);
                $val['style']['bgImg1'] = self::saveImage($val['style']['bgImg1']);
                $val['style']['bgImg2'] = self::saveImage($val['style']['bgImg2']);
                $val['style']['bgImg3'] = self::saveImage($val['style']['bgImg3']);
                $val['style']['bgImg4'] = self::saveImage($val['style']['bgImg4']);
                $val['style']['bgImg5'] = self::saveImage($val['style']['bgImg5']);
                $val['style']['bgImg6'] = self::saveImage($val['style']['bgImg6']);
                $val['style']['balance_icon'] = self::saveImage($val['style']['balance_icon']);
                $val['style']['score_icon'] = self::saveImage($val['style']['score_icon']);
            }
            else if($val['name'] == 'searchMenu'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['headBg'] = self::saveImage($v['headBg']);
                }
                unset($v);
                $val['data']['headBg'] = self::saveImage($val['data']['headBg']);
            }
            else if($val['name'] == 'productFilter'){
                $category_list = Db::name("bbfx_category")->where(['uniacid'=>UNIACID,'status'=>1,'pid'=>0])->field("id,title,thumb")->select();
                foreach ($category_list as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                }
                unset($v);
                $val['data']['category_list'] = $category_list;
                
                $where = ["uniacid"=>UNIACID,'status'=>1,'mid'=>0];
                $goods = Db::name("bbfx_goods")->where($where)->field("id,title,subtitle,thumb,price,stock,type,o_price,minbuy,maxbuy,total_maxbuy,unit,sales_volume,virtual_sale,is_nodiscount,is_leveldiscount_rule,level_discount")->order('is_recommend asc,sort desc')->limit(0,4)->select();
                foreach ($goods as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                }
                unset($v);
                $val['data']['goods'] = $goods;
            }
            else if($val['name'] == 'newProduct'){
                $where = ["uniacid"=>UNIACID,'status'=>1,'mid'=>0,'is_new'=>1];
                $goods = Db::name("bbfx_goods")->where($where)->field("id,title,subtitle,thumb,price,stock,type,o_price,minbuy,maxbuy,total_maxbuy,unit,sales_volume,virtual_sale,is_nodiscount,is_leveldiscount_rule,level_discount")->order('is_recommend asc,sort desc')->limit(0,3)->select();
                foreach ($goods as $k => &$v){
                    $v['thumb'] = self::saveImage($v['thumb']);
                }
                unset($v);
                $val['data']['goods'] = $goods;
            }
        }
        unset($val);
        
        $data['list'] = $list;
        // echo "<pre>";
        // print_r($data);die;
        
        return __json(1,"操作成功",$data);
    }
    
    public static function saveImage($url){
        $url = replaceSiteroot($url);
        if(empty($url) || strstr($url, '/assets/')){
            return $url;
        }
        $source = ROOT_PATH."public".$url;
        
        $arr = explode("/",$url);
        $filename = $arr[count($arr)-1];
        
        $new_url = "/assets/images/diy/".$filename;
        $tpl_path = ROOT_PATH."public/assets/images/diy";
        $dest = $tpl_path."/".$filename; 
        
        // if (file_exists($dest)) {
        //     return $new_url;
        // }
        
        if (!is_dir($tpl_path)) {
            mkdir($tpl_path, 0755, true);
        }
        
        copy($source, $dest);
        
        return $new_url;
    }
}