<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;

use think\Db;

class Delivery extends Model
{
    protected static $config = [];
    public static function getSet(){
        global $_W;
        if(empty(self::$config)){
            $config = $_W['base']['data']['aliyun_delivery'];
            self::$config = $config;
        }
        return self::$config;
    }
    
    public static function queryExpressDelivery($express_no){
        
        $url = "/gxali?n=".$express_no;
        
        $result = self::requset($url);
        
        return $result;
    }
    
    
    public static function requset($path,$method='GET'){
        $config = self::getSet();
        
        if($config['status'] != 1){
            return __json(0,'未开启物流信息查询');
        }
        
        if(empty($config['AppCode'])){
            return __json(0,'物流接口参数未配置');
        }
        
        error_reporting(E_ALL || ~E_NOTICE);
        $host = "https://wdexpress.market.alicloudapi.com";
        $appcode = $config['AppCode'];//开通服务后 买家中心-查看AppCode
        $headers = array();
        array_push($headers, "Authorization:APPCODE " . $appcode);
        
        
        $bodys = "";
        $url = $host . $path;
        
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_FAILONERROR, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HEADER, true);
        
        if (1 == strpos("$" . $host, "https://")) {
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        }
        
        
        $out_put = curl_exec($curl);
        
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        
        list($header, $body) = explode("\r\n\r\n", $out_put, 2);
        if ($httpCode == 200) {
            $res = json_decode($body,true);
            
            if(empty($res['Traces'])){
                return __json(0,$res['Reason']);
            }
            
            return __json(1,"请求成功",$res);
        } else {
            if ($httpCode == 400 && strpos($header, "Invalid Param Location") !== false) {
                return __json(0,"参数错误");
            } elseif ($httpCode == 400 && strpos($header, "Invalid AppCode") !== false) {
                return __json(0,"AppCode错误");
            } elseif ($httpCode == 400 && strpos($header, "Invalid Url") !== false) {
                return __json(0,"请求的 Method、Path 或者环境错误");
            } elseif ($httpCode == 403 && strpos($header, "Unauthorized") !== false) {
                return __json(0,"服务未被授权（或URL和Path不正确）");
            } elseif ($httpCode == 403 && strpos($header, "Quota Exhausted") !== false) {
                return __json(0,"套餐包次数用完");
            } elseif ($httpCode == 403 && strpos($header, "Api Market Subscription quota exhausted") !== false) {
                return __json(0,"套餐包次数用完，请续购套餐");
            } elseif ($httpCode == 500) {
                return __json(0,"API网关错误");
            } elseif ($httpCode == 0) {
                return __json(0,"URL错误");
            } else {
                return __json(0,"参数名错误 或 其他错误");
            }
        }
    }
}