<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;

use think\Db;

class Coupon extends Model
{
    
    // 下单赠送
    public static function give($id){
        $order = Db::name("bbfx_order")->where(['id'=>$id,'status'=>['>',0],'refund_status'=>['in',[-1,2]]])->find();
        if(empty($order)){
            return false;
        }
        
        $order_goods = Db::name("bbfx_order_goods")->where(['uniacid'=>UNIACID,'order_id'=>$order['id']])->select();
        if(empty($order_goods)){
            return false;
        }
        
        $user = Db::name("bbfx_user")->where(['id'=>$order['user_id']])->field("id,level")->find();
        if(empty($user)){
            return false;
        }
        
        $user_ids = [$user['id']];
        foreach ($order_goods as $key => $val){
            
            $goods = iunserializer($val['goods_info']);
            $total = max(1,intval($val['total']));
            $plugin = iunserializer($goods['plugin']);
            if(!empty($plugin) && !empty($plugin['coupon']) && !empty($plugin['coupon']['give_coupon_list'])){
                $give_coupon_list = $plugin['coupon']['give_coupon_list'];
                
                
                foreach ($give_coupon_list as $k => $v){
                    $user_coupon = Db::name("bbfx_user_coupon")->where(['uniacid'=>UNIACID,'coupon_id'=>intval($v['id']),'user_id'=>$user['id'],'receive_type'=>3,'item_id'=>$val['id']])->find();
                    if(empty($user_coupon)){
                        $num = $total * max(1,intval($v['number']));
                        self::receive(intval($v['id']),$user_ids,3,$num,$val['id']);
                    }
                    
                }
            }
            
        }
    }
    
    public static function receive($coupon,$user_ids,$receive_type = 0,$total = 1,$item_id = 0){
        // $receive_type 领取类型:0=后台发送,1=免费领取,2=会员卡赠送,3=下单赠送
        if(!is_array($coupon)){
            $coupon = Db::name("bbfx_coupon")->where("id",$coupon)->find();
        }
        
        if(empty($coupon)){
            return false;
        }
        
        $total = max(1,intval($total));
        
        $endtime = 0;
        if($coupon['validitytime'] > 0){
            $endtime = time() + $coupon['validitytime'] * 86400;
        }
        
        foreach ($user_ids as $key => $val){
            
            $data = array(
                "uniacid"=>UNIACID,
                "user_id"=>$val,
                "coupon_id"=>$coupon['id'],
                "type"=>$coupon['type'],
                "name"=>$coupon['name'],
                "money"=>$coupon['money'],
                "residue_money"=>$coupon['money'],
                "max_money"=>$coupon['max_money'],
                "mj_money"=>$coupon['mj_money'],
                "goods_ids"=>$coupon['goods_ids'],
                "condition_type"=>$coupon['condition_type'],
                "endtime"=>$endtime,
                "receive_type"=>$receive_type,
                "item_id"=>$item_id,
                "info"=>iserializer($coupon),
                "createtime"=>time()
            );
            
            for($i = 0;$i < $total;$i++){
                
                if($coupon['total'] != -1){
                    $max_total = Db::name("bbfx_coupon")->where("id",$coupon['id'])->value("total");
                    if($max_total <= 0){
                        break;
                    }
                }
                
                $res = Db::name("bbfx_user_coupon")->insert($data);
                if($res){
                    if($coupon['total'] != -1){
                        Db::name("bbfx_coupon")->where("id",$coupon['id'])->setDec("total",1);
                    }
                }
                
            }
            
        }
    }
}