<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\yajin;

use app\api\controller\Base;
use think\Db;


class Yajin extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Yajin;
    }
    
    public function index(){
        global $_W;
        
        $levels = $this->model->getYajinLevels($this->user);
        
        __success("操作成功",['levels'=>$levels]);
    }
    
    public function submit(){
        $user = $this->user;
        $config = $this->model->getSet();
        $level_id = $this->param("level_id/d");
        if($config['status'] != 1){
            __error("未开启押金功能");
        }
        
        // $yajin_money = round($config['yajin_money'],2);
        // if($yajin_money <= 0){
        //     __error("平台未设置押金金额");
        // }
        
        $levels = $this->model->getYajinLevels($this->user);
        if(empty($levels)){
            __error("当前等级不可交押金升级");
        }
        
        $level = [];
        foreach($levels as $key => $val){
            if($val['id'] == $level_id){
                $level = $val;
                break;
            }
        }
        if(empty($level)){
            __error("当前等级不可交押金升级");
        }
        
        $log = Db::name("bbfx_yajin_record")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>0,'status'=>1,'extend'=>$level_id])->find();
        if(!empty($log)){
            __error("已支付该押金");
        }
        
        $title = "升级".$level['title']."押金";
        $order_no = date("YmdHis").random(8,true);
        
        $data = [
            "uniacid"=>UNIACID,
            "user_id"=>$user['id'],
            "order_no"=>$order_no,
            "money"=>$level['yajin_money'],
            "title"=>$title,
            "extend"=>$level['id'],
            "createtime"=>time()
        ];
        
        try {
            Db::name("bbfx_yajin_record")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'status'=>0])->delete();
            Db::name("bbfx_yajin_record")->insert($data);
            
        } catch (\Exception $e) {
            __error($e->getMessage());
        }
        
        __success("操作成功",['order_no'=>$order_no]);
    }
    
    public function getList(){
        $status = $this->param("status/d");
        if($status == 1){
            $list = Db::name("bbfx_yajin_refund_record")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id']])->order("id desc")->select();
            foreach ($list as $key => &$val){
                $val['shtime'] = date("Y-m-d H:i:s",$val['shtime']);
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            }
            unset($val);
        }
        else{
            $list = Db::name("bbfx_yajin_record")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>['>',0]])->order("id desc")->select();
            foreach ($list as $key => &$val){
                $val['paytime'] = date("Y-m-d H:i:s",$val['paytime']);
            }
            unset($val);
        }
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function refund(){
        $id = $this->param("id/d");
        $type = $this->param("type/d");
        $info = Db::name("bbfx_yajin_record")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'id'=>$id])->find();
        if(empty($info)){
            __error("押金记录不存在");
        }
        
        if($info['status'] == 0){
            __error("押金未支付");
        }
        if($info['status'] == 2){
            __error("押金已退还");
        }
        
        $record = Db::name("bbfx_yajin_refund_record")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'pid'=>$info['id'],'status'=>['in',[0,1]]])->find();
        if(!empty($record)){
            if($record['status'] == 1){
                __error("押金已退还");
            }
            else{
                __error("押金已申请退还");
            }
        }
        $params = $this->param(['realname/s','alipay/s','realipay','bankname/s','bankcard/s','rebankcard/s','skqrcode/s']);
        $data1 = [];
        if($type == 3){
            if(!$params['realname']){
                __error("请填写姓名");
            }
            if(!$params['alipay']){
                __error("请填写支付宝账号");
            }
            if($params['alipay'] != $params['realipay']){
                __error("两次输入的账号不一致");
            }
            
            $data1 = array(
                "realname"=>$params['realname'],
                "alipay"=>$params['alipay']
            );
        }
        else if($type == 4){
            if(!$params['realname']){
                __error("请填写姓名");
            }
            if(!$params['bankname']){
                __error("请选择银行");
            }
            if(!$params['bankcard']){
                __error("请填写银行卡号");
            }
            if($params['bankcard'] != $params['rebankcard']){
                __error("两次输入的卡号不一致");
            }
            
            $data1 = array(
                "realname"=>$params['realname'],
                "bankname"=>$params['bankname'],
                "bankcard"=>$params['bankcard']
            );
            
        }
        else if($type == 5){
            if(!$params['skqrcode']){
                __error("请上传收款码");
            }
            
            $data1 = array(
                "skqrcode"=>replaceSiteroot($params['skqrcode']),
            );
            
        }
        else if($type == 1 || $type == 2){
            if($money >= 2000 &&  $type == 2){
                if(!$params['realname']){
                    __error("请填写姓名");
                }
                $data1 = array(
                    "realname"=>$params['realname']
                );
            }
        }
        else{
            __error("提现方式错误");
        }
        
        $order_no = date("YmdHis").random(8,true);
        $data = [
            "uniacid"=>UNIACID,
            "user_id"=>$this->user['id'],
            "refund_no"=>$order_no,
            "type"=>$type,
            "money"=>$info['money'],
            "title"=>$info['title'],
            "refund_money"=>$info['money'],
            "pid"=>$info['id'],
            "createtime"=>time()
        ];
        
        $data = array_merge($data,$data1);
        
        try {
            Db::name("bbfx_yajin_refund_record")->insert($data);
        } catch (\Exception $e) {
            __error($e->getMessage());
        }
        
        __success("操作成功");
    }
    
    public function confirm(){
        $refund_no = $this->param("refund_no/s");
        $log = Db::name("bbfx_yajin_refund_record")->where(["uniacid"=>UNIACID,"user_id"=>$this->user['id'],'refund_no'=>$refund_no])->find();
        if(empty($log)){
            __error("未查询到押金退还记录");
        }
        if($log['type'] != 2){
            __error("押金退还类型错误");
        }
        if($log['status'] != 1){
            __error("押金退还未审核通过");
        }
        if($log['is_confirm'] == -1){
            __error("不是新版商家转账到零钱");
        }
        if($log['is_confirm'] == 1){
            __error("已确认收款");
        }
        
        $result = \app\common\model\bbfxshop\Wxpay::queryNewTransfer($log['out_batch_no'],$this->user['platform']);
        if($result['code'] != 1){
            __result($result);
        }
        
        $state = $result['data']['state'];
        if($state == 'SUCCESS'){
            Db::name("bbfx_yajin_refund_record")->where(['id'=>$log['id']])->update(['is_confirm'=>1,'confirmtime'=>time()]);
            __success("操作成功");
        }
        
        __error("您还未确认收款成功");
    }
    
    public function queryWaitInfo(){
        $refund_no = $this->param("refund_no/s");
        $log = Db::name("bbfx_yajin_refund_record")->where(["uniacid"=>UNIACID,"user_id"=>$this->user['id'],'refund_no'=>$refund_no])->find();
        if(empty($log)){
            __error("未查询到押金退还记录");
        }
        
        // __error("未查询到提现记录");
        if($log['type'] != 7){
            __error(-2,"押金退还类型错误");
        }
        if($log['status'] != 1){
            __error(-2,"押金退还未审核通过");
        }
        if($log['is_confirm'] == 1){
            __error(-2,"已确认收款");
        }
        
        $result = \app\common\model\bbfxshop\Wxpay::queryNewTransfer($log['out_batch_no'],$this->user['platform']);
        if($result['code'] != 1){
            __result($result);
        }
        
        $state = $result['data']['state'];
        
        if($state == 'SUCCESS'){
            Db::name("bbfx_yajin_refund_record")->where(['id'=>$log['id']])->update(['is_confirm'=>1,'confirmtime'=>time()]);
            __error(-2,"您已收款成功");
        }
        
        
        if($state != 'WAIT_USER_CONFIRM' && $state != 'TRANSFERING'){
            
            $out_batch_no = date("YmdHis").random(8,true);
            Db::name("bbfx_yajin_refund_record")->where(['id'=>$log['id']])->update(['out_batch_no'=>$out_batch_no]);
            $log['out_batch_no'] = $out_batch_no;
            $transfer_remark = "余额提现";
            $remarks = ['1'=>'余额提现','2'=>'佣金提现','3'=>'积分提现','5'=>'红包提现','6'=>'预存款提现','7'=>'商户提现'];
            $transfer_remark = $remarks[$log['withdrawal_type']];
            
            $res = \app\common\model\bbfxshop\Wxpay::newTransfer($this->user['openid'],$log['realmoney'],$out_batch_no,$log['realname'],$transfer_remark,$user['platform']);
            if($res['code'] != 1){
                __result($res);
            }
            
            $data = [
                'batch_id'=>$res['data']['transfer_bill_no'],
                'package_info'=>''
            ];
            if(!empty($res['data']['package_info'])){
                $data['package_info'] = $res['data']['package_info'];
                $log['package_info'] = $res['data']['package_info'];
            }
            
            Db::name("bbfx_yajin_refund_record")->where(['id'=>$log['id']])->update($data);
            
        }
        
        
        $set = \app\common\model\bbfxshop\Wxpay::getSet($this->user['platform']);
        
        $result = [
            "mchId"=>$set['mchid'],
            "appId"=>$set['appid'],
            "package"=>$log['package_info'],
        ];
        
        __success("操作成功",$result);
    }
}