<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\user;

use app\api\controller\Base;
use think\Db;
use think\Validate;


class User extends Base
{
    protected $noNeedLogin = ['getPhoneNumber','login','info','register','wxappLogin','gzhLogin','getWxappOpenid','mobileAuthLogin'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\User;
    }

    public function logout()
    {
        $this->auth->logout();
        __success('退出成功');
    }
    
    public function update(){
        $params = $this->param(['type/d','nickname/s','avatar/s','skqrcode/s','bank_realname/s','bankname/s','bankcard/s','zfb_realname/s','zfb/s','pay_password/s','password/s','mobile/s','code/s','weixin/s']);
        $platform = $this->paramGet('platform/s');
        $data = [];
        if($params['type'] == 1){
            if(empty($params['nickname'])){
                __error("请输入昵称");
            }
            $data['nickname'] = $params['nickname'];
        }
        else if($params['type'] == 2){
            if(empty($params['avatar'])){
                __error("请上传头像");
            }
            $data['avatar'] = replaceSiteroot($params['avatar']);
        }
        else if($params['type'] == 3){
            if(empty($params['skqrcode'])){
                __error("请上传收款码");
            }
            $data['skqrcode'] = replaceSiteroot($params['skqrcode']);
        }
        else if($params['type'] == 5){
            
            $data = array(
                'zfb_realname'=>$params['zfb_realname'],
                'zfb'=>$params['zfb'],
                'bank_realname'=>$params['bank_realname'],
                'bankname'=>$params['bankname'],
                'bankcard'=>$params['bankcard'],
                'skqrcode'=>replaceSiteroot($params['skqrcode']),
            );
            
        }
        else if($params['type'] == 6){
            $password = $params['pay_password'];
            $mobile = $this->user['mobile'];
            $code = $params['code'];
            if(empty($password)){
                __error("请输入支付密码");
            }
            if(mb_strlen($password, 'UTF-8') != 6){
                __error("请输入6位数字支付密码");
            }
            if(empty($mobile)){
                __error("请先绑定手机号");
            }
            
            $result = \app\common\model\bbfxshop\Sms::checkVerifcode($mobile,$code,"pay_password");
            if($result['code'] !== 1){
                __error($result['message']);
            }
            
            $data['pay_password'] = md5($password);
            if($data['pay_password'] == $this->user['pay_password']){
                __error("旧支付密码与新支付密码不可相同");
            }
        }
        else if($params['type'] == 7){
            $password = $params['password'];
            $mobile = $this->user['mobile'];
            $code = $params['code'];
            if(empty($password)){
                __error("请输入登录密码");
            }
            if(mb_strlen($password, 'UTF-8') < 6){
                __error("登录密码长度不足");
            }
            if(empty($mobile)){
                __error("请输入手机号");
            }
            
            $result = \app\common\model\bbfxshop\Sms::checkVerifcode($mobile,$code,"password");
            if($result['code'] !== 1){
                __error($result['message']);
            }
            $salt = random(8);
            $password = md5(md5($password).$salt);
            
            $data['salt'] = $salt;
            $data['password'] = $password;
        }
        else if($params['type'] == 8){
            $mobile = $params['mobile'];
            $code = $params['code'];
            if(empty($mobile)){
                __error("请输入手机号");
            }
            $mobile_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'mobile'=>$mobile])->find();
            if(!empty($mobile_user) && $mobile_user['id'] != $this->user['id']){
                __error("该手机号已被使用");
            }
            
            $result = \app\common\model\bbfxshop\Sms::checkVerifcode($mobile,$code,"bind");
            if($result['code'] !== 1){
                __error($result['message']);
            }
            
            $data['mobile'] = $mobile;
            
            if($this->user['platform'] == 'H5' || $this->user['platform'] == 'APP'){
                $openid = $this->user['platform']."_".$mobile."_".random(8);
                $data['openid'] = $openid;
            }
        }
        else if($params['type'] == 21){
            if(empty($params['weixin'])){
                __error("请填写微信号");
            }
            $data['weixin'] = $params['weixin'];
        }
        else{
            __error("修改失败");
        }
        $res = Db::name("bbfx_user")->where('id',$this->user['id'])->update($data);
        if($res){
            /*
            if($params['type'] == 8){
                $uudata = ['username'=>$data['mobile'],'mobile'=>$data['mobile']];
                if(!empty($data['openid']) && $this->user['platform'] != 'WXAPP' && $platform != 'wxapp'){
                    $uudata['openid'] = $data['openid'];
                }
                Db::name("user")->where("id",$this->user['uid'])->update($uudata);
            }
            */
            __success("修改成功");
        }
        else{
            __error("修改失败");
        }
    }
    
    public function scoreLog(){
        global $_W;
        $params = $this->param(['page/d','current/d']);
        
        $user = $this->user;
        
        $page = max(1,intval($params['page']));
        $psize = 20;
        $where = ['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>2];
        if($params['current'] == 1){
            $where['money'] = ['>',0];
        }
        else if($params['current'] == 2){
            $where['money'] = ['<',0];
        }
        
        $list = Db::name("bbfx_money_log")->where($where)->order(['createtime desc','id desc'])->limit(($page-1)*$psize,$psize)->select();
        
        if(empty($list)){
            __error($page==1?'暂无数据~':'没有更多了~');
        }
        else{
            foreach ($list as $key => &$val){
                if($val['money'] > 0){
                    $val['moneyText'] = "+".$val['money'];
                }
                else{
                    $val['moneyText'] = $val['money'];
                }
                
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
                $info = iunserializer($val['info']);
                if(!empty($info) && $val['item_type'] == 26){
                    $val['surplus'] = round($info['surplus'],2);
                }
                $val['info'] = $info;
                if($val['item_type'] == 3){
                    $val['title'] = $info['notes'];
                }
                if($val['item_type'] == 26){
                    $val['remarks'] = $_W['fenxiao']['texts']['cumulative_total_fanhuan'];
                }
            }
            unset($val);
            
            $income = "0.00";
            $pay = "0.00";
            if($page == 1){
                $income = Db::name("bbfx_money_log")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>2,'money'=>['>',0]])->sum("money");
                $pay = Db::name("bbfx_money_log")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>2,'money'=>['<',0]])->sum("money");
            }
            
            __success("success",['list'=>$list,'income'=>round($income,2),'pay'=>round($pay,2)]);
        }
        
        
    }
    
    public function moneyLog(){
        global $_W;
        $params = $this->param(['page/d','current/d']);
        
        $user = $this->user;
        
        $page = max(1,intval($params['page']));
        $psize = 20;
        $where = ['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>1];
        if($params['current'] == 1){
            $where['money'] = ['>',0];
        }
        else if($params['current'] == 2){
            $where['money'] = ['<',0];
        }
        
        $list = Db::name("bbfx_money_log")->where($where)->order(['createtime desc','id desc'])->limit(($page-1)*$psize,$psize)->select();
        
        if(empty($list)){
            __error($page==1?'暂无数据~':'没有更多了~');
        }
        else{
            $commission_status = ['1'=>'一级佣金','2'=>'二级佣金','3'=>'三级佣金', '4'=>'级差奖','5'=>'见单奖','6'=>'平级奖','7'=>'加权分红','8'=>'总分红','9'=>'总分红(规则)','10'=>'加权分红'];
            foreach ($list as $key => &$val){
                if($val['money'] > 0){
                    $val['moneyText'] = "+".$val['money'];
                }
                else{
                    $val['moneyText'] = $val['money'];
                }
                
                
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
                $info = iunserializer($val['info']);
                if(!empty($info) && $val['item_type'] == 26){
                    $val['surplus'] = round($info['surplus'],2);
                }
                $val['info'] = $info;
                if($val['item_type'] == 3){
                    $val['title'] = $info['notes'];
                }
                else if($val['item_type'] == 11){
                    $val['title'] = $commission_status[$info['type']];
                }
                
                if(!empty($info['user_id']) && $val['item_type'] == 11 && $info['itype'] == 3){
                    
                    // $val['order_no'] = $info['info']['order_no'];
                    // $val['order_id'] = $info['info']['id'];
                    
                    // // echo "<pre>";
                    // // print_r($info);die;
                    
                    // $xia_user = pdo_get("duoduo_activity_user",['id'=>$info['info']['user_id']],['id','avatar','nickname']);
                    // if(!empty($xia_user)){
                    //     $xia_user['avatar'] = tomedia($xia_user['avatar']);
                    //     $val['xia_user'] = $xia_user;
                    // }
                }
                
                if($val['item_type'] == 26){
                    $val['remarks'] = $_W['fenxiao']['texts']['cumulative_total_fanhuan'];
                }
            }
            unset($val);
            
            $income = "0.00";
            $pay = "0.00";
            if($page == 1){
                $income = Db::name("bbfx_money_log")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>1,'money'=>['>',0]])->sum("money");
                $pay = Db::name("bbfx_money_log")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'type'=>1,'money'=>['<',0]])->sum("money");
            }
            
            __success("success",['list'=>$list,'income'=>round($income,2),'pay'=>round($pay,2)]);
        }
        
        
    }
    
    public function addUpdateNotice(){
        $params = $this->param();
        
        $user = $this->user;
        
        Db::name("bbfx_user")->where(['id'=>$user['id']])->setInc("update_notice",1);
        
        __success("操作成功");
    }
    
    public function bindMobile(){
        $params = $this->param();
        
        $code = trim($params['code']);
        
        $result = \app\common\model\bbfxshop\Weixin::getPhoneNumber($code);
        
        if(empty($result) || $result['code'] != 1){
            __error($result['message']);
        }
        else{
            
            Db::name("bbfx_user")->where("id",$this->user['id'])->update(['mobile'=>$result['data']]);
            
            __success("操作成功",['mobile'=>$result['data']]);
        }
    }
    
    public function getPhoneNumber(){
        $params = $this->param();
        
        $code = trim($params['code']);
        
        $result = \app\common\model\bbfxshop\Weixin::getPhoneNumber($code);
        
        if(empty($result) || $result['code'] != 1){
            __error($result['message']);
        }
        else{
            __success("操作成功",['mobile'=>$result['data']]);
        }
    }
    
    public function login(){
        global $_W;
        $params = $this->param();
        
        $code = $params['code'];
        $mobile = $params['mobile'];
        $platform = $params['platform'];
        $sup_uid = intval($params['sup_uid']);
        $wxapp_login = intval($_W['base']['wxapp_login']);
        if($platform == 'wxapp' && $wxapp_login == 0){
            $this->wxappLogin();
        }
        
        
        $type = intval($params['type']);
        if($wxapp_login == 3){
            if(empty($mobile)){
                __error("请输入用户名");
            }
            $user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'username'=>$mobile])->find();
            if(empty($user) && Validate::regex($mobile, "^1\d{10}$")){
                $user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'mobile'=>$mobile])->find();
            }
            if(empty($user)){
                __error("用户名或密码错误");
            }
            $type = 1;
        }
        else{
            if(empty($mobile)){
                __error("请输入手机号");
            }
            $user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'mobile'=>$mobile])->find();
            if(empty($user)){
                __error("手机号未注册");
            }
        }
        
        
        if($type == 1){
            $password = trim($params['password']);
            $password = md5(md5($password).$user['salt']);
            
            if($password !== $user['password']){
                if($wxapp_login == 3){
                    __error("用户名或密码错误");
                }
                else{
                    __error("密码错误");
                }
            }
        }
        else{
            
            if(empty($code)){
                __error("请输入验证码");
            }
            
            $result = \app\common\model\bbfxshop\Sms::checkVerifcode($mobile,$code,"login");
            if($result['code'] !== 1){
                __error($result['message']);
            }
        }
        
        $ret = $this->auth->direct($user['id']);
        if(empty($ret)){
            __error($this->auth->getError());
        }
        $user = $this->auth->getUserinfo();
        if($sup_uid > 0){
            $this->model->bind($user,$sup_uid);
        }
        
        $user = filterData($user,"password,pay_password");
        __success("登录成功",$user);
    }
    
    public function register(){
        global $_W;
        $params = $this->param();
        $code = $params['code'];
        $mobile = $params['mobile'];
        $password = trim($params['password']);
        $repassword = trim($params['repassword']);
        $sup_code = $params['sup_code'];
        $platform = $params['platform'];
        $login_code = $params['login_code'];
        $wxapp_login = intval($_W['base']['wxapp_login']);
        
        if($wxapp_login == 3){
            if(empty($mobile)){
                __error("请输入用户名");
            }
            $user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'username'=>$mobile])->find();
            if(!empty($user)){
                __error("用户名已存在");
            }
        }
        else{
            if(empty($mobile)){
                __error("请输入手机号");
            }
            if(empty($code)){
                __error("请输入验证码");
            }

            $user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'mobile'=>$mobile])->find();
            if(!empty($user)){
                __error("手机号已注册");
            }
            if(empty($code)){
                __error("请输入验证码");
            }
        }
        
        if(empty($password)){
            __error("请输入密码");
        }
        if($password !== $repassword){
            __error("两次输入的密码不一致");
        }
        
        if(mb_strlen($password, 'UTF-8') < 6){
            __error("密码长度不足，最低6位字符");
        }
        
        $openid = $platform."_".$mobile."_".random(8);
        $register_type = 0;// 0=未注册，1=合并，2=新账号
        if($platform == 'wxapp'){
            if($wxapp_login != 1 && $wxapp_login != 3){
                __error("不支持注册方式");
            }
            $result = \app\common\model\bbfxshop\Weixin::login($login_code);
            if(empty($result) || $result['code'] != 1){
                __error($result['message']);
            }
            $wxapp_openid = $result['data']['openid'];
            $wxapp_user = $this->model->getUser($wxapp_openid);
            
            if(!empty($wxapp_user)){
                if(empty($wxapp_user['mobile']) && $wxapp_login != 3){
                    $openid = $wxapp_openid;
                    $register_type = 1;
                }
                else{
                    $openid = "";
                    $register_type = 2;
                }
            }
            else{
                $openid = $wxapp_openid;
            }
        }
        
        if($wxapp_login != 3){
            $result = \app\common\model\bbfxshop\Sms::checkVerifcode($mobile,$code,"register");
            if($result['code'] != 1){
                __error($result['message']);
            }
        }
        
        $sup_uid = 0;
        $sup_path = "0";
        if(!empty($sup_code)){
            $sup_user = $this->model->getSupUser(intval($sup_code));
            if(!empty($sup_user)){
                $sup_uid = $sup_user['id'];
                $sup_path = $sup_user['sup_path'];
            }
        }
        
        $avatar = $params['avatar'];
        $nickname = $params['nickname'];
        $sex = intval($params['sex']);
        $platform = $params['platform'];
        
        if(empty($nickname)){
            if($wxapp_login == 3){
                $nickname = "用户".random(9,true);
            }
            else{
                $nickname = secret($mobile,true,3,4);
            }
        }
        if(empty($avatar)){
            $avatar = "/assets/images/avatar.jpg";
        }
        
        /*
        if($register_type == 1){
            $ret = $this->auth->direct($wxapp_user['uid']);
        }
        else{
            $userinfo = Db::name("user")->where("mobile",$mobile)->find();
            
            if(empty($userinfo)){
                $username = $mobile;
                if(empty($username)){
                    $username = random(12,true);
                }
                $extend = ['avatar'=>$avatar,'nickname'=>$nickname,'openid'=>$openid];
                
                $ret = $this->auth->register($username, $password, '', $mobile, $extend);
            }
            else{
                
                $ouser = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'uid'=>$userinfo['id']])->find();
                if(!empty($ouser) && $wxapp_user['id'] != $ouser['id']){
                    __error("手机号已注册");
                }
                
                $ret = $this->auth->direct($userinfo['id']);
            }
            
        }
        */
        
        
        // if(empty($ret)){
        //     __error($this->auth->getError());
        // }
        
        // $userinfo = $this->auth->getUserinfo();
        
        $salt = random(8);
        $password = md5(md5($password).$salt);
        
        $data = array(
            "uniacid"=>UNIACID,
            "avatar"=>$avatar,
            "nickname"=>$nickname,
            "sex"=>$sex,
            "password"=>$password,
            "salt"=>$salt,
        );

        if($wxapp_login == 3){
            $data['username'] = $mobile;
        }
        else{
            $data['mobile'] = $mobile;
        }
        
        if($register_type == 1){
            $user_id = $wxapp_user['id'];
            Db::name("bbfx_user")->where(['id'=>$user_id])->update($data);
        }
        else{
            // $data['uid'] = $userinfo['id'];
            $data['sup_uid'] = $sup_uid;
            $data['openid'] = $openid;
            $data['createtime'] = time();
            $data['platform'] = $platform;
            if($sup_uid){
                $data['bindtime'] = time();
            }
            $data['code'] = random_int(100000,999999);
            $data['id'] = $this->model->uuid();
            $user_id = $data['id'];
            Db::name("bbfx_user")->insert($data);
        }
        
        
        if(empty($user_id)){
            __error("注册失败");
        }
        
        if($register_type != 1){
            $sup_path .= "-".$user_id;
            Db::name("bbfx_user")->where(['id'=>$user_id])->update(['sup_path'=>$sup_path]);
        }
        
        \app\common\model\bbfxshop\FenxiaoUpgrade::upgrade($user_id);
        
        $ret = $this->auth->direct($user_id);
        if(empty($ret)){
            __error($this->auth->getError());
        }
        $user = $this->auth->getUserinfo();
        $user = filterData($user,"password,pay_password");
        __success("注册成功",$user);
    }
    
    public function gzhLogin(){
        global $_W;
        $params = $this->param(['source/s','sup_uid/s','ret_url/s']);
        
        $source = $params['source'];
        $sup_uid = intval($params['sup_uid']);
        $ret_url = $params['ret_url'];
        
        if(empty($ret_url)){
            $ret_url = "/pages/index/index";
        }
        
        if(empty($source)){
            $source = "mobile";
        }
        
        $platform = $_W['platform'];
        
        if($source == 'mobile'){
            
            $ret_url = urldecode($ret_url);
            
            $redirect_uri = request()->domain()."/api/user/user/gzhLogin?source=wechat&ret_url={$ret_url}&i=".UNIACID;
            if(!empty($sup_uid)){
                $redirect_uri .= "&sup_uid={$sup_uid}";
            }
            $redirect_uri = urlencode($redirect_uri);
            
            
            $url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={$platform['AppId']}&redirect_uri={$redirect_uri}&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect";
            
            $this->success("操作成",$url);
        }
        else if($source == 'wechat'){
            $code = $this->paramGet('code/s');
            
            $url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={$platform['AppId']}&secret={$platform['AppSecret']}&code={$code}&grant_type=authorization_code";
            
            $result = ihttp_get($url);
            $result = json_decode($result['content'],true);
            
            if(empty($result['access_token'])){
                __error($result['errmsg']);
            }
            
            $access_token = $result['access_token'];
            $openid = $result['openid'];
            $is_snapshotuser = 0;
            if(!empty($result['is_snapshotuser'])){
                if($result['is_snapshotuser'] == 1){
                    $is_snapshotuser = 1;
                }
            }
            
            if($is_snapshotuser != 1){
                $result = ihttp_get("https://api.weixin.qq.com/sns/userinfo?access_token={$access_token}&openid={$openid}&lang=zh_CN");
            
                $result = json_decode($result['content'],true);
                $nickname = "";
                $avatar = "";
                if(empty($result['openid'])){
                    __error("登录失败");
                }
                
                /*
                $userinfo = Db::name("user")->where("openid",$openid)->find();
                if(empty($userinfo)){
                    $mobile = "";
                    $username = $mobile;
                    if(empty($username)){
                        $username = random(12,true);
                    }
                    $password = "123456789";
                    $extend = ['avatar'=>$result['headimgurl'],'nickname'=>$result['nickname'],'openid'=>$openid];
                    
                    $ret = $this->auth->register($username, $password, '', $mobile, $extend);
                    $userinfo = Db::name("user")->where("openid",$openid)->find();
                }
                else{
                    $ret = $this->auth->direct($userinfo['id']);
                }
                if(empty($ret)){
                    __error($this->auth->getError());
                }
                */
                
                $ret = $this->auth->direct($openid);
                
                $token = "";
                
                $data = ['avatar'=>$result['headimgurl'],'nickname'=>$result['nickname']];
                
                if(empty($ret)){
                    // $data['uid'] = $userinfo['id'];
                	$data['createtime'] = time();
                    $data['openid'] = $openid;
                    $data['uniacid'] = UNIACID;
                    $data['platform'] = "GZH";
                    
                    $sup_path = "0";
                    if($sup_uid > 0){
                        $sup_user = $this->model->getSupUser($sup_uid);
                        if(!empty($sup_user)){
                            $data['sup_uid'] = $sup_user['id'];
                            $sup_path = $sup_user['sup_path'];
                        }
                        else{
                            $data['sup_uid'] = 0;
                        }
                    }
                    $data['code'] = random_int(100000,999999);
                    $data['id'] = $this->model->uuid();
                    $user_id = $data['id'];
                    Db::name("bbfx_user")->insert($data);
                    if(empty($user_id)){
                        __error("登录失败");
                    }
                    
                    $sup_path .= "-".$user_id;
                    Db::name("bbfx_user")->where(['id'=>$user_id])->update(['sup_path'=>$sup_path]);
                    \app\common\model\bbfxshop\FenxiaoUpgrade::upgrade($user_id);
                    
                    $ret = $this->auth->direct($user_id);
                    if(empty($ret)){
                        __error($this->auth->getError());
                    }
                    $user = $this->auth->getUserinfo();
                }
                else{
                    $user = $this->auth->getUserinfo();
                    Db::name("bbfx_user")->where(['id'=>$this->auth->id])->update($data);
                    if($sup_uid > 0){
                        $this->model->bind($user,$sup_uid);
                    }
                }
                
                $token = $user['token'];
                $_SESSION['uToken'] = $token;
            }
            
            $ret_url = urldecode($ret_url);
            
            $url = request()->domain()."/mobile/#".$ret_url;
            header("Location: ".$url);
            exit();
        }
    }
    
    public function getWxappOpenid(){
        $code = $this->param("code/s");
        $result = \app\common\model\bbfxshop\Weixin::login($code);
        if(empty($result) || $result['code'] != 1){
            __error($result['message']);
        }
        
        $openid = $result['data']['openid'];
        
        __success("操作成功",$openid);
    }
    
    // 手机号授权登录
    public function mobileAuthLogin(){
        $params = $this->param(['code/s','login_code/s','platform/s','sup_uid/d']);
        
        $code = trim($params['code']);
        $login_code = trim($params['login_code']);
        $platform = trim($params['platform']);
        
        $result = \app\common\model\bbfxshop\Weixin::getPhoneNumber($code);
        
        if(empty($result) || $result['code'] != 1){
            __error($result['message']);
        }
        
        $mobile = $result['data'];
        if(empty($mobile)){
            __error("手机号错误");
        }
        
        $result = \app\common\model\bbfxshop\Weixin::login($login_code);
        if(empty($result) || $result['code'] != 1){
            __error($result['message']);
        }
        $openid = $result['data']['openid'];
        
        $data = [];
        
        $openid_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'openid'=>$openid])->find();
        $user = [];
        if(!empty($openid_user)){
            if($openid_user['mobile'] == $mobile || empty($openid_user['mobile'])){
                $user = $openid_user;
                if(empty($openid_user['mobile'])){
                    $data['mobile'] = $mobile;
                }
            }
        }
        
        if(empty($user)){
            $mobile_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'mobile'=>$mobile])->find();
            if(!empty($mobile_user)){
                $user = $mobile_user;
            }
        }
        
        $avatar = "/assets/images/avatar.jpg";
        $nickname = secret($mobile,true,3,4);
        
        if(!empty($user)){
            
            if(!empty($data)){
                Db::name("bbfx_user")->where(['id'=>$user['id']])->update($data);
            }
            
            $sup_uid = intval($params['sup_uid']);
            if($sup_uid > 0){
                $this->model->bind($user,$sup_uid);
            }
            $user_id = $user['id'];
        }
        else{
            
            $data['uniacid'] = UNIACID;
            $data['openid'] = $openid;
            $data['avatar'] = $avatar;
        	$data['nickname'] = $nickname;
            // $data['sex'] = 1;
            $data['mobile'] = $mobile;
        	$data['createtime'] = time();
            
            $sup_uid = intval($params['sup_uid']);
            $sup_path = "0";
            if($sup_uid > 0){
                $sup_user = $this->model->getSupUser($sup_uid);
                if(!empty($sup_user)){
                    $data['sup_uid'] = $sup_user['id'];
                    $data['bindtime'] = time();
                    $sup_path = $sup_user['sup_path'];
                }
            }

            $data['code'] = random_int(100000,999999);
            $data['id'] = $this->model->uuid();
            $user_id = $data['id'];
            Db::name("bbfx_user")->insert($data);
            
            $is_new = 1;
            
        }
        
        $ret = $this->auth->direct($user_id);
        if(empty($ret)){
            __error($this->auth->getError());
        }
        $user = $this->auth->getUserinfo();
        
        if($is_new == 1){
            $sup_path .= "-".$user['id'];
            Db::name("bbfx_user")->where(['id'=>$user['id']])->update(['sup_path'=>$sup_path]);
            \app\common\model\bbfxshop\FenxiaoUpgrade::upgrade($user['id']);
        }
        $user = filterData($user,"password,pay_password");
        __success("登录成功",$user);
    }
    
    public function wxappLogin(){
        global $_W;
        $params = $this->param();
        
        $code = trim($params['code']);
        
        if($_W['base']['wxapp_login'] == 1){
            __error("不支持该登录方式");
        }
        
        $result = \app\common\model\bbfxshop\Weixin::login($code);
        if(empty($result) || $result['code'] != 1){
            __error($result['message']);
        }
        
        $openid = $result['data']['openid'];
        $ret = $this->auth->direct($openid);
        
        $data = [];
        $avatar = $params['avatar'];
        $nickname = $params['nickname'];
        $mobile = $params['mobile'];
        $sex = intval($params['sex']);
        
        if(empty($avatar)){
            $avatar = "/assets/images/avatar.jpg";
        }
        if(empty($nickname) && !empty($mobile)){
            $nickname = secret($mobile,true,3,4);
        }
        if(empty($nickname)){
            $nickname = "用户".random(8,true);
        }
        
        if(!empty($avatar) || !empty($nickname)){
            $data['avatar'] = $avatar;
        	$data['nickname'] = $nickname;
        }
        
        if(!empty($ret)){
            
            /*
            $ret = $this->auth->direct($user['uid']);
            if(empty($ret)){
                __error($this->auth->getError());
            }
            $userinfo = $this->auth->getUserinfo();
            */
            
            Db::name("bbfx_user")->where(['id'=>$this->auth->id])->update($data);
            $user_id = $this->auth->id;
            
            $user = $this->auth->getUserinfo();
            $sup_uid = intval($params['sup_uid']);
            if($sup_uid > 0){
                $this->model->bind($user,$sup_uid);
            }
        }
        else{
            /*
            $userinfo = Db::name("user")->where("openid",$openid)->find();
            if(empty($userinfo)){
                $username = $mobile;
                if(empty($username)){
                    $username = random(12,true);
                }
                $password = "123456789";
                $extend = ['avatar'=>$avatar,'nickname'=>$nickname,'openid'=>$openid];
                
                $ret = $this->auth->register($username, $password, '', $mobile, $extend);
                
            }
            else{
                $ret = $this->auth->direct($userinfo['id']);
            }
            if(empty($ret)){
                __error($this->auth->getError());
            }
            $userinfo = $this->auth->getUserinfo();
            $data['uid'] = $userinfo['id'];
            */
            
            
        	$data['createtime'] = time();
            $data['openid'] = $openid;
            $data['sex'] = $sex;
            $data['mobile'] = $mobile;
            $data['uniacid'] = UNIACID;
            
            $set = $_W['base'];
            
            if($set['is_forcemobile'] == 1 && empty($mobile)){
                __error("请授权手机号");
            }
            
            
            $sup_uid = intval($params['sup_uid']);
            $sup_path = "0";
            if($sup_uid > 0){
                $sup_user = $this->model->getSupUser($sup_uid);
                if(!empty($sup_user)){
                    $data['sup_uid'] = $sup_user['id'];
                    $data['bindtime'] = time();
                    $sup_path = $sup_user['sup_path'];
                }
            }
            $data['code'] = random_int(100000,999999);
            $data['id'] = $this->model->uuid();
            $user_id = $data['id'];

            Db::name("bbfx_user")->insert($data);
            
            $is_new = 1;
            
            $ret = $this->auth->direct($user_id);
            if(empty($ret)){
                __error($this->auth->getError());
            }
            $user = $this->auth->getUserinfo();
        }
        
        if($is_new == 1){
            $sup_path .= "-".$user['id'];
            Db::name("bbfx_user")->where(['id'=>$user['id']])->update(['sup_path'=>$sup_path]);
            \app\common\model\bbfxshop\FenxiaoUpgrade::upgrade($user['id']);
        }
        $user = filterData($user,"password,pay_password");
        __success("登录成功",$user);
    }
    
    public function info(){
        
        $params = $this->param(['code/s','sup_uid/d']);
        
        $user = $this->user;
        $code = $params['code'];
        $sup_uid = $params['sup_uid'];
        if(empty($user) && !empty($code)){
            
            $result = \app\common\model\bbfxshop\Weixin::login($code);
            if(empty($result) || $result['code'] != 1){
                __error($result['message']);
            }
            
            $openid = $result['data']['openid'];
            
            $ret = $this->auth->direct($openid);
            if(empty($ret)){
                __error("用户不存在");
            }
            $user = $this->auth->getUserinfo();
        }
        
        if(!empty($user)){
            if($sup_uid > 0){
                $this->model->bind($user,$sup_uid);
            }
            
            $user = filterData($user,"password,pay_password");
            __success("操作成功",$user);
        }
        else{
            __error("用户不存在");
        }
    }
    
    public function subscribe(){
        global $_W;
        $params = $this->param();
        
        $user = $this->user;
        $base = $_W['base'];
        
        Db::name("bbfx_user")->where(["uniacid"=>UNIACID,"id"=>$user['id']])->setInc("subscribe_num",1);
        $user = Db::name("bbfx_user")->where(["uniacid"=>UNIACID,"id"=>$user['id']])->find();
        $user['isAdmin'] = 0;
        if($base['admin']){
             $admin = explode(",",$base['admin']);
             foreach ($admin as $key => $val){
                 if($val == $user['id']){
                     $user['isAdmin'] = 1;
                 }
             }
        }
        
        $user = filterData($user,"password,pay_password");
        
        __success("success",$user);
    }
}