<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\user;

use app\api\controller\Base;
use think\Db;


class Recharge extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\User;
    }
    
    public function submit(){
        global $_W;
        $base = $_W['base'];
        $recharge = $base['recharge'];
        $params = $this->param(['money/f','mode/d','type/d','pay_pingzheng/s']);
        freezeUserTips($this->user);
        $money = floatval($params['money']);
        $type = max(1,intval($params['type']));
        $mode = $params['mode'];
        if($money <= 0){
            __error("充值金额错误");
        }
        if($mode <= 0){
            __error("请选择充值方式");
        }

        $min = round($recharge['min'],2);
        $max = round($recharge['max'],2);

        if($money < $min){
            __error("最低充值".$min);
        }
        if($money > $max){
            __error("最高充值".$min);
        }

        if($type == 2){
            if($base['is_recharge'] != 1){
                __error("未开启积分充值");
            }
            $recharge_ratio = floatval($base['recharge_ratio']);
            if($recharge_ratio <= 0){
                $recharge_ratio = 1;
            }
            $actual_money = $money * $recharge_ratio;
        }
        else{
            $actual_money = $money;
        }
        
        $recharge = $base['recharge'];
        
        if(empty($mode)){
            $mode = 1;
        }
        
        $order_no = date('YmdHis').random(8,true);  
        $data = array(
            "uniacid"=>UNIACID,
            "order_no"=>$order_no,
            "user_id"=>$this->user['id'],
            "money"=>$money,
            "actual_money"=>$actual_money,
            "type"=>$type,
            "mode"=>$mode,
            "status"=>1,
            "createtime"=>time()
        );
        
        if($mode != 1){
            $data['status'] = 0;
            if(empty($params['pay_pingzheng'])){
                __error("请上传支付凭证截图");
            }
            $data['pay_pingzheng'] = replaceSiteroot($params['pay_pingzheng']);
        }
        
        $res = Db::name("bbfx_recharge_order")->insertGetId($data);
        if($res){
            __success("操作成功",['order_no'=>$order_no,'id'=>$res]);
        }
        else{
            __error("充值失败");
        }
    }

    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        $where = array("a.uniacid"=>UNIACID,'a.user_id'=>$this->user['id']);
        $status = intval($params['status']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        
        if($status){
            $where['a.status'] = $status;
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        if($endTime){
            $whereTime['a.createtime'] = ['<=',$endTime];
        }

        $where1 = function($query){
            $query->whereOr(function($query){
                $query->where(['a.mode'=>1,'a.is_pay'=>1]);
            });
            $query->whereOr(function($query){
                $query->where(['a.mode'=>['>',1]]);
            });
        };

        $list = Db::name("bbfx_recharge_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($where1)->where($whereTime)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
        
        $mode_list = ['1'=>'微信在线充值','2'=>'银行卡转账','3'=>'支付宝转账','4'=>'微信收款码','5'=>'支付宝收款码','6'=>'虚拟币','7'=>'数字人民币','8'=>'云闪付','9'=>'CB Pay','10'=>'JD Pay','11'=>'EB Pay','12'=>'DDB Pay','13'=>'MIN Pay'];
        
    	foreach($list as &$val){
    	    $val['avatar'] = cdnurl($val['avatar']);
    	    $val['pay_pingzheng'] = cdnurl($val['pay_pingzheng']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    if($val['paytime']){
    	        $val['paytime'] = date("Y-m-d H:i:s",$val['paytime']);
    	    }
    	    else{
    	        $val['paytime'] = "";
    	    }
            $type = "充值余额";
            if($val['type'] == 2){
                    $type = "充值积分";
            }
            $mode = $mode_list[$val['mode']];
            if(empty($mode)){
                $mode = "未知充值方式";
            }
            $val['type_text'] = $type;
            $val['mode_text'] = $mode;
    	    
    	}
    	unset($val);
    	
    	$total = Db::name("bbfx_recharge_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($where1)->where($whereTime)->count();
      	
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }

    public function detail(){
        $id = $this->param("id/d");
        $info = Db::name("bbfx_recharge_order")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'id'=>$id])->find();
        if(empty($info)){
            __error("数据不存在");
        }
        $info['pay_pingzheng'] = cdnurl($info['pay_pingzheng']);
        $info['createtime'] = date("Y-m-d H:i:s",$info['createtime']);
        if($info['paytime']){
            $info['paytime'] = date("Y-m-d H:i:s",$info['paytime']);
        }
        else{
            $info['paytime'] = "";
        }
        $type = "充值余额";
        if($info['type'] == 2){
            $type = "充值积分";
        }
        $mode_list = ['1'=>'微信在线充值','2'=>'银行卡转账','3'=>'支付宝转账','4'=>'微信收款码','5'=>'支付宝收款码','6'=>'虚拟币','7'=>'数字人民币','8'=>'云闪付','9'=>'CB Pay','10'=>'JD Pay','11'=>'EB Pay','12'=>'DDB Pay','13'=>'MIN Pay'];
        $mode = $mode_list[$info['mode']];
        if(empty($mode)){
            $mode = "未知充值方式";
        }
        $info['type_text'] = $type;
        $info['mode_text'] = $mode;

        __success("操作成功",['info'=>$info]);
    }
}