<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\store;

use app\api\controller\store\StoreBase;
use think\Db;


class Store extends StoreBase
{
    protected $noNeedLogin = ['getList'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Store;
    }
    
    public function info(){
        $id = $this->param("id/d");
        $store = $this->model->getInfo($id);
        if(empty($store)){
           __error('门店不存在'); 
        }
        $store['logo'] = cdnurl($store['logo']);
        __success('操作成功',$store);
    }
    
    public function getInfo(){
        global $_W;
        $identity = $this->param("identity/d");
        if($identity == 1){
            $info = ['name'=>$_W['base']['title']];
            
            $ids = array_column($this->dealer_store, 'id');
            $store_id = $this->param("store_id/d");
            $ids[] = -1;
            $status_where = ['uniacid'=>UNIACID,'store_id'=>['in',$ids]];
            if($store_id > 0){
                $status_where['store_id'] = $store_id;
            }
            
        }
        else{
            $info = $this->store;
            
            $info['logo'] = cdnurl($store['logo']);
            $status_where = ['uniacid'=>UNIACID,'store_id'=>$this->store['id']];
        }
        
        
        $info['today_order'] = Db::name("bbfx_order")->where($status_where)->where(['createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->count();
        $info['today_income'] = round(Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>1,'type'=>['in',[25,26]],'is_daozhang'=>1,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->sum("money"),2);
        
        $info['order_status0'] = Db::name("bbfx_order")->where($status_where)->where(['status'=>0])->count();
        $info['order_status1'] = Db::name("bbfx_order")->where($status_where)->where(['status'=>1])->count();
        $info['order_status2'] = Db::name("bbfx_order")->where($status_where)->where(['status'=>2])->count();
        $info['order_status3'] = Db::name("bbfx_order")->where($status_where)->where(['status'=>3])->count();
        $info['order_status4'] = Db::name("bbfx_order")->where($status_where)->where(['refund_status'=>['in',[0,1,2]]])->count();
        
        // 累计收款
        $info['order_price'] = round(Db::name("bbfx_order")->where($status_where)->where(['is_pay'=>1])->sum("price"),2);
        $info['yesterday_order_price'] = round(Db::name("bbfx_order")->where($status_where)->where(['is_pay'=>1,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00")." -1 day")]])->where(['createtime'=>['<',strtotime(date("Y-m-01 00:00:00"))]])->sum("price"),2);
        $info['month_order_price'] = round(Db::name("bbfx_order")->where($status_where)->where(['is_pay'=>1,'createtime'=>['>',strtotime(date("Y-m-01 00:00:00"))]])->sum("price"),2);
        
        // 累计退款
        $info['refund_price'] = round(Db::name("bbfx_order")->where($status_where)->where(['is_pay'=>1,'refund_status'=>1])->sum("price"),2);
        $info['yesterday_refund_price'] = round(Db::name("bbfx_order")->where($status_where)->where(['is_pay'=>1,'refund_status'=>1,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00")." -1 day")]])->where(['createtime'=>['<',strtotime(date("Y-m-01 00:00:00"))]])->sum("price"),2);
        $info['month_refund_price'] = round(Db::name("bbfx_order")->where($status_where)->where(['is_pay'=>1,'refund_status'=>1,'createtime'=>['>',strtotime(date("Y-m-01 00:00:00"))]])->sum("price"),2);
        
        // 累计提现
        $info['withdrawal_money'] = round(Db::name("bbfx_withdrawal_log")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>1])->sum("money"),2);
        $info['yesterday_withdrawal_money'] = round(Db::name("bbfx_withdrawal_log")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>1,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00")." -1 day")]])->where(['createtime'=>['<',strtotime(date("Y-m-01 00:00:00"))]])->sum("money"),2);
        $info['month_withdrawal_money'] = round(Db::name("bbfx_withdrawal_log")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>1,'createtime'=>['>',strtotime(date("Y-m-01 00:00:00"))]])->sum("money"),2);
        
        // 累计佣金
        $info['commission_total'] = round(Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>1,'type'=>['in',[25,26]],'is_daozhang'=>1])->sum("money"),2);
        $info['commission_yesterday'] = round(Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>1,'type'=>['in',[25,26]],'is_daozhang'=>1,'dztime'=>['>',strtotime(date("Y-m-d 00:00:00")." -1 day")]])->where(['dztime'=>['<',strtotime(date("Y-m-01 00:00:00"))]])->sum("money"),2);
        $info['commission_month'] = round(Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>1,'type'=>['in',[25,26]],'is_daozhang'=>1,'dztime'=>['>',strtotime(date("Y-m-01 00:00:00"))]])->sum("money"),2);
        
        $info['btns'] = array(
            array('title'=>'核销记录','icon'=>cdnurl('/assets/images/hexiao-ico.png'),'path'=>'/pagesS/hexiao/record?identity='.$identity),
            array('title'=>'积分兑换','icon'=>cdnurl('/assets/images/hexiao-ico.png'),'path'=>'/pagesS/scoreshop/order?identity='.$identity),
            array('title'=>'数据统计','icon'=>cdnurl('/assets/images/hexiao-ico.png'),'path'=>'/pagesS/store/statistics?identity='.$identity),
            // array('title'=>'切换账号','icon'=>cdnurl('/assets/images/switch-ico.png'),'path'=>'switch_accounts'),
            // array('title'=>'修改密码','icon'=>cdnurl('/assets/images/upw-ico.png'),'path'=>'/pages/user/password'),
        );
        
        if($info['is_reservation'] == 1 && $identity != 1){
            $info['btns'][] = array(
                'title'=>'预约记录',
                'icon'=>cdnurl('/assets/images/hexiao-ico.png'),
                'path'=>'/pagesS/store/reservation_list?identity='.$identity
            );
        }
        
        __success("操作成功",$info);
    }
    
    public function getList(){
        $goods_ids = $this->param("goods_ids/s");
        
        $where = ['uniacid'=>UNIACID,'status'=>1];
        if(empty($goods_ids)){
            $where['mid'] = 0;
        }
        
        $store_list = Db::name("bbfx_store")->where($where)->order("sort desc")->select();
        $list = [];
        if(!empty($goods_ids)){
            $goods_ids = explode(",",$goods_ids);
            $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'status'=>1,'type'=>['in',[2,4]],'id'=>['in',$goods_ids]])->field("id,mid,type,delivery_method,is_hexiao,hexiao_store_type")->select();
            
            $mid = 0;
            foreach ($goods as $k => $v){
                if($v['mid'] > 0){
                    $mid = $v['mid'];
                    break;
                }
            }
            
            foreach ($store_list as $key => $val){
                $flag = true;
                foreach ($goods as $k => $v){
                    if(($v['type'] == 2 && ($v['delivery_method'] == 2 || $v['delivery_method'] == 3)) || ($v['type'] == 4 && $v['is_hexiao'] == 1)){
                        
                        if($v['hexiao_store_type'] == 1){
                            $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$v['id'],'store_id'=>$val['id']])->find();
                            
                            if(empty($store_goods)){
                                $flag = false;
                            }
                        
                        }
                    }
                }
                if($flag && $mid = $val['mid']){
                    $list[] = $val;
                }
            }
        }
        else{
            $list = $store_list;
        }
        
        foreach ($list as $key => &$val){
            $val['logo'] = cdnurl($val['logo']);
        }
        unset($val);
        
        __success("操作成功",$list);
    }
}