<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\signin;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Signin extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Signin;
    }
    
    public function index(){
        $config = $this->model->getSet();
        $user = $this->user;
        $today_time = strtotime(date("Y-m-d 00:00:00"));
        $continuity_signin_day = max(0,$user['continuity_signin_day']);
        $yesterday_time = strtotime(date("Y-m-d 00:00:00")." -1 day");
        if($user['signin_time'] < $yesterday_time){
            $continuity_signin_day = 0;
        }
        $user['continuity_signin_day'] = $continuity_signin_day;
        $is_today_singin = 0;
        if($user['signin_time'] > $today_time){
            $is_today_singin = 1;
        }
        if($continuity_signin_day >= $config['day']){
            if($user['signin_time'] < $today_time){
                $continuity_signin_day = 0;
            }
        }
        
        $result = array(
            "continuity_signin_day"=>$continuity_signin_day,
            "is_today_singin"=>$is_today_singin,
            "signin_time"=>$user['signin_time'],
            "signin_remind"=>$user['signin_remind'],
        );
        
        __success("操作成功",$result);
    }
    
    public function signin(){
        $result = $this->model->signin($this->user['id']);
        __result($result);
    }
    
    public function setRemind(){
        $signin_remind = $this->user['signin_remind'];
        if($signin_remind == 1){
            $signin_remind = 0;
        }
        else{
            $signin_remind = 1;
        }
        $res = Db::name("bbfx_user")->where(['id'=>$this->user['id']])->update(['signin_remind'=>$signin_remind]);
        if(!empty($res)){
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function getRecordList(){
        $page = max(1,$this->param("page/d"));
        $limit = 20;
        $where = ['uniacid'=>UNIACID,'user_id'=>$this->user['id']];
        $list = Db::name("bbfx_signin_record")->where($where)->order("createtime desc")->limit(($page-1)*$limit,$limit)->select();
        foreach ($list as $key => &$val){
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        unset($val);
        __success("操作成功",['list'=>$list]);
    }
}