<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\short_video;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Video extends Base
{
    protected $noNeedLogin = ['getList'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\ShortVideo;
    }
    
    public function getList(){
        global $_W;
        $page = $this->param("page/d");
        $type = $this->param("type/d");
        $video_id = $this->param("video_id/d");
        $page = max(1,$page);
        $limit = 30;
        
        // $list = Db::name("bbfx_short_video_list")->where(['uniacid'=>UNIACID,'status'=>1])->order("is_recommend desc,collect_num desc")->field("id,title,video,pageview,collect_num,goods_id,is_recommend,share_num,createtime")->limit(($page-1)*$limit,$limit)->select();
        if($type == 2){
            $list = Db::name("bbfx_short_video_collect")->alias("a")->join("bbfx_short_video_list b","a.pid=b.id","LEFT")->where(['b.uniacid'=>UNIACID,'b.status'=>1,'b.sh_status'=>1,'a.user_id'=>$this->user['id']])->order("a.createtime desc")->field("b.id,b.title,b.video,b.pageview,b.collect_num,b.goods_id,b.is_recommend,b.share_num,b.createtime")->select();
            Db::name("bbfx_short_video_collect")->alias("a")->join("bbfx_short_video_list b","a.pid=b.id","LEFT")->where(['b.uniacid'=>UNIACID,'b.status'=>1,'b.sh_status'=>1,'a.user_id'=>$this->user['id']])->count();
        }
        else{
            $where = ['uniacid'=>UNIACID,'status'=>1,'sh_status'=>1];
            $first = [];
            if($video_id > 0){
                $where['id'] = $video_id;
                $first = Db::name("bbfx_short_video_list")->where($where)->order("createtime desc")->field("id,title,video,pageview,collect_num,goods_id,is_recommend,share_num,createtime")->select();
                $where['id'] = ['<>',$video_id];
            }
            $list = Db::name("bbfx_short_video_list")->where($where)->order("createtime desc")->field("id,title,video,pageview,collect_num,goods_id,is_recommend,share_num,createtime")->select();
            $total = Db::name("bbfx_short_video_list")->where(['uniacid'=>UNIACID,'status'=>1,'sh_status'=>1])->count();
            
            $list = array_merge($first,$list);
        }
        if(empty($list)){
            __error($page==1?"暂无数据~":"没有更多了~");
        }
        
        foreach ($list as $key => &$val){
            $val['video'] = cdnurl($val['video']);
            $val['publisher'] = $_W['base']['short_video']['publisher'];
            $val['publisher_avatar'] = cdnurl($_W['base']['short_video']['publisher_avatar']);
            if($val['goods_id']){
                $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'id'=>$val['goods_id'],'status'=>1])->field("id,title,thumb,price,stock,type,o_price,minbuy,maxbuy,total_maxbuy,unit,sales_volume,is_nodiscount,is_leveldiscount_rule,level_discount")->find();
                if(!empty($goods)){
                    $goods['thumb'] = cdnurl($goods['thumb']);
                    $val['goods'] = $goods;
                }
            }
            $val['comment_num'] = Db::name("bbfx_short_video_comment")->where(['uniacid'=>UNIACID,'pid'=>$val['id']])->count();
            $collec = Db::name("bbfx_short_video_collect")->where(['uniacid'=>UNIACID,'pid'=>$val['id'],'user_id'=>$this->user['id']])->find();
            $val['is_collect'] = 0;
            if(!empty($collec)){
                $val['is_collect'] = 1;
            }
        }
        unset($val);
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
    
    public function getFollowList(){
        global $_W;
        $page = $this->param("page/d");
        $page = max(1,$page);
        $limit = 30;
        
        // $list = Db::name("bbfx_short_video_list")->where(['uniacid'=>UNIACID,'status'=>1])->order("is_recommend desc,dz_num desc")->field("id,title,video,pageview,dz_num,goods_id,is_recommend,share_num,createtime")->limit(($page-1)*$limit,$limit)->select();
        $list = Db::name("bbfx_short_video_list")->where(['uniacid'=>UNIACID,'status'=>1])->order("is_recommend desc,dz_num desc")->field("id,title,video,pageview,dz_num,goods_id,is_recommend,share_num,createtime")->select();
        if(empty($list)){
            __error($page==1?"暂无数据~":"没有更多了~");
        }
        
        foreach ($list as $key => &$val){
            $val['video'] = cdnurl($val['video']);
            $val['publisher'] = $_W['base']['short_video']['publisher'];
            $val['publisher_avatar'] = cdnurl($_W['base']['short_video']['publisher_avatar']);
            if($val['goods_id']){
                $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'id'=>$val['goods_id'],'status'=>1])->field("id,title,thumb,price,stock,type,o_price,minbuy,maxbuy,total_maxbuy,unit,sales_volume,is_nodiscount,is_leveldiscount_rule,level_discount")->find();
                if(!empty($goods)){
                    $goods['thumb'] = cdnurl($goods['thumb']);
                    $val['goods'] = $goods;
                }
            }
            $val['comment_num'] = Db::name("bbfx_short_video_comment")->where(['uniacid'=>UNIACID,'pid'=>$val['id']])->count();
            $collec = Db::name("bbfx_short_video_collect")->where(['uniacid'=>UNIACID,'pid'=>$val['id'],'user_id'=>$this->user['id']])->find();
            $val['is_collect'] = 0;
            if(!empty($collec)){
                $val['is_collect'] = 1;
            }
        }
        unset($val);
        
        $total = Db::name("bbfx_short_video_list")->where(['uniacid'=>UNIACID,'status'=>1])->count();
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
    
    // 收藏
    public function collect(){
        $id = $this->param("id/d");
        $video = Db::name("bbfx_short_video_list")->where(['uniacid'=>UNIACID,'status'=>1,'id'=>$id])->find();
        if(empty($video)){
            __error("短视频不存在或已下架");
        }
        
        $collect = Db::name("bbfx_short_video_collect")->where(['uniacid'=>UNIACID,'pid'=>$video['id'],'user_id'=>$this->user['id']])->find();
        $collect_num = $video['collect_num'];
        if(!empty($collect)){
            Db::name("bbfx_short_video_list")->where(['id'=>$video['id']])->setDec("collect_num",1);
            Db::name("bbfx_short_video_collect")->where(['id'=>$collect['id']])->delete();
            $collect_num--;
            $is_collect = 0;
        }
        else{
            $collect_num++;
            $is_collect = 1;
            Db::name("bbfx_short_video_collect")->insert(['uniacid'=>UNIACID,'pid'=>$video['id'],'user_id'=>$this->user['id'],'createtime'=>time()]);
            Db::name("bbfx_short_video_list")->where(['id'=>$video['id']])->setInc("collect_num",1);
        }
        
        __success("操作成功",['collect_num'=>$collect_num,'is_collect'=>$is_collect]);
    }
    
    // 分享
    public function share(){
        $id = $this->param("id/d");
        $video = Db::name("bbfx_short_video_list")->where(['uniacid'=>UNIACID,'status'=>1,'id'=>$id])->find();
        if(empty($video)){
            __error("短视频不存在或已下架");
        }
        
        $share_num = $video['share_num'];
        $share_num++;
        $data = array(
            'uniacid'=>UNIACID,
            'pid'=>$video['id'],
            'user_id'=>$this->user['id'],
            'createtime'=>time()
        );
        $res = Db::name("bbfx_short_video_share")->insert($data);
        if(empty($res)){
            __error("操作失败");
        }
        Db::name("bbfx_short_video_list")->where(['id'=>$video['id']])->setInc("share_num",1);
        __success("操作成功",['share_num'=>$share_num]);
    }
    
}