<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\scoreshop;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Goods extends Base
{
    protected $noNeedLogin = ['*'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Scoreshop;
    }
    
    public function spec(){
        $params = $this->param();
        
        
        $id = intval($params['id']);
        
        $goods = Db::name("bbfx_scoreshop_goods")->where(['id'=>$id,'status'=>1])->find();
        if(empty($goods)){
            __error("商品不存在");
        }
        $spec_list = [];
        $sku_data = [];
        $price = $goods['price'];
        $score = $goods['score'];
        $stock = $goods['stock'];
        if($goods['is_spec'] == 1){
            $spec_list = Db::name("bbfx_scoreshop_goods_spec")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->order('id asc')->select();
            if(!empty($spec_list)){
                foreach ($spec_list as $key => &$val){
                    $spec_items = Db::name("bbfx_scoreshop_goods_spec_item")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id'],'pid'=>$val['id']])->order('id asc')->select();
                    $val['list'] = $spec_items;
                }
                unset($val);
                
                $sku_data = Db::name("bbfx_scoreshop_goods_spec_sku")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
                $sku_data = array_skey($sku_data,"sku");
                $goods['stock'] = 0;
                $min_price = 0;
                $max_price = 0;
                $min_score = 0;
                $max_score = 0;
                
                foreach ($sku_data as $key => &$val){ 
                    $val['price'] = floatval($val['price']);
                    $val['score'] = floatval($val['score']);
                    $val['stock'] = intval($val['stock']);
                    if($goods['stock'] == 0){
                        $stock = $val['stock'];
                    }
                    $val['thumb'] = cdnurl($val['thumb']);
                    if($min_price == 0 || $min_price > $val['price']){
                        $min_price = $val['price'];
                    }
                    if($max_price < $val['price']){
                        $max_price = $val['price'];
                    }
                    if($min_score == 0 || $min_score > $val['score']){
                        $min_score = $val['score'];
                    }
                    if($max_score < $val['score']){
                        $max_score = $val['score'];
                    }
                }
                unset($val);
                
                if($min_price == $max_price){
                    $price = $min_price;
                }
                else{
                    $price = $min_price."~".$max_price;
                }
                
                if($min_score == $min_score){
                    $score = $min_score;
                }
                else{
                    $score = $min_score."~".$max_score;
                }
            }
            else{
                $goods['is_spec'] = 0;
            }
        }
        $goods['thumb'] = cdnurl($goods['thumb']);
        
        __success("操作成功",['goods'=>$goods,'spec_list'=>$spec_list,'sku_data'=>$sku_data,'price'=>$price,'score'=>$score,'stock'=>$stock]);
    }
    
    public function category(){
        $params = $this->param();
        
        
        $category = Db::name("bbfx_scoreshop_category")->where(['uniacid'=>UNIACID,'status'=>1])->order('sort desc')->select();
        
        $category = array_merge([['id'=>'','title'=>'全部']],$category);
        
        __success("操作成功",['category'=>$category]);
    }
    
    public function getList(){
        $params = $this->param();
        
        $this->model->resetStock(UNIACID);
        
        $pindex = max(1, intval($params["page"]));
        $psize = 20;
        
        $category_id = intval($params['category_id']);
        
        $where = ["uniacid"=>UNIACID,'status'=>1];
        $keyword = trim($params['keyword']);
        if(!empty($keyword)){
            $where['title'] = ['like',"%".$keyword."%"];
        }
        
        if($category_id > 0){
            
            $goods_category = Db::name("bbfx_scoreshop_goods_category")->where(['uniacid'=>UNIACID,'category_id'=>$category_id])->select();
            $ids = array_column($goods_category, 'goods_id');
            if(empty($ids)){
                $ids = [-1];
            }
            $where['id'] = ['in',$ids];
            
        }
        
        // echo "<pre>";
        // print_r($where);die;
        
        $list = Db::name("bbfx_scoreshop_goods")->where($where)->field(['id','title','thumb','price','score','stock','o_price'])->order('sort desc')->limit(($pindex-1)*$psize,$psize)->select();
        if(empty($list)){
            $this->result(-1,$page==1?"没有商品数据":"没有更多了");
        }
        
        foreach ($list as $key => &$val){
            $val['thumb'] = cdnurl($val['thumb']);
            $val['price'] = floatval($val['price']);
            $val['score'] = floatval($val['score']);
            $val['o_price'] = floatval($val['o_price']);
        }
        
        __success("操作成功",$list);
    }
    
    public function detail(){
        $params = $this->param();
        
        
        $goods_id = intval($params['id']);
        
        $goods = Db::name("bbfx_scoreshop_goods")->where(['uniacid'=>UNIACID,'status'=>1,'id'=>$goods_id])->find();
  
      	if(!empty($goods)){
      	    $goods['thumb'] = cdnurl($goods['thumb']);
      	    $goods['share_img'] = cdnurl($goods['share_img']);
      	    
      	    $slides = [];
      	    if($goods['videos']){
      	        $videos_list = iunserializer($goods['videos']);
      	        if(!empty($videos_list)){
      	            foreach ($videos_list as $key => $val){
      	                $slides[] = ['type'=>'video','url'=>cdnurl($val)];
      	            }
      	        }
      	    }
      	    
      	    if($goods['slides']){
      	        $slides_list = iunserializer($goods['slides']);
      	        if(!empty($slides_list)){
      	            foreach ($slides_list as $key => $val){
      	                $slides[] = ['type'=>'image','url'=>cdnurl($val)];
      	            }
      	        }
      	    }
      	    
      	    $goods['slides'] = $slides;
      	    
      	    
      	    if($goods['type'] == 1){
                $stock = Db::name("bbfx_scoreshop_serial_number")->where(["uniacid"=>UNIACID,"goods_id"=>$goods_id,'status'=>0])->count();
      	        $stock = intval($stock);
      	        $goods['stock'] = $stock;
      	    }
      	    $goods['o_price'] = floatval($goods['o_price']);
          	__success("操作成功",$goods);
        }
      	else{
        	__error("未查询到数据或已被删除");
        }
    }
}