<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\sconnection;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Fenxiao;


class Sconnection extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Sconnection;
    }
    
    public function upgradeInfo(){
        $levels = Fenxiao::getLevels();
        $user = $this->user;
        
        $flag = false;
        if($user['is_distributor'] != 1 || $user['distributor_status'] != 1){
            $flag = true;
            $levelname = "普通用户";
        }
        $next_levelname = "";
        
        $level = [];
        foreach ($levels as $key =>$val){
            if($flag){
                $level = $val;
                $next_levelname = $val['title'];
                break;
            }
            if($val['id'] == $user['level']){
                $flag = true;
                $levelname = $val['title'];
            }
        }
        
        if(empty($level)){
            __error("暂无可申请等级");
        }
        
        __success("操作成功",['levelname'=>$levelname,'next_levelname'=>$next_levelname]);
    }
    
    // 上级确定升级 sconnection/sconnection/upgrade
    public function upgrade(){
        $user_id = $this->param("apply_user_id/d");
        $result = $this->model->upgrade($user_id,$this->user['id']);
        __result($result);
    }
    
    // 申请升级 sconnection/sconnection/apply
    public function apply(){
        $result = $this->model->applyUpgrade($this->user['id']);
        __result($result);
    }
    
    // 晋升记录 sconnection/sconnection/getApplyList
    public function getApplyList(){
        
        $list = Db::name("bbfx_sconnection_upgrade_log")->alias("a")->join("bbfx_user b","a.sh_user_id=b.id","LEFT")->where(['a.uniacid'=>UNIACID,'a.user_id'=>$this->user['id']])->field("a.*,b.nickname,b.avatar,b.realname,b.weixin,b.mobile")->order("a.id desc")->select();
        $levels = Fenxiao::getLevels(1);
        foreach ($list as $key => &$val){
            $val['avatar'] = cdnurl($val['avatar']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['levelname'] = $levels[$val['level']]['title'];
        }
        unset($val);
        
        __success("操作成功",['list'=>$list]);
    }
    
    
    // 审核晋升列表 sconnection/sconnection/getShenheList
    public function getShenheList(){
        $page = max(1,$this->param("page/d"));
        $limit = 12;
        
        $list = Db::name("bbfx_sconnection_upgrade_log")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where(['a.uniacid'=>UNIACID,'a.sh_user_id'=>$this->user['id'],'a.status'=>0])->field("a.*,b.nickname,b.avatar,b.realname,b.is_distributor,b.distributor_status,b.weixin,b.mobile")->order("a.id desc")->limit(($page-1)*$limit,$limit)->select();
        $levels = Fenxiao::getLevels(1);
        foreach ($list as $key => &$val){
            $val['avatar'] = cdnurl($val['avatar']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['levelname'] = $levels[$val['level']]['title'];
        }
        unset($val);
        
        __success("操作成功",['list'=>$list]);
    }
}