<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\news;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Article extends Base
{
    protected $noNeedLogin = ['*'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\News;
    }
    
    public function getCategory(){
        $params = $this->param();
        
        $where = array("uniacid"=>UNIACID,'type'=>1);
        
        $list = Db::name("bbfx_news_category")->where($where)->order('sort desc,id desc')->select();
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function getList(){
        global $_W;
        $params = $this->param(['category_id/d']);
        
        $where = array("uniacid"=>UNIACID,'status'=>1);
        
        if(!empty($params['category_id'])){
            $where['category_id'] = $params['category_id'];
        }
        
        $list = Db::name("bbfx_news_article")->where($where)->order('createtime desc')->select();
        
        foreach ($list as $key => &$val){
            $val['thumb'] = cdnurl($val['thumb']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            if(empty($val['author_avatar'])){
                $val['author_avatar'] = $_W['base']['logo'];
            }
            if(empty($val['author'])){
                $val['author'] = $_W['base']['title'];
            }
            $val['author_avatar'] = cdnurl($val['author_avatar']);
        }
        unset($val);
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function detail(){
        global $_W;
        $params = $this->param(['id/d']);
        
        $info = Db::name("bbfx_news_article")->where(['id'=>$params['id'],'status'=>1])->find();
        
        if(empty($info)){
            __error("视频不存在");
        }
        
        $info['thumb'] = cdnurl($info['thumb']);

        if(empty($info['author_avatar'])){
            $info['author_avatar'] = $_W['base']['logo'];
        }
        if(empty($info['author'])){
            $info['author'] = $_W['base']['title'];
        }
        $info['author_avatar'] = cdnurl($info['author_avatar']);
        
        __success("操作成功",['info'=>$info]);
    }
}