<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\merchant;

use app\api\controller\Base;
use think\Db;


class Merchant extends Base
{
    protected $noNeedLogin = ['getList','info'];
    protected $noNeedRight = ['*'];
    
    public function getList(){
        
        $lat = $this->param("lat/f");
        $lng = $this->param("lng/f");
        $keyword = $this->param("keyword/s");
        
        $where = ['uniacid'=>UNIACID,'status'=>1,'is_shenhe'=>1,'yy_status'=>1];
        if(!empty($keyword)){
            $where['name'] = ['like','%'.$keyword.'%'];
        }
        
        $list = Db::name("bbfx_merchant")->where($where)->field("id,name,logo,realname,mobile,province,city,area,address,lat,lng,yy_time,introduction")->order("id desc")->select();
        
        foreach ($list as $key => &$val){
            $val['logo'] = cdnurl($val['logo']);
            
            if(!empty($lng)&&!empty($lat)&&!empty($val['lng'])&&!empty($val['lat'])){
                $distance = getdistance($lng,$lat,$val['lng'],$val['lat']);
                $val['distanceText'] = $distance.'km';
                $val['distance'] = $distance;
            }
            else{
                $val['distance'] = 999999;
                $val['distanceText'] = '';
            }
            
        }
        unset($val);
        
        $distances = array_column($list,'distance');
        array_multisort($distances,SORT_ASC,$list);
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function info(){
        $id = $this->param("id/d");
        $where = ['uniacid'=>UNIACID,'status'=>1,'is_shenhe'=>1,'yy_status'=>1,'id'=>$id];
        $info = Db::name("bbfx_merchant")->where($where)->field("id,name,logo,realname,mobile,province,city,area,address,lat,lng,yy_time,introduction,detail_images,images,createtime")->find();
        if(empty($info)){
            __error('商户不存在');
        }
        
        $info['region'] = [$info['province'],$info['city'],$info['area']];
        $info['logo'] = cdnurl($info['logo']);
        
        $info['images'] = cdnurls(iunserializer($info['images']));
        $info['detail_images'] = cdnurls(iunserializer($info['detail_images']));
        
        if(!empty($lng)&&!empty($lat)&&!empty($info['lng'])&&!empty($info['lat'])){
            $distance = getdistance($lng,$lat,$info['lng'],$info['lat']);
            $info['distanceText'] = $distance.'km';
            $info['distance'] = $distance;
        }
        else{
            $info['distance'] = 999999;
            $info['distanceText'] = '';
        }
        
        
        $category = Db::name("bbfx_category")->where(["uniacid"=>UNIACID,"mid"=>$info['id'],"status"=>1])->order('sort desc,id desc')->select();
        $where = ["a.uniacid"=>UNIACID,'a.mid'=>$info['id'],'a.sh_status'=>1,'a.status'=>1];
        $goods_list = Db::name("bbfx_goods")->alias("a")->join("bbfx_goods_category b","a.id=b.goods_id","LEFT")->where($where)->field("a.id,a.mid,a.title,a.thumb,a.price,a.stock,a.type,a.o_price,a.minbuy,a.maxbuy,a.total_maxbuy,a.unit,a.sales_volume,a.is_nodiscount,a.is_leveldiscount_rule,a.level_discount,b.category_id")->order("a.sort desc,a.id desc")->select();
        
        if(!empty($goods_list)){
            $levels = \app\common\model\bbfxshop\Fenxiao::getLevels(1);
	        foreach ($goods_list as $k => &$v){
            	$v['thumb'] = cdnurl($v['thumb']);
	        }
	        unset($v);
	    }
	    else{
	        $goods_list = [];
	    }
	    
	    foreach ($category as $key => &$val) {
    	    $val['thumb'] = cdnurl($val['thumb']);
    	    
    	    $goods = [];
    	    foreach ($goods_list as $k => $v){
    	       if($v['category_id'] == $val['id']){
    	           $goods[] = $v;
    	       } 
    	    }
    	    $val['goods'] = $goods;
    	}
    	unset($val);
    	
    	$category = array_merge([['id'=>0,'title'=>'全部','goods'=>$goods_list]],$category);
    	
    	$info['category'] = $category;
    	
        __success("操作成功",['info'=>$info]);
    }

    
}