<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\gift;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;

class Gift extends Base
{
    protected $noNeedLogin = ['detail'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Gift;
    }

    public function detail(){
        $order_no = $this->param("order_no/s");

        $order = Db::name("bbfx_order")->where(['order_no'=>$order_no,'uniacid'=>UNIACID,'gift_status'=>0,'status'=>['>=',1],'refund_status'=>['in',[-1,2]]])->find();

        if(empty($order)){
            __error("礼品不存在");
        }

        $goods_list = iunserializer($order["goods_info"]);
        if(empty($goods_list)){
            __error("礼品信息错误");
        }
        $goods_info = $goods_list[0];
        $plugin = iunserializer($goods_info["plugin"]);
        $gift = $plugin['gift'];

        if($order['is_hexiao'] == 1){
            $delivery_method = 2;
        }
        else{
            if($order['order_type'] == 2){
                $delivery_method = 1;
            }
            else{
                $delivery_method = 3;
            }
        }

        $goods = [
            "title"=> $goods_info["title"],
            "price"=> $order["price"],
            "thumb"=> cdnurl($goods_info["thumb"]),
            "sku_name"=> $goods_info["sku_name"],
            "gift_tx_status"=>$gift['tx_status'],
            "gift_cash"=>round($gift['cash'],2),
            "delivery_method"=>$delivery_method
        ];

        $user = Db::name("bbfx_user")->where(['id'=>$order['user_id']])->field("nickname,avatar")->find();
        if(!empty($user)){
            $user['avatar'] = cdnurl($user['avatar']);
        }

        __success('操作成功',['goods'=>$goods,'user'=>$user,'delivery_method'=>$delivery_method]);
    }

    public function receive(){
        $order_no = $this->param("order_no/s");
        $hexiao_realname = $this->param("hexiao_realname/s");
        $hexiao_mobile = $this->param("hexiao_mobile/s");
        $address_id = $this->param("address_id/d");
        $tx_status = $this->param("tx_status/d");
        $result = $this->model->receive($order_no,$this->user['id'],$tx_status,$address_id,$hexiao_realname,$hexiao_mobile);
        __result($result);
    }
}