<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\deposit_release;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Fenxiao;


class Order extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\DepositRelease;
    }
    
    public function submit(){
        $params = $this->param(['money/d']);
        $order_no = date('YmdHis').random(8,true);  
        $user = $this->user;
        
        $config = $this->model->getSet();
        $release_limit = intval($config['release_limit']);
        if($config['status'] != 1){
            __error("功能未开启");
        }
        if($release_limit <= 0){
            __error("未设置释放额度，请联系管理员设置");
        }
        if($params['money'] < $release_limit){
            __error("存入额度必须有大于等于{$release_limit}元");
        }
        
        $order = array(
            "uniacid"=>UNIACID,
            "order_no"=>$order_no,
            "user_id"=>$user['id'],
            "money"=>$params['money'],
            "createtime"=>time()
        );
        
        $order_id = Db::name("bbfx_deposit_release_order")->insertGetId($order);
        if(empty($order_id)){
            __error("创建订单失败");
        }
        
        try {
            Fenxiao::settlement($order_id,2);
        } 
        catch (\Exception $e) {}
        
        __success("创建订单成功",['order_no'=>$order_no]);
    }
}