<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\appoint;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\Fenxiao;
use app\common\model\bbfxshop\User;


class Appoint extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Appoint;
    }
    
    public function appointUserUpgrade(){
        $prams = $this->param(['appoint_user_id/d','level/d']);
        $result = $this->model->appointUserUpgrade($prams['appoint_user_id'],$this->user['id'],$prams['level']);
        if($result['code'] == 1){
            __success("指定升级成功");
        }
        else{
            __error($result['message']);
        }
    }
    
    public function getUserList(){
        global $_W;
        $params = $this->param();
        $keyword = $params['keyword'];
        $base = $_W['base'];
        $texts = $base['fenxiao']['texts'];
        $levels = Fenxiao::getLevels(1);
        
        $list = [];
        $user = $this->user;
        
        $appoint = $base['fenxiao']['appoint']['level'.$user['level']];
        
        if($user['level'] != 0 && $base['fenxiao']['is_appoint'] == 1 && !empty($appoint)){
            $alldown = Fenxiao::getAllDown($user['id']);
            $team_list = $alldown['users'];
            if(!empty($team_list)){
                $all = [];
                if(!empty($keyword)){
                    foreach ($team_list as $key => $val){
                        if($val['id'] == intval($keyword) || strstr($val['nickname'], $keyword)){
                            $all[] = $val;
                        }
                    }
                }
                else{
                    $all = $team_list;
                }
                
                
                // foreach ($appoint as &$val){
                //     $val['ok'] = Db::name("bbfx_fenxiao_upgrade_record")->where(['uniacid'=>UNIACID,'type'=>3,'sup_uid'=>$user['id'],'sup_level'=>$user['level'],'level'=>$val['id']])->count();
                //     $val['ok'] = intval($val['ok']);
                // }
                // unset($val);
                
                $user_sort = intval($levels[$user['level']]['sort']);
                
                foreach($all as $key => $val){
                    $level_sort = intval($levels[$val['level']]['sort']);
                    if($val['is_distributor'] != 1 || $val['distributor_status'] != 1){
                        $level_sort = -1;
                    }
                    if($user_sort > $level_sort){
                        $ulevels = [];
                        foreach ($levels as $k => $v){
                            $sort = intval($v['sort']);
                            if($sort > $level_sort && $sort < $user_sort){
                                $ulevels[] = ['id'=>$v['id'],'title'=>$v['title']];
                            }
                        }
                        
                        if(!empty($ulevels)){
                            $val['ulevels'] = $ulevels;
                            $list[] = $val; 
                        }
                    }
                }
                
                $createtimes = array_column($list,'createtime');
                array_multisort($createtimes,SORT_DESC,$list);
                
                // $become_distributor_times = array_column($list,'become_distributor_time');
                // array_multisort($become_distributor_times,SORT_DESC,$list);
            }
            
            
            
            foreach ($list as &$val){
                $val['avatar'] = cdnurl($val['avatar']);
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
                $val['become_distributor_time'] = date("Y-m-d H:i:s",$val['become_distributor_time']);
                $val['levelname'] = "普通用户";
                if($val['is_distributor'] == 1 && $val['distributor_status'] == 1){
                    $val['levelname'] = $levels[$val['level']]['title'];
                }
            }
            unset($val);
        }
        
        
        __success("success",array("list"=>$list));
    }
}