<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\store;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Store extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Store;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $where = ['uniacid'=>UNIACID,'mid'=>0];
        
        $list = Db::name("bbfx_store")->where($where)->order("sort desc")->limit(($pindex - 1) * $psize,$psize)->select();
        foreach ($list as $key => &$val) {
            $val['logo'] = cdnurl($val['logo']);
            $val['store_reward_total'] = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'status'=>1,'user_id'=>$val['id'],'type'=>25])->sum('money');
        }
        unset($val);
        
        $total = Db::name("bbfx_store")->where($where)->count();
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function all(){
        
        $list = Db::name("bbfx_store")->where(['uniacid'=>UNIACID,'status'=>1,'mid'=>0])->order("sort desc")->field("id,name,logo")->select();
        
        foreach ($list as $key => &$val) {
            $val['logo'] = cdnurl($val['logo']);
        }
        unset($val);
        
        __success("操作成功",$list);
    }
    
    public function detail(){
        $id = $this->param("id/d");
        $info = $this->model->getInfo($id);
        if(!empty($info)){
            __success("操作成功",$info);
        }
        else{
            __error("门店不存在");
        }
    }
    
    public function post(){
        $params = $this->paramPost(['id/d','user_id/d','name/s','logo/s','realname/s','mobile/s','region/a','address/s','lng/f','lat/f','status/s','commission/a','sort/d','yy_time/s','is_reservation/d','content/s','images/a','score/d','introduction/s']);
        
        if($params['user_id'] <= 0){
            __error("请选择店长");
        }
        if(empty($params['name'])){
            __error("请输入门店名称");
        }
        if(empty($params['mobile'])){
            __error("请输入联系电话");
        }
        if(empty($params['region'])){
            __error("请选择门店区域");
        }
        if(empty($params['lng']) || empty($params['lng'])){
            __error("请在地图中选择门店地址");
        }
        if(empty($params['yy_time'])){
            __error("请输入营业时间");
        }
        
        $images = $params['images'];
        foreach ($images as $key => &$val){
            $val = replaceSiteroot($val);
        }
        unset($val);
        
        $data = array(
            "uniacid"=>UNIACID,
            "type"=>0,
            "mid"=>0,
            "user_id"=>$params['user_id'],
            "name"=>$params['name'],
            "logo"=>replaceSiteroot($params['logo']),
            "realname"=>$params['realname'],
            "mobile"=>$params['mobile'],
            "yy_time"=>$params['yy_time'],
            "province"=>$params['region'][0],
            "city"=>$params['region'][1],
            "area"=>$params['region'][2],
            "address"=>$params['address'],
            "lng"=>$params['lng'],
            "lat"=>$params['lat'],
            "score"=>$params['score'],
            "status"=>$params['status'],
            "is_reservation"=>$params['is_reservation'],
            "content"=>htmlspecialchars_decode($this->param('content/h')),
            "introduction"=>$params['introduction'],
            "images"=>iserializer($images),
            "commission"=>iserializer($params['commission']),
            "sort"=>$params['sort'],
        );
        $item = $this->model->getInfo($params['id']);
        if(!empty($item)){
            $res = Db::name("bbfx_store")->where("id",$item['id'])->update($data);
            $data['id'] = $item['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_store")->insertGetId($data);
            $data['id'] = $id;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_store");
            __success("编辑成功");
        }
        else{
            __error("编辑失败");
        }
        
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_store")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'name');
        
        
      	$res = Db::name("bbfx_store")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除门店","门店：".implode(",",$titles)."，门店ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}