<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\store;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Dealer extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Store;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $where = ['uniacid'=>UNIACID,'is_dealer'=>1];
        
        $list = Db::name("bbfx_user")->where($where)->order("become_dealer_time desc")->field("id,nickname,avatar,level,is_distributor,distributor_status,is_dealer,dealer_province,dealer_city,become_dealer_time,dealer_reward")->limit(($pindex - 1) * $psize,$psize)->select();
        foreach ($list as $key => &$val) {
            $val['avatar'] = cdnurl($val['avatar']);
            $val['become_dealer_time'] = date("Y-m-d H:i:s",$val['become_dealer_time']);
            $val['dealer_reward_total'] = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'status'=>1,'user_id'=>$val['id'],'type'=>26])->sum('money');
        }
        unset($val);
        
        $total = Db::name("bbfx_user")->where($where)->count();
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function post(){
        $params = $this->paramPost(['id/d','dealer_province/s','dealer_city/s','dealer_reward/d']);
        
        if($params['id'] <= 0){
            __error("请选择用户");
        }
        if(empty($params['dealer_city'])){
            __error("请选择经销商管理城市名称");
        }
        
        $user = Db::name("bbfx_user")->where(['id'=>$params['id']])->find();
        if(empty($user)){
            __error("用户不存在");
        }
        
        $otheruser = Db::name("bbfx_user")->where([ "is_dealer"=>1,"dealer_province"=>$params['dealer_province'],"dealer_city"=>$params['dealer_city']])->find();
        if(!empty($otheruser) && $otheruser['id'] != $user['id']){
            __error("已存在该城市经销商");
        }
        
        $data = array(
            "is_dealer"=>1,
            "dealer_province"=>$params['dealer_province'],
            "dealer_city"=>$params['dealer_city'],
            "dealer_reward"=>$params['dealer_reward']
        );
        
        if($user['is_dealer'] != 1){
            $data['become_dealer_time'] = time();
        }
        
        $res = Db::name("bbfx_user")->where("id",$user['id'])->update($data);
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_user");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
        
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_user")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'nickname');
        
        
      	$res = Db::name("bbfx_user")->where('id','in',$ids)->update(['is_dealer'=>0]);
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除经销商","经销商：".implode(",",$titles)."，经销商ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}