<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\smaterial;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Smaterial extends Base
{
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $where = ['uniacid'=>UNIACID];
        
        $list = Db::name("bbfx_smaterial_item")->where($where)->order("sort desc")->limit(($pindex - 1) * $psize,$psize)->select();
        foreach ($list as $key => &$val) {
            $val['image'] = cdnurls(iunserializer($val['image']));
            $val['video'] = cdnurl($val['video']);
            $val['createtime'] = date('Y-m-d H:i:s',$val['createtime']);
            $val['category_name'] = Db::name("bbfx_smaterial_category")->where(['uniacid'=>UNIACID,'id'=>$val['category_id']])->value('title');
        }
        unset($val);
        
        $total = Db::name("bbfx_smaterial_item")->where($where)->count();
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
     
    public function detail(){
        $id = $this->param("id/d");
        $info = Db::name("bbfx_smaterial_item")->where(['id'=>$id])->find();
        if(!empty($info)){
            $info['image'] = cdnurls(iunserializer($info['image']));
            $info['video'] = cdnurl($info['video']);
            __success("操作成功",['info'=>$info]);
        }
        else{
            __error("素材不存在");
        }
    }
    
    public function post(){
        $params = $this->paramPost(['id/d','category_id/d','title/s','content/s','type/d','image/a','video/s','status/d','sort/d']);
        
        if($params['category_id'] <= 0){
            __error("请选择分类");
        }
        if(empty($params['title'])){
            __error("请输入标题");
        }
        if($params['type'] != 1 && empty($params['image'])){
            __error("请上传图片");
        }
        if($params['type'] == 1 && empty($params['video'])){
            __error("请上传视频");
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "category_id"=>$params['category_id'],
            "title"=>$params['title'],
            "content"=>$params['content'],
            "type"=>$params['type'],
            "image"=>iserializer(replaceSiteroots($params['image'])),
            "video"=>replaceSiteroot($params['video']),
            "status"=>$params['status'],
            "sort"=>$params['sort']
        );

        $item = Db::name("bbfx_smaterial_item")->where(['id'=>$params['id']])->find();
        if(!empty($item)){
            $res = Db::name("bbfx_smaterial_item")->where("id",$item['id'])->update($data);
            $data['id'] = $item['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_smaterial_item")->insertGetId($data);
            $data['id'] = $id;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_smaterial_item");
            __success("编辑成功");
        }
        else{
            __error("编辑失败");
        }
        
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_smaterial_item")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'name');
        
        
      	$res = Db::name("bbfx_smaterial_item")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除分享素材","分享素材：".implode(",",$titles)."，分享素材ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}