<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\shippingfee;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Template extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Shippingfee;
    }
    
    public function getList(){
        $list = Db::name("bbfx_shippingfee_template")->where(['uniacid'=>UNIACID])->order("id desc")->select();
        foreach ($list as $key => &$val){
            $val['rule'] = iunserializer($val['rule']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        unset($val);
        __success("操作成功",['list'=>$list]);
    }
    
    public function detail(){
        $id = $this->param("id/d");
        $info = Db::name("bbfx_shippingfee_template")->where(['id'=>$id])->find();
        if(empty($info)){
            __error("数据不存在"); 
        }
        $info['rule'] = iunserializer($info['rule']);
        __success("操作成功",['info'=>$info]);
    }
    public function post(){
        $params = $this->param(['name/s','rule/a','type/d']);
        $id = $this->param("id/d");
        if(empty($params['name'])){
            __error("请输入运费模板名称");
        }
        if(empty($params['rule'])){
            __error("请设置运费模板规则");
        }
        
        $rule = $params['rule'];
        
        foreach ($rule as $key => &$val){
            $val['first'] = max(1,round($val['first'],2));
            $val['first_fee'] = max(0,round($val['first_fee'],2));
            $val['continued'] = max(0,round($val['continued'],2));
            $val['continued_fee'] = max(0,round($val['continued_fee'],2));
            $val['free_shipping_order_amount'] = max(0,round($val['free_shipping_order_amount'],2));
        }
        unset($val);
        
        $data = [
            "uniacid"=>UNIACID,
            "type"=>$params['type'],
            "name"=>$params['name'],
            "rule"=>iserializer($rule)
        ];
        
        $info = Db::name("bbfx_shippingfee_template")->where(['id'=>$id])->find();
        if(!empty($info)){
            $res = Db::name("bbfx_shippingfee_template")->where(['id'=>$info['id']])->update($data);
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_shippingfee_template")->insert($data);
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_shippingfee_template");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function delete(){
        $ids = $this->param("id/s");
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
      	$res = Db::name("bbfx_shippingfee_template")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_shippingfee_template");
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}