<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\sale;

use app\admin\controller\bbfxshop\Base;
use think\Db;

use app\common\model\bbfxshop\Fenxiao;
use app\common\model\bbfxshop\User;


class Coupon extends Base
{
    public function _initialize(){
        parent::_initialize();
    }
    
    public function getList(){
        $params = $this->param();
        
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_coupon")->where($where)->order('createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
        $total = Db::name("bbfx_coupon")->where($where)->count();
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function sendCoupon(){
        $params = $this->param();
        
        $coupon = Db::name("bbfx_coupon")->where("id",$params['coupon_id'])->where("status",1)->find();
        
        if(empty($coupon)){
            __error("请选择优惠券");
        }
        $total = intval($params['total']);
        if($total <= 0){
            __error("请输入发放数量");
        }
        
        if($params['type'] == 1){
            $user_list = Db::name("bbfx_user")->where(["status"=>1,'id'=>['in',explode(",",$params['user_ids'])]])->field("id")->select();
        }
        else{
            $user_list = Db::name("bbfx_user")->where(["status"=>1,'uniacid'=>UNIACID])->field("id")->select();
        }
        
        if(empty($user_list)){
            __error("未查询到用户");
        }
        
        $endtime = 0;
        if($coupon['validitytime'] > 0){
            $endtime = time() + $coupon['validitytime'] * 86400;
        }
        $user_ids = [];
        foreach ($user_list as $key => $val){
            $user_ids[] = $val['id'];
        }
        
        \app\common\model\bbfxshop\Coupon::receive($coupon,$user_ids);
        
        \app\admin\model\AdminLog::record("","",['user_id'=>implode(",",$user_ids),'coupon_id'=>$coupon['id']],"bbfx_user_coupon");
        
        __success("发送成功");
    }
    
    public function all(){
        $list = Db::name("bbfx_coupon")->where(["uniacid"=>UNIACID,'status'=>1])->order('createtime desc')->select();
        
        if(empty($list)){
            __error("没有优惠券");
        }
        
        foreach ($list as $key => &$val){
            $val['money'] = floatval($val['money']);
            $val['mj_money'] = floatval($val['mj_money']);
        }
        unset($val);
        
        __success("操作成功",$list);
    }
    
    public function status(){
        $params = $this->param();
        
        $res = Db::name("bbfx_coupon")->where("id",$params['id'])->update(['status'=>$params['status']]);
        if($res){
            \app\admin\model\AdminLog::record("","",["id"=>$params['id'],'status'=>$params['status']],"bbfx_coupon");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function detail(){
        $params = $this->param();
        
        $coupon = Db::name("bbfx_coupon")->where("id",$params['id'])->find();
        
        if(empty($coupon)){
            __error("优惠券不存在");
        }
        
        __success('操作成功',$coupon);
    }
    
    public function post(){
        $params = $this->param();
        $data = array(
            "uniacid"=>UNIACID,
            "type"=>intval($params['type']),
            "name"=>$params['name'],
            "money"=>floatval($params['money']),
            "max_money"=>intval($params['max_money']),
            "mj_money"=>floatval($params['mj_money']),
            "status"=>intval($params['status']),
            "total"=>intval($params['total']),
            "condition_type"=>intval($params['condition_type']),
            "validitytime"=>intval($params['validitytime']),
            "goods_ids"=>$params['goods_ids']
        );
        
        if($params['id']){
            $res = Db::name("bbfx_coupon")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_coupon")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_coupon");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
      	$res = Db::name("bbfx_coupon")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_coupon");
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}