<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\problem;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Problem extends Base
{

    protected $model = null;

    public function getList(){
        $params = $this->param();
        
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_problem")->where($where)->order('sort desc')->limit(($pindex - 1) * $psize,$psize)->select();
        $total = Db::name("bbfx_problem")->where($where)->count();
        foreach($list as $key => &$val){
            $val['createtime'] = date('Y-m-d H:i:s',$val['createtime']);
        }
        unset($val);
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function status(){
        $params = $this->param(['id/d','status/d']);
        
        $status = $params['status'];
        
        $res = Db::name("bbfx_problem")->where("id",$params['id'])->update(['status'=>$status]);
        if($res){
            \app\admin\model\AdminLog::record("","",["id"=>$params['id'],'status'=>$params['status']],"bbfx_problem");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function detail(){
        $params = $this->param();
        
        $info = Db::name("bbfx_problem")->where("id",$params['id'])->find();
        
        
        if(empty($info)){
            __error("数据不存在");
        }
        __success('操作成功',$info);
    }
    
    public function post(){
        $params = $this->param();
        $id = intval($params['id']);
        
        $item = Db::name("bbfx_problem")->where(['id'=>$id])->find();
        
        $data = array(
        	"uniacid"=>UNIACID,
          	"title"=>$params['title'],
          	"content"=>htmlspecialchars_decode($this->param('content/h')),
          	"status"=>$params['status'],
          	"sort"=>$params['sort'],
        );
        
        if(empty($params['title'])){
            __error("请输入问题标题");
        }
        if(empty($params['content'])){
            __error("请输入问题内容");
        }
        
      	if(!empty($item)){
            $res = Db::name("bbfx_problem")->where(['id'=>$id])->update($data);
        }
      	else{
      	    $data['createtime'] = time();
            $res = Db::name("bbfx_problem")->insert($data);
            $id = $res;
        }
      	
      	if($res){
      	    $data['id'] = $id;
      	    \app\admin\model\AdminLog::record("","",$data,"bbfx_problem");
        	__success("编辑成功");
        }
      	else{
        	__error("操作失败");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
      	$res = Db::name("bbfx_problem")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_problem");
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}