<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\paihangbang;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Paihangbang;
    }
    
    public function set(){
        $params = $this->param();
        
        $config = Db::name("bbfx_paihangbang")->where(["uniacid"=>UNIACID])->find();
        $reward_rule = $params['reward_rule'];
        
        if($params['status'] == 1){
            $rate = 0;
            foreach ($reward_rule as $key => $val){
                $rate += round($val['reward'],2);
            }
            
            $rate = round($rate,2);
            
            if($rate > 100){
                __error("所有分红比例之和不得超出100%");
            }
            
            if(intval($params['reward_ranking']) <= 0){
                __error("请输入奖励排名");
            }
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "status"=>$params['status'],
            "reward_rate"=>max(0,intval($params['reward_rate'])),
            "ranking_method"=>intval($params['ranking_method']),
            "reward_source"=>intval($params['reward_source']),
            "reward_buy_goods"=>$params['reward_buy_goods'],
            "reward_buy_count"=>max(1,intval($params['reward_buy_count'])),
            "reward_ranking"=>max(0,intval($params['reward_ranking'])),
            "bg_image"=>replaceSiteroot($params['bg_image']),
            "banner_image"=>replaceSiteroot($params['banner_image']),
            "reward_rule"=>iserializer($reward_rule)
        );
        if($data['reward_ranking'] > 1000){
            $data['reward_ranking'] = 1000;
        }
        
        if($config['reward_buy_goods'] != $data['reward_buy_goods'] || $config['status'] != $data['status'] || $config['reward_source'] != $data['reward_source']){
            $data['reward_buy_ok'] = 0;
            $data['reward_buy_money'] = 0;
        }
        // $reward_rule[] =  ['ranking'=>[],'reward'=>'']
        
    	if(!empty($config)){
          	$res = Db::name("bbfx_paihangbang")->where(["id"=>$config['id']])->update($data);;
        }
      	else{
        	$res = Db::name("bbfx_paihangbang")->insert($data);
        }
        
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_paihangbang");
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }
    
}