<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\order;

use app\admin\controller\bbfxshop\Base;
use think\Db;

use app\common\model\bbfxshop\Fenxiao;
use app\common\model\bbfxshop\User;

use Exception;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Xls;
use PhpOffice\PhpSpreadsheet\Reader\Csv;


class Order extends Base 
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Order;
    }

    public function import(){
        $file = $this->param('file/s');
        if (!$file) {
            __error("请上传文件");
        }
        $filePath = ROOT_PATH . 'public' . replaceSiteroot($file);
        
        if (!is_file($filePath)) {
            __error("未找到文件");
        }
        //实例化reader
        $ext = pathinfo($filePath, PATHINFO_EXTENSION);
        if (!in_array($ext, ['csv', 'xls', 'xlsx'])) {
            __error(__('Unknown data format'));
        }
        if ($ext === 'csv') {
            $file = fopen($filePath, 'r');
            $filePath = tempnam(sys_get_temp_dir(), 'import_csv');
            $fp = fopen($filePath, "w");
            $n = 0;
            while ($line = fgets($file)) {
                $line = rtrim($line, "\n\r\0");
                $encoding = mb_detect_encoding($line, ['utf-8', 'gbk', 'latin1', 'big5']);
                if ($encoding != 'utf-8') {
                    $line = mb_convert_encoding($line, 'utf-8', $encoding);
                }
                if ($n == 0 || preg_match('/^".*"$/', $line)) {
                    fwrite($fp, $line . "\n");
                } else {
                    fwrite($fp, '"' . str_replace(['"', ','], ['""', '","'], $line) . "\"\n");
                }
                $n++;
            }
            fclose($file) || fclose($fp);

            $reader = new Csv();
        } elseif ($ext === 'xls') {
            $reader = new Xls();
        } else {
            $reader = new Xlsx();
        }

        //导入文件首行类型,默认是注释,如果需要使用字段名称请使用name
        $importHeadType = isset($this->importHeadType) ? $this->importHeadType : 'comment';

        $table = $this->model->getQuery()->getTable();
        $database = \think\Config::get('database.database');
        $fieldArr = [];
        $list = db()->query("SELECT COLUMN_NAME,COLUMN_COMMENT FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = ? AND TABLE_SCHEMA = ?", [$table, $database]);
        foreach ($list as $k => $v) {
            if ($importHeadType == 'comment') {
                $fieldArr[$v['COLUMN_COMMENT']] = $v['COLUMN_NAME'];
            } else {
                $fieldArr[$v['COLUMN_NAME']] = $v['COLUMN_NAME'];
            }
        }

        //加载文件
        $insert = [];
        try {
            if (!$PHPExcel = $reader->load($filePath)) {
                __error(__('Unknown data format'));
            }
            $currentSheet = $PHPExcel->getSheet(0);  //读取文件中的第一个工作表
            $allColumn = $currentSheet->getHighestDataColumn(); //取得最大的列号
            $allRow = $currentSheet->getHighestRow(); //取得一共有多少行
            $maxColumnNumber = Coordinate::columnIndexFromString($allColumn);
            $fields = [];
            for ($currentRow = 1; $currentRow <= 1; $currentRow++) {
                for ($currentColumn = 1; $currentColumn <= $maxColumnNumber; $currentColumn++) {
                    $val = $currentSheet->getCellByColumnAndRow($currentColumn, $currentRow)->getValue();
                    $fields[] = $val;
                }
            }
            
            for ($currentRow = 2; $currentRow <= $allRow; $currentRow++) {
                $values = [];
                for ($currentColumn = 1; $currentColumn <= $maxColumnNumber; $currentColumn++) {
                    $val = $currentSheet->getCellByColumnAndRow($currentColumn, $currentRow)->getValue();
                    $values[] = is_null($val) ? '' : $val;
                }
                
                // print_r($values);die;
                if(!empty($values)){
                    
                    // 日期转换 \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($values[5])->format('Y-m-d')
                    
                    $insert[] = array(
                        "order_no"=>$values[0],
                        "express_name"=>$values[1],
                        "express_no"=>$values[2]
                    );
                }
                else{
                    $insert[] = [];
                }
            }
        } catch (Exception $exception) {
            __error($exception->getMessage());
        }
        if (!$insert) {
            __error(__('No rows were updated'));
        }
        // unlink($filePath);
        // echo "<pre>";
        // print_r($insert);die;
        
        $log = "";
        
        $success = 0;
        foreach ($insert as $key => $val){
            if(empty($val['order_no'])){
                $log .= "第".($key+2)."行，订单编号缺失<br>";
                continue;
            }
            if(empty($val['express_name'])){
                $log .= "第".($key+2)."行，快递公司名称缺失<br>";
                continue;
            }
            if(empty($val['express_no'])){
                $log .= "第".($key+2)."行，快递单号缺失<br>";
                continue;
            }
            
            $order = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'order_no'=>$val['order_no']])->find();
            if(empty($order)){
                $log .= "第".($key+2)."行，订单不存在<br>";
                continue;
            }
            if($order['is_pay'] != 1){
                $log .= "第".($key+2)."行，订单未支付<br>";
                continue;
            }
            if($order['status'] != 1){
                $log .= "第".($key+2)."行，订单已发货<br>";
                continue;
            }
            if($order['order_type'] != 2 || $order['is_hexiao'] == 1){
                $log .= "第".($key+2)."行，不是发货订单<br>";
                continue;
            }
            
            $express = Db::name("bbfx_express")->where(['name'=>['like','%'.$val['express_name'].'%']])->find();
            if(empty($express)){
                $log .= "第".($key+2)."行，快递公司不存在<br>";
                continue;
            }
            
            $express = [
                [
                    "express_id"=>$express['id'],
                    "express_name"=>$express['name'],
                    "express_no"=>$val['express_no'],
                    "goods_id"=>""
                ]
            ];
            
            
            $data = [
                'express'=>iserializer($express),
                'status'=>2,
                'deliverytime'=>time(),
                'deliver_type'=>1
            ];
            
            
            try {
                Db::startTrans();
                
                Db::name("bbfx_order")->where(['id'=>$order['id']])->update($data);

                $this->model->sendGoods($order['id']);
                
                Db::commit();
                $success++;
            } catch (Exception $e) {
                Db::rollback();
                $log .= "第".($key+2)."行，导入失败：".$e->getMessage()."<br>";
            }
        }
        
        $data = [
            "uniacid"=>UNIACID,
            "type"=>0,
            "content"=>$log,
            "admin_id"=>$this->auth->id,
            "createtime"=>time()
        ];
        
        Db::name("bbfx_import_log")->insert($data);
        // 删除表格
        unlink($filePath);
        
        if($success == 0){
            __error("导入失败",['log_content'=>$log]);
        }
        if(empty($log)){
            $log = '已成功导入：'.$success.'条';
        }

        __success("导入成功",['log_content'=>$log]);
    }
    
    
    public function newOrder(){
        $new_order_id = Db::name("bbfx_base")->where(['uniacid'=>UNIACID])->value("new_order_id");
        
        $order_id = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'is_pay'=>1])->order("pay_time desc")->value("id");
        $order_id = intval($order_id);
        if($new_order_id === $order_id || $order_id <= 0){
            __error("没有新订单！");
        }
        
        Db::name("bbfx_base")->where(['uniacid'=>UNIACID])->update(['new_order_id'=>$order_id]);
        
        __success("您有新订单！");
    }

    public function extractData(){
        $params = $this->param();
        
        $order_id = intval($params['order_id']);
        $order = Db::name("bbfx_order")->where(['id'=>$order_id])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        return ['order_id'=>$order_id,'order'=>$order,'params'=>$params];
    }
    
    public function print(){
        $extractData = $this->extractData();
        extract($extractData);
        
        $result = \app\common\model\bbfxshop\Printer::orderPrint($order['id']);
        
        __result($result);
    }
    
    public function refund(){
        $extractData = $this->extractData();
        extract($extractData);
        if($order['is_pay'] != 1){
            __error("订单未支付");
        }
        
        if($order['refund_status'] == 1){
            __error("订单已退款");
        }
        
        if($order['order_source'] == 4 || $order['order_source'] == 5 || $order['order_source'] == 6){
            __error("该类型的订单不可退款");
        }
        if($order['gift_status'] == 1){
            __error("该订单礼品已被领取不可退款");
        }
        
        $type = intval($params['type']);
         
        if($type == 1){
            $refund = Db::name("bbfx_order_refund")->where(['order_id'=>$order_id,'uniacid'=>UNIACID])->find();
            if(empty($refund)){
                $order_no = date('YmdHis').random(8,true);
                $data = array(
                    "uniacid"=>UNIACID,
                    "user_id"=>$order['user_id'],
                    "order_no"=>$order_no,
                    "money"=>$order['price'],
                    "order_id"=>$order_id,
                    "content"=>"平台退款",
                    "createtime"=>time()
                );

                if($order['is_hexiao'] == 1){
                    $data['mobile'] = $order['hexiao_mobile'];
                }
                else{
                    if(empty($order['delivery_mobile'])){
                        $data['mobile'] = $order['delivery_mobile'];
                    }
                }
                $refund_id = Db::name("bbfx_order_refund")->insertGetId($data);
        
                if(empty($refund_id)){
                    __error("退款失败");
                }
                Db::name("bbfx_order")->where(['id'=>$order_id])->update(['refund_status'=>0]);
            }
            else{
                if($refund['status'] == 1){
                    Db::name("bbfx_order")->where(['id'=>$order_id])->update(['refund_status'=>1]);
                    __error("退款失败");
                }
            }
            $status = 1;
        }
        else{
            $status = intval($params['status']);
        }
        
        $result = $this->model->refund($order_id,$status,$type);
        if(!empty($result) && $result['code'] === 1){
            __success("退款成功");
        }
        else{
            __error($result['message']);
        }
    }
    
    public function updateDeliver(){
        $extractData = $this->extractData();
        extract($extractData);
        if($order['is_pay'] != 1){
            __error("订单未支付");
        }
        if($order['refund_status'] != -1){
            __error("订单已申请售后");
        }
        if($order['status'] > 1){
            __error("订单已发货");
        }
        
        $delivery_username = $params['delivery_username'];
        $delivery_mobile = $params['delivery_mobile'];
        $delivery_address = $params['delivery_address'];
        $delivery_dz = $params['delivery_dz'];
        
        $data = array(
            "delivery_username"=>$delivery_username,
            "delivery_mobile"=>$delivery_mobile,
            "delivery_province"=>$delivery_dz[0],
            "delivery_city"=>$delivery_dz[1],
            "delivery_area"=>$delivery_dz[2],
            "delivery_street"=>$delivery_dz[3],
            "delivery_address"=>$delivery_address,
        );
        
        if(empty($data['delivery_username'])){
            __error("请填写收货人");
        }
        if(empty($data['delivery_mobile'])){
            __error("请填写收货人电话");
        }
        if(empty($data['delivery_province']) || empty($data['delivery_city']) || empty($data['delivery_area'])){
            __error("请选择地区");
        }
        if(empty($data['delivery_address'])){
            __error("请填写详细地址");
        }
        
        $res = Db::name("bbfx_order")->where(['id'=>$order['id']])->update($data);
        
        if($res){
            __success("修改成功");
        }
        else{
            __error("修改失败");
        }
    }
    
    public function updateRemarks(){
        $extractData = $this->extractData();
        extract($extractData);
        
        $content = $params['content'];
        
        $res = Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['remarks'=>$content]);
        
        if($res){
            __success("修改成功");
        }
        else{
            __error("修改失败");
        }
    }
    
    public function takeDelivery(){
        $extractData = $this->extractData();
        extract($extractData);
        $result = $this->model->takeDelivery($order['id']);
        if(!empty($result) && $result['code'] == 1){
            __success("确认收货成功");
        }
        else{
            __error($result['message']);
        }
    }
    
    public function send(){
        $extractData = $this->extractData();
        extract($extractData);
        
        $result = $this->model->checkFahuo($order);
        if($result['code'] != 1){
           __result($result); 
        }
        
        if($order['order_type'] == 2){
            
            $expressInfo = $params['expressInfo'];
            $deliver_type = intval($params['deliver_type']);
            if(empty($expressInfo)){
                __error("请填写快递信息");
            }
            
            foreach($expressInfo as $key => $val){
                if(empty($val['express_id'])){
                    __error("请选择快递公司");
                }
                if(empty($val['express_no'])){
                    __error("请填写快递单号");
                }
                if($deliver_type != 1 && empty($val['goods_id'])){
                    __error("请选择商品");
                }
                
            }
            
            if($order['status'] == 2){
                $res = true;
            }
            else if($order['status'] == 1){
                $res = Db::name("bbfx_order")->where(['id'=>$order['id'],'status'=>1])->update(['status'=>2]);
            }

            if($res){
                
                $udata = [];
                if($order['status'] == 1){
                    $udata = ['deliverytime'=>time()];
                }
                $udata['express'] = iserializer($expressInfo);
                $udata['deliver_type'] = $deliver_type;
                
                Db::name("bbfx_order")->where(['id'=>$order['id']])->update($udata);
                
                // \app\common\model\bbfxshop\Message::sendShippingnoticeMsg($order['id']);
                
                \app\common\model\bbfxshop\Sms::sendOrderDeliveryNotice($order['id']);
                
                if($order['status'] == 1){
                    $this->model->sendGoods($order['id']);
                    $udata['status'] = 2;
                    $udata['id'] = $order['id'];
                }
                \app\admin\model\AdminLog::record("","",$udata,'bbfx_order');
                __success("发货成功");
            }
            else{
                __error("发货失败");
            }
        }
        else if($order['order_type'] == 1 || $order['order_type'] == 4){
            
            $res = $this->model->takeDelivery($order['id']);
            if(!empty($res) && $res['code'] == 1){
                Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['deliverytime'=>time()]);
                __success("发货成功");
            }
            else{
                 __error($res['message']);
            }
        }
        else{
            __error("商品类型错误");
        }
    }
    
    public function queryExpressDelivery(){
        $extractData = $this->extractData();
        extract($extractData);
        $express_no = $this->param("express_no/s");
        
        if($order['order_type'] == 2 && $order['delivery_method'] != 1){
            __error("不是快递订单");
        }
        if($order['status'] <= 1){
            __error("订单未发货");
        }
        $express = iunserializer($order['express']);
        $new_express_no = $express_no;
        if(!strstr($new_express_no, ':')){
            foreach ($express as $key => $val){
                if($val['express_no'] == $express_no && $val['express_name'] == '中通快递'){
                    $new_express_no = $express_no.":".mb_substr($order['delivery_mobile'], -4);
                }
            }
            unset($val);
        }
        
        $result = \app\common\model\bbfxshop\Delivery::queryExpressDelivery($new_express_no);
        if($result['code'] == 1){
            
            $res = $result['data'];
            foreach ($express as $key => &$val){
                if($val['express_no'] == $express_no){
                    $val['express_data'] = $res;
                }
            }
            unset($val);
            
            Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['express'=>iserializer($express)]);
        }
        
        __result($result);
    }
    
    public function detail(){
        global $_W;
        $base = $_W['base'];
        $texts = $base['fenxiao']['texts'];
        $extractData = $this->extractData();
        extract($extractData);
        
        $order_goods = Db::name("bbfx_order_goods")->where(['order_id'=>$order['id'],'uniacid'=>UNIACID])->select();
        $goods_list = [];
        $goods_all = [];
        $serial_numbers = [];
        foreach ($order_goods as $key => &$val){
            $goods_info = iunserializer($val['goods_info']);
            $goods_info['thumb'] = cdnurl($goods_info['thumb']);
            
            if($order['status'] == 3 && $order['order_type'] == 1){
                $serial_number = Db::name("bbfx_serial_number")->where(['pid'=>$val['id'],'uniacid'=>UNIACID])->field(['id','val','pid'])->select();
                foreach ($serial_number as $k => &$v){
                    $v['goods'] = $goods_info;
                }
                unset($v);
                $serial_numbers = array_merge($serial_numbers,$serial_number);
            }
            
            $val['goods_info'] = $goods_info;
            $goods_info['total'] = $val['total'];
            $goods_list[$val['goods_id']] = $goods_info;
            $goods_all[] = $goods_info;
        }
        unset($val);
        $order['paytypeText'] = $this->model->getOrderPaytype($order['paytype']);
        
        $order['user'] = User::getUser($order['user_id'],false);
        
	    $order['typeText'] = $this->model->getOrderType($order['order_type']);
        $order['statusText'] = $this->model->getOrderStatus($order,1);
        $order['refund_statusText'] = $this->model->getOrderRefundStatus($order['refund_status']);
        $order['deliverytime'] = date("Y-m-d H:i:s",$order['deliverytime']);
        $order['createtime'] = date("Y-m-d H:i:s",$order['createtime']);
        $order['pay_time'] = date("Y-m-d H:i:s",$order['pay_time']);
        $order['completetime'] = date("Y-m-d H:i:s",$order['completetime']);
        $order['serial_numbers'] = $serial_numbers;
        
        
        $order_commission = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>['>',0],'money_type'=>['in',[1,3]],'order_id'=>$order_id])->sum("money");
        $order['order_commission'] = round($order_commission,2);
        $order['goods_profit'] = round($order['price'] - $order_commission,2);
        
        $order_profit = $order['price'] - $order['cost_price'] - $order_commission;
	    if($order['delivery_method'] == 1 && $order['order_type'] == 2){
	        $order_profit -= $order['express_fee'];
	    }
	    $order['order_profit'] = max(0,round($order_profit,2));
        
        if($order['refund_status'] != -1){
            
            $refund = Db::name("bbfx_order_refund")->where("order_id",$order['id'])->find();
            if(!empty($refund)){
                $refund['images'] = iunserializer($refund['images']);
                foreach ($refund['images'] as $key => &$val){
                    $val = cdnurl($val);
                }
                unset($val);
                $refund['createtime'] = date("Y-m-d H:i:s",$refund['createtime']);
                $order['refund'] = $refund;
            }
        }
        
        if(($order['order_type'] == 2 || $order['order_type'] == 4) && $order['is_hexiao'] == 1){
            $hexiao_record = Db::name("bbfx_order_hexiao_record")->where(['uniacid'=>UNIACID,'order_id'=>$order['id']])->select();
            foreach ($hexiao_record as $key => &$val){
                $val['info'] = iunserializer($val['info']);
                if($val['user_id'] > 0){
                    $val['info']['user']['avatar'] = cdnurl($val['info']['user']['avatar']);
                }
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            }
            unset($val);
            $order['hexiao_record'] = $hexiao_record;
            $hexiao_store = iunserializer($order['hexiao_store']);
            $hexiao_store['logo'] = cdnurl($hexiao_store['logo']);
            $order['hexiao_store'] = [$hexiao_store];
        }
        
        $order['extend'] = iunserializer($order['extend']);
        
        $result = ['order'=>$order,'order_goods'=>$order_goods];
        
        if($order['order_type'] == 2){
            $express_list = Db::name("bbfx_express")->where(['status'=>1])->field(['id','name','coding'])->order('sort desc')->select();
            $result['express_list'] = $express_list;
        }
        if($order['order_type'] == 2 && $order['status'] > 1){
            $express = iunserializer($order['express']);
            foreach ($express as $key => &$val){
                $val['deliverytime'] = $order['deliverytime'];
                if($order['deliver_type'] == 1){
                    $val['goods'] = $goods_all;
                }
                else if($order['deliver_type'] == 2 || $order['deliver_type'] == 3){
                    $val['goods'] = [$goods_list[$val['goods_id']]];
                }
            }
            unset($val);
            $result['express'] = $express;
        }
        
        $fenxiao_order_list = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>['>',0],'order_id'=>$order_id])->order('type asc')->select();
        if(empty($fenxiao_order_list)){
            $fenxiao_order_list = [];
        }
        
        $texts = $_W['base']['fenxiao']['texts'];
        $levels = Fenxiao::getLevels(1);
        foreach ($fenxiao_order_list as $key => &$val){
            $user = Db::name("bbfx_user")->where(['id'=>$val['user_id']])->field(['id','avatar','nickname','level','sup_uid'])->find();
            $sup_user = Db::name("bbfx_user")->where(['id'=>$user['sup_uid']])->field(['id','avatar','nickname','level','sup_uid'])->find();
            if(!empty($user)){
                $user['level_name'] = $levels[$val['level']]['title'];
                // $user['level_name'] = $levels[$user['level']]['title'];
                $user['avatar'] = cdnurl($user['avatar']);
                $val['user'] = $user;
            }
            if(!empty($sup_user)){
                $sup_user['level_name'] = $levels[$sup_user['level']]['title'];
                $sup_user['avatar'] = cdnurl($sup_user['avatar']);
                $val['sup_user'] = $sup_user;
            }
            
	        $val['typeText']= Fenxiao::getTypeText($val['type'],$val['money_type']);
	        if($val['money_type'] == 2){
                $val['moneyText'] = "+".floatval($val['money']).$base['texts']['score_unit'];
            }
            else{
                $val['moneyText'] = "+".floatval($val['money']).$texts['yuan'];
            }
        }
        unset($val);
        
        $result['fenxiao_order_list'] = $fenxiao_order_list;
        
        __success("操作成功",$result);
    }
    
    public function hexiao(){
        $id = $this->param('order_id/d');
        
        $result = $this->model->hexiao($id);
        
        __result($result);
    }
    
    public function close(){
        $id = $this->param('order_id/d');
        
        $result = $this->model->closeOrder($id);
        if($result['code'] != 1){
            __error($result['message']);
        }
        
        __success($result['message']);
    }
    
    public function createElectronicWaybill(){
        $id = $this->param('order_id/d');
        $result = \app\common\model\bbfxshop\ElectronicWaybill::createWaybill($id);
        __result($result);
    }
    
    public function list(){
        $params = $this->param();
        
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("a.uniacid"=>UNIACID);
        
        $keyword = trim($params['keyword']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        $status = intval($params['status']);
        $paytype = intval($params['paytype']);
        $export = intval($params['export']);
        $refund_status = intval($params['refund_status']);
        $type = intval($params['type']);
        $mid = intval($params['mid']);
        $min = round($params['min_price'],2);
        $max = round($params['max_price'],2);
        $sup_uid = intval($params['sup_uid']);
        if($status != -1){
            if($status == 4){
                 $where['a.status'] = ['>=',1];
                if($refund_status != -1){
                    $where['a.refund_status'] = $refund_status;
                }
                else{
                    $where['a.refund_status'] = ['neq',-1];
                }
            }
            else{
                $where['a.status'] = $status;
            }
        }
        
        if($keyword){
            if($type == 1){
                $where['a.order_no'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['a.delivery_username'] = ['like',"%".$keyword."%"];
            }
            else if($type == 4){
                $where['a.user_id'] = intval($keyword);
            }
            else if($type == 5){
                $where['a.goods_info'] = ['like','%'.$keyword.'%'];
            }
            else if($type == 6){
                $uids = User::getLevel1UserIds(intval($keyword));
                $where['a.user_id'] = ['in',$uids];
            }
            else if($type == 7){
                $where['a.express'] = ['like','%'.$keyword.'%'];
            }
            else if($type == 8){
                $where['a.delivery_mobile'] = $keyword;
            }
        }
        if($paytype > 0){
            $where['a.paytype'] = $paytype;
        }
        
        if($mid > 0){
            $where['a.mid'] = $mid;
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        } 
        
        if($endTime){
            $endTime = strtotime($endTime." 23:59:59");
            $whereTime['a.createtime'] = ['<=',$endTime];
        }

        if($min > 0){
            $where['a.price'] = ['>',$min];
        }
        if($max > 0){
            $whereTime['a.price'] = ['<',$max];
        }
        
        if($export == 1){
            $list = Db::name("bbfx_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->select();
        }
        else{
            $list = Db::name("bbfx_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
        }
    	
    	$export_list = [];
    	foreach($list as $key => &$val){
    	    
    	    $val['merchant_name'] = Db::name("bbfx_merchant")->where(['id'=>$val['mid']])->value("name");
    	    if(empty($val['merchant_name'])){
    	        $val['merchant_name'] = "";
    	    }
    	    
    	    $val['avatar'] = cdnurl($val['avatar']);
            $order_goods = Db::name("bbfx_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$val['id']])->select();
    	    
    	    foreach ($order_goods as $k => &$v){
    	        $goods_info = iunserializer($v['goods_info']);
    	        $goods_info['thumb'] = cdnurl($goods_info['thumb']);
    	        $v['goods'] = $goods_info;
    	    }
    	    unset($v);
    	    $val['order_goods'] = $order_goods;
    	    $val['paytypeText'] = "";
    	    if($val['is_pay'] == 1){
    	        $val['pay_time'] = date("Y-m-d H:i:s",$val['pay_time']);
    	        $val['paytypeText'] = $this->model->getOrderPaytype($val['paytype']);
    	        
    	    }
    	    else{
    	        $val['pay_time'] = "";
    	    }
    	    
    	    if($val['is_electronic_waybill_print'] == 1){
    	        $extend = iunserializer($val['extend']);
                $expressPrintTemplate = str_replace("kg "," ",$extend['express']['PrintTemplate']);
    	        $val['expressPrintTemplate'] = $expressPrintTemplate;
    	    }
    	     
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    
    	    $val['typeText'] = $this->model->getOrderType($val['order_type']);
    	    $val['refund_statusText'] = $this->model->getOrderRefundStatus($val['refund_status']);
    	    $val['statusText'] = $this->model->getOrderStatus($val);
    	    
    	    $sup_user = Db::name('bbfx_user')->where(['id'=>$val['one_share']])->field("id,nickname,avatar")->find();
    	    if(!empty($sup_user)){
    	        $sup_user['avatar'] = cdnurl($sup_user['avatar']);
    	        $val['sup_user'] = $sup_user;
    	    }
    	    
    	    $order_commission = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>['>',0],'money_type'=>['in',[1,3]],'order_id'=>$val['id']])->sum("money");
    	    $order_profit = $val['price'] - $val['cost_price'] - $order_commission;
    	    if($val['delivery_method'] == 1 && $val['order_type'] == 2){
    	        $order_profit -= $val['express_fee'];
    	    }
    	    $val['order_profit'] = max(0,round($order_profit,2));

            if($val['order_type'] == 2 && $val['is_hexiao'] == 0 && $val['status'] > 1){
                $val['express'] = iunserializer($val['express']);
            }
    	    
    	    if($export == 1){
    	        
    	        $delivery = $val['delivery_username']." ".$val['delivery_mobile'].','.$val['delivery_province'].$val['delivery_city'].$val['delivery_area'].$val['delivery_street'].$val['delivery_address'];
    	        
    	        $sup_user = "总店";
    	        if(!empty($val['sup_user'])){
    	            $sup_user = "(ID:".$val['sup_user']['id'].")".$val['sup_user']['nickname'];
    	        }
    	        
    	        foreach ($order_goods as $k => $v){
    	            
    	            $profit_amount = max(0,round($v['price'] - $v['cost_price'],2));
    	            
        	        $goods = $v['goods'];
        	        $export_list[] = array(
        	            $val['id'],
        	            $val['order_no'],
        	            $val['merchant_name'],
        	            "(ID:{$val['user_id']})".$val['nickname'],
        	            $sup_user,
        	            $val['price'],
        	            $val['profit_amount'],
        	            $goods['title'],
        	            $v['price'],
        	            $v['total'],
        	            $delivery,
        	            $val['typeText'],
        	            $val['statusText'],
        	            $val['refund_statusText'],
        	            $val['createtime']
        	        );
        	    }
        	    
    	    }
    	}
    	unset($val);
    	
    	if($export == 1){
    	    $headArr = ["订单ID","订单编号","所属商户","用户信息","推荐人","订单金额","利润金额","商品名称","商品金额","商品数量","收货信息","订单类型","订单状态","退款状态","下单时间"];
    	    $result = \app\common\model\PhpOffice::excelExport("order-".date("Y-m-d"),$headArr,$export_list,['mergek'=>0,'merges'=>[0,1,2,3,4,5,6,10,11,12,13,14]]);
    	}
      
        $total = Db::name("bbfx_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->count();
    	
    	__success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_order")->where('id','in',$ids)->delete();
      	if($res){
      	    Db::name("bbfx_order_goods")->where('order_id','in',$ids)->delete();
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}