<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\news;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Video extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\News;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_news_video")->where($where)->order('id desc')->limit(($pindex - 1) * $psize,$psize)->select();
        $total = Db::name("bbfx_news_video")->where($where)->count();
        
        $cates = Db::name("bbfx_news_category")->where(['uniacid'=>UNIACID,'type'=>2])->select();
        $cates = array_skey($cates,"id");
        foreach ($list as $key => &$val){
            if(!empty($cates[$val['category_id']])){
                $val['category_name'] = $cates[$val['category_id']]['title'];
            }
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['thumb'] = cdnurl($val['thumb']);
            $val['content'] = cdnurl($val['content']);
        }
        unset($val);
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function status(){
        $params = $this->param();
        
        $res = Db::name("bbfx_news_video")->where("id",$params['id'])->update(['status'=>$params['status']]);
        if($res){
            \app\admin\model\AdminLog::record("","",["id"=>$params['id'],'status'=>$params['status']],"bbfx_news_video");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function detail(){
        $params = $this->param();
        
        $info = Db::name("bbfx_news_video")->where("id",$params['id'])->find();
        
        if(empty($info)){
            __error("文章不存在");
        }
        $info['thumb'] = cdnurl($info['thumb']);
        $info['content'] = cdnurl($info['content']);
        
        __success('操作成功',$info);
    }
    
    public function post(){
        $params = $this->param();
        $data = array(
            "uniacid"=>UNIACID,
            "title"=>$params['title'],
            "thumb"=>trim($params['thumb']),
            "content"=>replaceSiteroot($params['content']),
            "link"=>$params['link'],
            "type"=>intval($params['type']),
            "category_id"=>intval($params['category_id']),
            "status"=>intval($params['status']),
            "browse"=>intval($params['browse'])
        );
        $data['thumb'] = replaceSiteroot($data['thumb']);
        if(!empty($params['id'])){
            $res = Db::name("bbfx_news_video")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_news_video")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_news_video");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
      	$res = Db::name("bbfx_news_video")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_news_video");
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}