<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\diypage;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\Weixin;
use app\common\model\QRcode;

class Index extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Diypage;
    }
    
    public function getTabDiyList(){
        $id = $this->param("id/d");
        $diypage_list = Db::name("bbfx_diypage")->where(['uniacid'=>UNIACID,'type'=>1,'id'=>['<>',$id]])->select();
        $list = [];
        foreach ($diypage_list as $key => &$val){
            if(!strstr(val['data'], 'searchMenu')){
                $val['data'] = $this->model->getPage($val);
                $list[] = $val;
            }
        }
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function getDiypage(){
        $params = $this->param();
        $id = intval($params['id']);
        $item = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID,"id"=>$id])->find();
        if(empty($item)){
            __error("数据错误");
        }
        else{
            $data = iunserializer($item['data']);
            
            $data = $this->model->tomediaPage($data);
            __success("操作成功",$data);
        }
    }
    
    public function updateDiypage(){
        $params = $this->param();
        $id = intval($params['id']);
        $item = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID,"id"=>$id])->find();
        if(empty($item)){
            __error("数据错误!");
        }
        $data = $params['data'];
        if(empty($data)){
            __error("页面配置数据错误!");
        }
        
        $data = $this->model->replacePage($data);
        
        $res = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID,"id"=>$id])->update(["data"=>iserializer($data)]);
        
        if($res){
            $this->clearCache();
            \app\admin\model\AdminLog::record("","",['id'=>$id],"bbfx_diypage");
            __success("保存成功！");
        }
        else{
            __error("保存失败!");
        }
    }
    
    public function all(){
        $list = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID])->field("id,title")->select();
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function list(){
        $params = $this->param();
        
        
        $list = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID])->field("id,title,default_status,type,access_permissions_levels")->select();
        
        foreach($list as $key => &$val){
            $val['renovationUrl'] = request()->domain()."/admin/diypage/#/pages/index/index?i=".UNIACID."&id={$val['id']}";
            $val['access_permissions_levels'] = iunserializer($val['access_permissions_levels']);
            
            if($val['type'] == 2 && $val['default_status'] == 1){
                $page = "pages/user/index";
            }
            else if($val['type'] == 1 && $val['default_status'] == 1){
                $page = "pages/index/index";
            }
            else{
                $page = "pages/diypage/index?id=".$val['id'];
            }
            $val['wxapp_url'] = $page;
            $val['h5_qrcode'] = "";
            $val['wxapp_qrcode'] = "";
            $result = Weixin::getUnlimitedQRCode($page,"diy_".$val['id'].".png",1);
            if($result['code'] == 1){
                $val['wxapp_qrcode'] = cdnurl($result['data']['url'],true);
                
            }
            
            if(strstr($page, '?')){
                $page .= "&i=".UNIACID;
            }
            else{
                $page .= "?i=".UNIACID;
            }
            $h5_url = request()->domain()."/mobile/#/".$page;
            $val['h5_url'] = $h5_url;
            $result = QRcode::create($h5_url,"diy_h5_".$val['id']);
            if($result['code'] == 1){
                $val['h5_qrcode'] = cdnurl($result['data']['url'],true);
            }
            
        }
        unset($val);
        
    	$total = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID])->count();
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function setDefault(){
        $params = $this->param();
        
        $id = intval($params['id']);
        
        $page = Db::name("bbfx_diypage")->where(['id'=>$id])->find();
        if(empty($page)){
            __error("页面不存在");
        }
        
        $res = Db::name("bbfx_diypage")->where(['id'=>$id])->update(['default_status'=>1]);
        if($res){
            Db::name("bbfx_diypage")->where(['type'=>$page['type'],'uniacid'=>UNIACID,'id'=>['neq',$id]])->update(['default_status'=>0]);
            $this->clearCache();
            \app\admin\model\AdminLog::record("","",['id'=>$id],"bbfx_diypage");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function post(){
        global $_W;
        $params = $this->param();
        
        $id = intval($params['id']);
        
        $item = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID,"id"=>$id])->find();
        $data = array(
    	    "uniacid"=>UNIACID,
          	"title"=>$params['title'],
          	"default_status"=>intval($params['default_status']),
          	"type"=>intval($params['type']),
          	"access_permissions_levels"=>iserializer($params['access_permissions_levels'])
        );
      	
      	if(!empty($item)){
          	$res = Db::name("bbfx_diypage")->where(['id'=>$item['id']])->update($data);
        }
      	else{
      	    $type = "index";
      	    if($data['type'] == 2){
      	        $type = "member";
      	    }
      	    
      	    $diypage_data = array(
      	        "title"=>$params['title'],
    			"bgType"=>1,
    			"type"=>$type,
    			"bgColor"=>"#f5f5f5",
    			"bgUrl"=>"",
    			"navbar"=>array(
    			    "title"=>$params['title'],
    			    "show"=>1,
    			    "back"=>1,
    			    "bg"=>"",
    			    "color"=>$_W['base']['font_color'],
    			    "bgColor"=>$_W['base']['theme_color'],
    			    "backIcon"=>request()->domain()."/assets/images/left.png",
    			    "iconWidth"=>10,
    			    "fontSize"=>16
    			),
    			"tabBar"=>array(
    				"color"=>"#000000",
    				"selectedColor"=>"#ed5c2f",
    				"bgColor"=>"#fff",
    				"show"=>1,
    				"syncHome"=>1, 
    				"list"=>array(
    				    array(
    				        "link"=> array(
    							"url"=>"/pages/index/index",
    							"name"=>"首页"
    						),
    						"iconPath"=> request()->domain()."/assets/images/index-ico.png",
    						"selectedIconPath"=> request()->domain()."/assets/images/index-on-ico.png",
    						"text"=> "首页",
    				    ),
    					array(
    					    "link"=> array(
    							"url"=>"/pages/category/category",
    							"name"=>"分类"
    						),
    						"iconPath"=> request()->domain()."/assets/images/cate-ico.png",
    						"selectedIconPath"=> request()->domain()."/assets/images/cate-on-ico.png",
    						"text"=> "分类"
    					),
    					array(
    					    "link"=> array(
    							"url"=>"/pages/user/index",
    							"name"=>"我的"
    						),
    						"iconPath"=> request()->domain()."/assets/images/my-ico.png",
    						"selectedIconPath"=> request()->domain()."/assets/images/my-on-ico.png",
    						"text"=> "我的"    
    					)
    				),
    			
    			),
    			"list"=>array()
      	    );
      	    
      	    $data['data'] = iserializer($diypage_data);
      	    
            $res = Db::name("bbfx_diypage")->insertGetId($data);
            $id = $res;
        }
      	
      	if($res){
      	    
      	    if($data['default_status'] == 1){
                Db::name("bbfx_diypage")->where(["id"=>['neq',$id],'uniacid'=>UNIACID,'type'=>$data['type']])->update(['default_status'=>0]);
          	}
          	$data['id'] = $id;
          	
          	$this->clearCache();
          	
          	\app\admin\model\AdminLog::record("","",$data,"bbfx_diypage");
      	    
        	__success("编辑成功");
        }
      	else{
        	__error("操作失败");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_diypage")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'title');
        
      	$res = Db::name("bbfx_diypage")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    $this->clearCache();
      	    
      	    \app\admin\model\AdminLog::record("删除页面","页面：".implode(",",$titles)."，页面ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}