<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\agent;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use think\Cache;

class Config extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Agent;
    }
     
    public function getSet(){
        $config = Db::name("bbfx_agent")->where(["uniacid"=>UNIACID])->find();
        $config['become_purchase_money'] = iunserializer($config['become_purchase_money']);
        $config['become_goods'] = iunserializer($config['become_goods']);
        $config['agent_reward'] = iunserializer($config['agent_reward']);
        $config['achievement_subsidy'] = iunserializer($config['achievement_subsidy']);
        if(empty($config['become_purchase_money'])){
            // $config['become_purchase_money'] = [ '1'=> '', '2'=> '', '3'=> '', '4'=> '' , '8'=> '' ];
            $config['become_purchase_money'] = [ '1'=> '', '2'=> '', '3'=> '' , '8'=> '' ];
        }
        if(empty($config['become_goods'])){
            // $config['become_goods'] = [ '1'=> '', '2'=> '', '3'=> '', '4'=> '' , '8'=> '' ];
            $config['become_goods'] = [ '1'=> '', '2'=> '', '3'=> '' , '8'=> '' ];
        }
        if(is_null($config['become_purchase_money']['8'])) $config['become_purchase_money']['8'] = '';
        if(is_null($config['become_goods']['8'])) $config['become_goods']['8'] = '';
        
        if(empty($config['agent_reward'])){
            $config['agent_reward'] = [
                '1'=>['money'=>'','money1'=>''],
                '2'=>['money'=>'','money1'=>''],
                '3'=>['money'=>'','money1'=>''],
                // '4'=>['money'=>'','money1'=>''],
                '8'=>['money'=>'','money1'=>'']
            ];
        }
        if(is_null($config['agent_reward']['8'])) $config['agent_reward']['8'] = ['money'=>'','money1'=>''];
        
        $levels = \app\common\model\bbfxshop\Fenxiao::getLevels();
        foreach ($levels as $key => $val){
            $config['agent_reward']['1']['level'.$val['id']] = round($config['agent_reward']['1']['level'.$val['id']],2);
            $config['agent_reward']['2']['level'.$val['id']] = round($config['agent_reward']['2']['level'.$val['id']],2);
            $config['agent_reward']['3']['level'.$val['id']] = round($config['agent_reward']['3']['level'.$val['id']],2);
            // $config['agent_reward']['4']['level'.$val['id']] = round($config['agent_reward']['4']['level'.$val['id']],2);
            $config['agent_reward']['8']['level'.$val['id']] = round($config['agent_reward']['8']['level'.$val['id']],2);

            $config['agent_reward']['1']['level_money'.$val['id']] = round($config['agent_reward']['1']['level_money'.$val['id']],2);
            $config['agent_reward']['2']['level_money'.$val['id']] = round($config['agent_reward']['2']['level_money'.$val['id']],2);
            $config['agent_reward']['3']['level_money'.$val['id']] = round($config['agent_reward']['3']['level_money'.$val['id']],2);
            // $config['agent_reward']['4']['level_money'.$val['id']] = round($config['agent_reward']['4']['level_money'.$val['id']],2);
            $config['agent_reward']['8']['level_money'.$val['id']] = round($config['agent_reward']['8']['level_money'.$val['id']],2);
        }
        
        if(empty($config['achievement_subsidy'])){
            $config['achievement_subsidy'] = [
                'status'=>0,
                'achievement1'=>'',
                'achievement2'=>'',
                'achievement3'=>'',
                // 'achievement4'=>'',
                'achievement8'=>'',
                'reward1'=>'',
                'reward2'=>'',
                'reward3'=>'',
                // 'reward4'=>'',
                'reward8'=>'',
            ];
        }

        Cache::rm("bbfx_set_".UNIACID);
        \app\common\model\bbfxshop\Common::getConfig(true);
        
        __success("操作成功",$config);
    }
    
    public function set(){
        $params = $this->param();
        $config = Db::name("bbfx_agent")->where(["uniacid"=>UNIACID])->find();
        
        $data = array(
            "uniacid"=>UNIACID,
            "status"=>intval($params['status']),
            "level"=>intval($params['level']),
            "address_type"=>intval($params['address_type']),
            "become_agent"=>intval($params['become_agent']),
            "become_purchase_money"=>iserializer($params['become_purchase_money']),
            "become_goods"=>iserializer($params['become_goods']),
            "commission_received_type"=>intval($params['commission_received_type']),
            "become_order_type"=>intval($params['become_order_type']),
            "settlement_type"=>intval($params['settlement_type']),
            "agent_rule"=>intval($params['agent_rule']),
            "is_show_yx"=>intval($params['is_show_yx']),
            "is_jicha"=>intval($params['is_jicha']),
            "is_deputy_city_agent"=>intval($params['is_deputy_city_agent']),
            "xy_title"=>$params['xy_title'],
            "xy_content"=>htmlspecialchars_decode($this->param('xy_content/h')),
            "agent_reward"=>iserializer($params['agent_reward']),
            "achievement_subsidy"=>iserializer($params['achievement_subsidy']),
            "commission_calculation_mode"=>intval($params['commission_calculation_mode']),
        );
        
        if(!empty($config)){
            $res = Db::name("bbfx_agent")->where(["id"=>$config['id']])->update($data);
        }
      	else{
            $res = Db::name("bbfx_agent")->insert($data);
        }
        
        if($res){
            
            \app\admin\model\AdminLog::record("","",$data,"bbfx_agent");

            Cache::rm("bbfx_set_".UNIACID);
            \app\common\model\bbfxshop\Common::getConfig(true);
            
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }
    
}