<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Printer extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Printer;
    }

    public function getList(){
        
        $list = Db::name("bbfx_printer")->where(["uniacid"=>UNIACID])->field("id,name,type,total")->select();
        
        foreach ($list as $key => &$val){
            $val['typeText'] = $this->model->getTypeText($val['type']);
        }
        unset($val);
        
        __success("操作成功",['list'=>$list,'total'=>count($list)]);
    }
    
    public function detail(){
        $params = $this->param(['id/d']);
        
        $printer = Db::name("bbfx_printer")->where("id",$params['id'])->find();
        if(!empty($printer)){
            $content = iunserializer($printer['content']);
        }
        else{
            $content = [];
        }
        
        if(empty($content['type1'])){
            $content['type1'] = ['client_type'=>0,'client_authcode'=>'','machine_code'=>'','terminal_secret'=>'','client_id'=>'','client_secret'=>''];
        }
        else{
            if(empty($content['type1']['client_type'])){
                $content['type1']['client_type'] = intval($content['type1']['client_type']);
            }
            if(empty($content['type1']['client_authcode'])){
                $content['type1']['client_authcode'] = intval($content['type1']['client_authcode']);
            }
        }
        if(empty($content['type2'])){
            $content['type2'] = ['dyjnumber'=>'','feukey'=>'','user'=>''];
        }
        
        
        $result = ['content'=>$content];
        
        if(!empty($printer)){
            $printer['content'] = $content;
            $result['info'] = $printer;
        }
        
        __success("操作成功",$result);
    }
    
    public function post(){
        $params = $this->param(['id/d','name/s','type/d','content/a','total/d']);
        
        if(empty($params['name'])){
            __error("请输入打印机名称");
        }
        if(empty($params['type'])){
            __error("请选择打印机");
        }
        if(empty($params['content'])){
            __error("请配置打印机");
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "name"=>$params['name'],
            "type"=>$params['type'],
            "content"=>iserializer($params['content']),
            "total"=>max(1,$params['total'])
        );
        
        if(empty($params['id'])){
            $res = Db::name("bbfx_printer")->insertGetId($data);
            $data['id'] = $res;
        }
        else{
            $res = Db::name("bbfx_printer")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_printer");
            __success("编辑成功");
        }
        else{
            __error("编辑失败");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_printer")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_printer");
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}