<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use think\Cache;

class Config extends Base
{
    public function _initialize(){
        parent::_initialize();
    }
    
    public function getConfig(){
        Cache::rm("bbfx_set_".UNIACID);
        $base = \app\common\model\bbfxshop\Common::getConfig(true);
        
        $uniacid = UNIACID;
        $h5_url = request()->domain()."/mobile/#/pages/index/index?i=".$uniacid;
        $result = \app\common\model\QRcode::create($h5_url,"h5_url_".$uniacid);
        $h5_url_qrcode = "";
        if($result['code'] == 1){
            $h5_url_qrcode = cdnurl($result['data']['url']);
        }
        $base['h5_url'] = $h5_url;
        $base['h5_url_qrcode'] = $h5_url_qrcode;
        $base['admin_id'] = $this->auth->id;
        
        $wxapp_url_qrcode = "";
        $result = \app\common\model\bbfxshop\Weixin::getUnlimitedQRCode("pages/index/index","wxapp_url_".$uniacid.".png");
        if($result['code'] == 1){
            $wxapp_url_qrcode = cdnurl($result['data']['url']);
        }
        $base['wxapp_url'] = "pages/index/index";
        $base['wxapp_url_qrcode'] = $wxapp_url_qrcode;
        $base['order_express_tpl'] = request()->domain()."/tpl/订单物流单号导入模板.xlsx";
        
        
        __success("操作成功",$base);
    }
    
    protected function upload_cert($fileinput) {
        global $_W;
        $path = ROOT_PATH . "cert";
        mkdir($path);
        $f = $fileinput . '_' . UNIACID . '.pem';
        $outfilename = $path . "/" . $f;
        $filename = $_FILES[$fileinput]['name'];
        $tmp_name = $_FILES[$fileinput]['tmp_name'];
        if (!empty($filename) && !empty($tmp_name)) {
            $ext = strtolower(substr($filename, strrpos($filename, '.')));
            if ($ext != '.pem') {
                $errinput = "";
                if ($fileinput == 'cert') {
                    $errinput = "CERT文件格式错误";
                } 
                else if ($fileinput == 'cert_key') {
                    $errinput = 'KEY文件格式错误';
                }
                __error(0, $errinput . ',请重新上传!');
            }
            return file_get_contents($tmp_name);
        }
        return "";
    }
    
    public function hidePluginSubmit(){
        $params = $this->param();
        
        
      	$base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
      	$data = array(
        	"hide_close_plugin"=>intval($params['hide_close_plugin'])
        );
        
    	if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
      	__success("编辑成功");
    }
    
    public function paySubmit(){
        $params = $this->param();
        
        
      	$base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
        $recharge = $params['recharge'];
        $recharge['zfb_skqrcode'] = replaceSiteroot($recharge['zfb_skqrcode']);
        $recharge['wx_skqrcode'] = replaceSiteroot($recharge['wx_skqrcode']);
        $recharge['xn_skqrcode'] = replaceSiteroot($recharge['xn_skqrcode']);
        $recharge['szr_skqrcode'] = replaceSiteroot($recharge['szr_skqrcode']);
        $recharge['ysf_skqrcode'] = replaceSiteroot($recharge['ysf_skqrcode']);
        $recharge['cb_pay_skqrcode'] = replaceSiteroot($recharge['cb_pay_skqrcode']);
        $recharge['jd_pay_skqrcode'] = replaceSiteroot($recharge['jd_pay_skqrcode']);
        $recharge['eb_pay_skqrcode'] = replaceSiteroot($recharge['eb_pay_skqrcode']);
        $recharge['ddb_pay_skqrcode'] = replaceSiteroot($recharge['ddb_pay_skqrcode']);
        $recharge['min_pay_skqrcode'] = replaceSiteroot($recharge['min_pay_skqrcode']);

      	$data = array(
        	"is_wxpay"=>intval($params['is_wxpay']),
        	"is_alipay"=>intval($params['is_alipay']),
        	"is_balancepay"=>intval($params['is_balancepay']),
        	"is_recharge"=>intval($params['is_recharge']),
        	"is_pay_password"=>intval($params['is_pay_password']),
        	"recharge_ratio"=>intval($params['recharge_ratio']),
        	"is_merch_transfer_new"=>intval($params['is_merch_transfer_new']),
        	"merch_transfer_scene"=>trim($params['merch_transfer_scene']),
        	"recharge"=>iserializer($recharge),
        );
        
        
        if ($_FILES['cert']['name']) {
            $data['cert'] = $this->upload_cert('cert');
        }
        if ($_FILES['cert_key']['name']) {
            $data['cert_key'] = $this->upload_cert('cert_key');
        }
        // print_r($data);die;
    	if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
        
        \app\admin\model\AdminLog::record("","",$data,"bbfx_base");
        
      	__success("编辑成功");
    }
    
    public function printerSubmit(){
        $printer = $this->param(['status/d','printer_id/d','printer_type/d','show_delivery/d','show_intact_mobile/d','note/s','qrcode/s']);
        $base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
        
        $data = array("printer"=>iserializer($printer));
        if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
        \app\admin\model\AdminLog::record("","",$data,"bbfx_base");
      	__success("编辑成功");
    }
    
    // 数据概览显示设置
    public function tongjiSubmit(){
        global $_W;
        $params = $this->param(['show_module/a']);
        $tongji = $_W['base']['data']['tongji'];
        $res = \app\common\model\bbfxshop\Common::setSet('tongji',$params);
        
        if($res){
            
        }
        
        \app\admin\model\AdminLog::record("","",$params,"bbfx_base");
        
        __success("编辑成功");
    }
     
    // 电子面单API设置
    public function electronicWaybillSubmit(){
        global $_W;
        $params = $this->param(['status/d','AppCode/s','fahuo_username/s','fahuo_mobile/s','fahuo_address/s','fahuo_region/a','express_id/d','TemplateSize/s','api_params/a']);
        if($params['status'] == 1){
            if(empty($params['AppCode'])){
                __error("请输入阿里云电子面单AppCode");
            }
            if(empty($params['fahuo_username'])){
                __error("请输入寄件人姓名");
            }
            if(empty($params['fahuo_mobile'])){
                __error("请输入寄件人手机号");
            }
            if(empty($params['fahuo_region'][2])){
                __error("请选择发货区域");
            }
            if(empty($params['fahuo_address'])){
                __error("请输入寄件人地址");
            }
            if(empty($params['express_id'])){
                __error("请选择快递公司");
            }
        }
        if(!empty($params['fahuo_region'][2])){
            $params['fahuo_province'] = $params['fahuo_region'][0];
            $params['fahuo_city'] = $params['fahuo_region'][1];
            $params['fahuo_area'] = $params['fahuo_region'][2];
        }
        $res = \app\common\model\bbfxshop\Common::setSet('electronic_waybill',$params);
        
        if($res){
            
        }
        
        \app\admin\model\AdminLog::record("","",$params,"bbfx_base");
        
        __success("编辑成功");
    }
    
    // 阿里云OSS配置
    public function ossSubmit(){
        global $_W;
        $params = $this->param(['status/d','AccessKeyID/s','AccessKeySecret/s','Endpoint/s','BucketName/s']);
        $aliyun_oss = $_W['base']['data']['aliyun_oss'];
        $res = \app\common\model\bbfxshop\Common::setSet('aliyun_oss',$params);
        
        if($res){
            if(!empty($params['BucketName']) && $params['status'] == 1){
                /*
                $is_createBucket = Cache::get($params['BucketName']."_".UNIACID);
                
                if(empty($is_createBucket)){
                    $result = \app\common\model\bbfxshop\AliyunOss::createBucket();
                    print_r($result);die;
                    if($result['code'] != 1){
                        __error($result['message']);
                    }
                    Cache::set($params['BucketName']."_".UNIACID,1);
                }
                */
            }
        }
        
        \app\admin\model\AdminLog::record("","",$params,"bbfx_base");
        
        __success("编辑成功");
    }
    
    // 阿里云物流信息查询配置
    public function deliverySubmit(){
        global $_W;
        $params = $this->param(['status/d','AppKey/s','AppSecret/s','AppCode/s']);
        $aliyun_delivery = $_W['base']['data']['aliyun_delivery'];
        $res = \app\common\model\bbfxshop\Common::setSet('aliyun_delivery',$params);
        
        \app\admin\model\AdminLog::record("","",$params,"bbfx_base");
        
        __success("编辑成功");
    }
    
    public function baseSubmit(){
        $params = $this->param();
        
        $base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
        
        $msg = "";
      	if(!$params['title']){
        	$msg = "请填写平台名称";
        }
        if(!$params['logo']){
        	$msg = "请上传logo";
        }
        
      	if($msg){
        	__error($msg);
        }
      	$params['goodsset']['sellout_icon'] = replaceSiteroot($params['goodsset']['sellout_icon']);
      	$data = array(
        	"title"=>$params['title'],
        	"is_open"=>intval($params['is_open']),
        	"logo"=>$params['logo'],
        	"is_pian"=>intval($params['is_pian']),
        	"is_forcemobile"=>intval($params['is_forcemobile']),
        	"wxapp_login"=>intval($params['wxapp_login']),
        	"service_agreement"=>htmlspecialchars_decode($this->param('service_agreement/h')),
        	"privacy_agreement"=>htmlspecialchars_decode($this->param('privacy_agreement/h')),
        	"block_tips"=>$params['block_tips'],
        	"platform_close_tips"=>$params['platform_close_tips'],
        	"buylevel_tips"=>$params['buylevel_tips'],
        	"stock_remind_num"=>intval($params['stock_remind_num']),
        	"is_gzh_login"=>intval($params['is_gzh_login']),
        	"kefu_link"=>$params['kefu_link'],
        	"orderset"=>iserializer($params['orderset']),
        	"goodsset"=>iserializer($params['goodsset']),
        	"store"=>iserializer($params['store']),
        	"withdrawal"=>iserializer($params['withdrawal']),
        // 	"login_bg"=>$params['login_bg'],
        // 	"font_color"=>$params['font_color'],
        // 	"theme_color"=>$params['theme_color'],
        // 	"btn_color"=>$params['btn_color'],
        // 	"login_template"=>intval($params['login_template']),
        // 	"category_template"=>intval($params['category_template']),
        // 	"fenxiao_template"=>intval($params['fenxiao_template']),
        // 	"texts"=>iserializer($params['texts']),
        );
        
        $data['share_title'] = $params['share_title'];
        $data['share_desc'] = $params['share_desc'];
        $data['share_img'] = $params['share_img'];
        
        $data['logo'] = replaceSiteroot($data['logo']);
        $data['share_img'] = replaceSiteroot($data['share_img']);
    	if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
        \app\admin\model\AdminLog::record("","",$data,"bbfx_base");
      	__success("编辑成功");
    }
    
    public function styleSubmit(){
        $params = $this->param();
        
        $base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
      	
      	$data = array(
        	"font_color"=>$params['font_color'],
        	"theme_color"=>$params['theme_color'],
        	"btn_color"=>$params['btn_color'],
        	"bg_color"=>$params['bg_color'],
        	"login_template"=>intval($params['login_template']),
        	"category_template"=>intval($params['category_template']),
        	"fenxiao_template"=>intval($params['fenxiao_template']),
        	"login_bg"=>replaceSiteroot($params['login_bg']),
        	"top_bg"=>replaceSiteroot($params['top_bg']),
        	// "texts"=>iserializer($params['texts']),
        );
        
    	if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
        \app\admin\model\AdminLog::record("","",$data,"bbfx_base");
      	__success("编辑成功");
    }

    public function textSubmit(){
        $params = $this->param();
        
        $base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
      	$data = array(
        	"texts"=>iserializer($params['base_texts']),
        );
    	if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
        \app\admin\model\AdminLog::record("","",$data,"bbfx_base");

        $fenxiao = Db::name("bbfx_fenxiao")->where(["uniacid"=>UNIACID])->find();
      	$data = array(
        	"texts"=>iserializer($params['fenxiao_texts']),
        );
    	if(!empty($fenxiao)){
            $res = Db::name("bbfx_fenxiao")->where(["uniacid"=>UNIACID,"id"=>$fenxiao['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_fenxiao")->insertGetId($data);
        }
        \app\admin\model\AdminLog::record("","",$data,"bbfx_fenxiao");

      	__success("编辑成功");
    }
    
    public function advertSubmit(){
        $params = $this->param();
        
        
        $base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
        
        $msg = "";
        
        if($params['is_adunitId'] == '1'){
            if(!intval($params['integral'])){
            	$msg = "请填写激励视频广告奖励积分";
            }
        }
      
      	if($msg){
        	__error($msg);
        }
        
        $task_num = intval($params['task_num']);
        $task_num = $task_num<-1?-1:$task_num;
      	
      	$data = array(
      	    "task_num"=>$task_num,
      	    "is_task"=>intval($params['is_task']),
        	"ad_unitId"=>$params['ad_unitId'],
        	"is_adunitId"=>$params['is_adunitId'],
        	"ad_bannar_unitId"=>$params['ad_bannar_unitId'],
        	"ad_interstitialAd_unitId"=>$params['ad_interstitialAd_unitId'],
        	"integral"=>intval($params['integral']),
        );
        
      
    	if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
        
        \app\admin\model\AdminLog::record("","",$data,"bbfx_base");
        
      	__success("编辑成功");
    }
    
    public function messageSubmit(){
        $params = $this->param();
        
        
        $base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
        
        $data = array(
      	    "is_subscribemsg"=>intval($params['is_subscribemsg']),
      	    "updatenotice_status"=>intval($params['updatenotice_status']),
      	    "updatenotice_tips"=>$params['updatenotice_tips'],
      	    "subscribemsg"=>iserializer($params['subscribemsg']),
      	    "sms"=>iserializer($params['sms']),
      	    "admin"=>$params['admin'],
      	    "wx_appid"=>$params['wx_appid'],
      	    "wx_secret"=>$params['wx_secret'],
      	    "wx_domain"=>$params['wx_domain'],
      	    "notice_type"=>intval($params['notice_type']),
        );
      
    	if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
        \app\admin\model\AdminLog::record("","",$data,"bbfx_base");
      	__success("编辑成功");
    }
    
    public function msgVariableList(){
        $params = $this->param();
        
        $variableList = \app\common\model\bbfxshop\Message::getVariableList();
        
        __success("操作成功",['variableList'=>$variableList]);
    }
    
    
    public function textSubmit1(){
        $params = $this->param();
        
        
        $base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
        
        $text = $params['text'];
        
        $text = iserializer($text);
        $data = array("text_replace"=>$text);
    	if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
        \app\admin\model\AdminLog::record("","",$data,"bbfx_base");
      	__success("编辑成功");
    }
    
    public function signSubmit(){
        $params = $this->param();
        
        $base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
        
        $msg = "";
      	if($params['is_sign'] == "1"){
        	if(!$params['first_reward']){
            	$msg = "请填写首次签到奖励";
            }
        	if(!$params['daily_reward']){
            	$msg = "请填写日常签到奖励";
            }
        }
        
      	if($msg){
        	__error($msg);
        }
      	
      	$data = array(
        	"is_sign"=>$params['is_sign'],
        	"first_reward"=>$params['first_reward'],
        	"daily_reward"=>$params['daily_reward']
        );
      
    	if(!empty($base)){
            $res = Db::name("bbfx_base")->where(["uniacid"=>UNIACID,"id"=>$base['id']])->update($data);
        }
      	else{
          	$data['uniacid'] = UNIACID;
            $res = Db::name("bbfx_base")->insertGetId($data);
        }
        \app\admin\model\AdminLog::record("","",$data,"bbfx_base");
      	__success("编辑成功");
    }
    
    public function getSignrule(){
        $params = $this->param();
        
        $sign_rule = Db::name("bbfx_sign_rule")->where(["uniacid"=>UNIACID])->order('day asc')->select();
        
        __success("",$sign_rule);
    }
    
    public function sign_del(){
        $params = $this->param();
        
        
        $base = Db::name("bbfx_base")->where(["uniacid"=>UNIACID])->find();
        
        $id = trim($params['id']);
        if(!$id){
            __error("id错误");  
        }
        $result = Db::name("bbfx_sign_rule")->where(['uniacid' => UNIACID,"id"=>$id])->find();
        if (!empty($result)) {
    	    __success('删除成功');
        }
        else{
            __error("删除失败"); 
        }
    }
    
    public function signPost(){
        $params = $this->param();
        
        
        $id = intval($params['id']);
        
        $type = intval($params['type']);
        $day = intval($params['day']);
        $integral = intval($params['integral']);
        $sign_it = Db::name("bbfx_sign_rule")->where(["uniacid"=>UNIACID,"type"=>$type,"day"=>$day])->find();
        
        $msg = "";
        
        if($day <= 0){
            if($type == "1"){
                $msg = "请填写连续签到天数";
            }
            else{
                $msg = "请填写总签到天数";
            }
        }
        if($integral <= 0){
            if($type == "2"){
                $msg = "请填写连续签到奖励";
            }
            else{
                $msg = "请填写总签到奖励".$integral;
            }
        }
        
        if(!empty($sign_it) && $sign_it['id'] != $id){
            if($type == "1"){
                $msg = "已有相同连续签到天数";
            }
            else{
                $msg = "已有相同连续签到天数总签到天数";
            }
        }
        
        
        if($msg){
            __error($msg);
        }
        $data = array("day"=>$day,"type"=>$type,"integral"=>$integral,"uniacid"=>UNIACID);
        if(!empty($id)){
            $res = Db::name("bbfx_sign_rule")->where(['id'=>$id])->update($data);
        }
        else{
            $res = Db::name("bbfx_sign_rule")->insertGetId($data);
        }
        
        if($res){
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
}